/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.KeyframeSet;
import java.util.ArrayList;

class IntKeyframeSet
extends KeyframeSet {
    private int firstValue;
    private int lastValue;
    private int deltaValue;
    private boolean firstTime = true;

    public IntKeyframeSet(Keyframe.IntKeyframe ... keyframes) {
        super(keyframes);
    }

    public Object getValue(float fraction) {
        return this.getIntValue(fraction);
    }

    public IntKeyframeSet clone() {
        ArrayList keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe.IntKeyframe[] newKeyframes = new Keyframe.IntKeyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = (Keyframe.IntKeyframe)((Keyframe)keyframes.get(i)).clone();
        }
        IntKeyframeSet newSet = new IntKeyframeSet(newKeyframes);
        return newSet;
    }

    public int getIntValue(float fraction) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(0)).getIntValue();
                this.lastValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(1)).getIntValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                fraction = this.mInterpolator.getInterpolation(fraction);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + (int)(fraction * (float)this.deltaValue);
            }
            return ((Number)this.mEvaluator.evaluate(fraction, this.firstValue, this.lastValue)).intValue();
        }
        if (fraction <= 0.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator2 = nextKeyframe.getInterpolator();
            if (interpolator2 != null) {
                fraction = interpolator2.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
        }
        if (fraction >= 1.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator3 = nextKeyframe.getInterpolator();
            if (interpolator3 != null) {
                fraction = interpolator3.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
        }
        Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(i);
            if (fraction < nextKeyframe.getFraction()) {
                Interpolator interpolator4 = nextKeyframe.getInterpolator();
                if (interpolator4 != null) {
                    fraction = interpolator4.getInterpolation(fraction);
                }
                float intervalFraction = (fraction - prevKeyframe.getFraction()) / (nextKeyframe.getFraction() - prevKeyframe.getFraction());
                int prevValue = prevKeyframe.getIntValue();
                int nextValue = nextKeyframe.getIntValue();
                return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
            }
            prevKeyframe = nextKeyframe;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue()).intValue();
    }
}

