/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.IBinder;
import android.util.EventLog;
import android.view.ContextMenu;
import android.view.View;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuDialogHelper;
import com.actionbarsherlock.view.ContextMenu;
import java.lang.reflect.Method;

public class ContextMenuBuilder
extends MenuBuilder
implements ContextMenu {
    private ContextMenu.ContextMenuInfo mContextMenuInfo;
    private ContextMenuListener mListener;

    public ContextMenuBuilder(Context context, ContextMenuListener listener) {
        super(context);
        this.setContextMenuListener(listener);
    }

    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo(View view) {
        if (view instanceof ContextMenuInfoGetter) {
            return ((ContextMenuInfoGetter)view).getContextMenuInfo();
        }
        ContextMenu.ContextMenuInfo menuInfo = null;
        try {
            Method method = View.class.getDeclaredMethod("getContextMenuInfo", new Class[0]);
            method.setAccessible(true);
            menuInfo = (ContextMenu.ContextMenuInfo)method.invoke((Object)view, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return menuInfo;
    }

    public ContextMenuListener getContextMenuListener() {
        return this.mListener;
    }

    public void setContextMenuListener(ContextMenuListener listener) {
        this.mListener = listener;
    }

    public ContextMenu setHeaderIcon(Drawable icon) {
        return (ContextMenu)((Object)super.setHeaderIconInt(icon));
    }

    public ContextMenu setHeaderIcon(int iconRes) {
        return (ContextMenu)((Object)super.setHeaderIconInt(iconRes));
    }

    public ContextMenu setHeaderTitle(CharSequence title) {
        return (ContextMenu)((Object)super.setHeaderTitleInt(title));
    }

    public ContextMenu setHeaderTitle(int titleRes) {
        return (ContextMenu)((Object)super.setHeaderTitleInt(titleRes));
    }

    public ContextMenu setHeaderView(View view) {
        return (ContextMenu)((Object)super.setHeaderViewInt(view));
    }

    @SuppressLint(value={"NewApi"})
    public MenuDialogHelper show(View originalView, IBinder token) {
        if (this.mListener == null) {
            throw new IllegalStateException("Cannot show context menu without reference on ContextMenuListener");
        }
        this.mContextMenuInfo = this.getContextMenuInfo(originalView);
        this.mListener.onCreateContextMenu(this, originalView, this.mContextMenuInfo);
        if (this.getVisibleItems().size() > 0) {
            if (Build.VERSION.SDK_INT >= 8) {
                EventLog.writeEvent((int)50001, (int)1);
            }
            MenuDialogHelper helper = new MenuDialogHelper(this);
            helper.show(token);
            return helper;
        }
        return null;
    }

    public static interface ContextMenuInfoGetter {
        public ContextMenu.ContextMenuInfo getContextMenuInfo();
    }
}

