/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.actionbarsherlock.internal.view.menu.ContextMenuBuilder;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuDialogHelper;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.view.ContextMenu;
import com.actionbarsherlock.view.MenuItem;
import org.holoeverywhere.HoloEverywhere;
import org.holoeverywhere.widget.FrameLayout;

public class ContextMenuDecorView
extends FrameLayout
implements MenuPresenter.Callback,
MenuBuilder.Callback {
    private ContextMenuBuilder mContextMenu;
    private ContextMenuListener mListener;
    private MenuDialogHelper mMenuDialogHelper;
    private ContextMenuListenersProvider mProvider;

    public ContextMenuDecorView(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onContextMenuClosed((ContextMenu)((Object)menu));
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return false;
    }

    public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
        if (this.mListener == null) {
            return false;
        }
        if (menu instanceof ContextMenuBuilder && item instanceof MenuItemImpl) {
            ((MenuItemImpl)item).setMenuInfo(((ContextMenuBuilder)menu).getContextMenuInfo());
        }
        return this.mListener.onContextItemSelected(item);
    }

    public void onMenuModeChange(MenuBuilder menu) {
    }

    public boolean onOpenSubMenu(MenuBuilder subMenu) {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    public void setProvider(ContextMenuListenersProvider provider) {
        this.mProvider = provider;
    }

    public boolean showContextMenuForChild(View originalView) {
        if (HoloEverywhere.WRAP_TO_NATIVE_CONTEXT_MENU) {
            return super.showContextMenuForChild(originalView);
        }
        this.mListener = this.mProvider.getContextMenuListener(originalView);
        if (this.mListener == null) {
            return false;
        }
        if (this.mContextMenu == null) {
            this.mContextMenu = new ContextMenuBuilder(this.getContext(), this.mListener);
            this.mContextMenu.setCallback(this);
        } else {
            this.mContextMenu.clearAll();
            this.mContextMenu.setContextMenuListener(this.mListener);
        }
        this.mMenuDialogHelper = this.mContextMenu.show(originalView, originalView.getWindowToken());
        if (this.mMenuDialogHelper != null) {
            this.mMenuDialogHelper.setPresenterCallback(this);
            return true;
        }
        return false;
    }

    public static interface ContextMenuListenersProvider {
        public ContextMenuListener getContextMenuListener(View var1);
    }
}

