/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.actionbarsherlock.internal.widget.IcsLinearLayout;

public class TabsLinearLayout
extends IcsLinearLayout {
    private static final int[] R_styleable_LinearLayout = new int[]{16843476};
    private static final int LinearLayout_measureWithLargestChild = 0;
    private boolean mUseLargestChild;

    public TabsLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R_styleable_LinearLayout);
        this.mUseLargestChild = a.getBoolean(0, false);
        a.recycle();
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    public void setMeasureWithLargestChildEnabled(boolean enabled) {
        this.mUseLargestChild = enabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int orientation;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int childCount = this.getChildCount();
        if (childCount <= 2) {
            return;
        }
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (this.mUseLargestChild && mode == 0 && (orientation = this.getOrientation()) == 0) {
            this.useLargestChildHorizontal();
        }
    }

    private void useLargestChildHorizontal() {
        int childCount = this.getChildCount();
        int largestChildWidth = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            largestChildWidth = Math.max(child.getMeasuredWidth(), largestChildWidth);
        }
        int totalWidth = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            float childExtra = lp.weight;
            if (childExtra > 0.0f) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)largestChildWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
                totalWidth += largestChildWidth;
            } else {
                totalWidth += child.getMeasuredWidth();
            }
            totalWidth += lp.leftMargin + lp.rightMargin;
        }
        this.setMeasuredDimension(totalWidth += this.getPaddingLeft() + this.getPaddingRight(), this.getMeasuredHeight());
    }
}

