/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.facebook.AccessTokenSource;
import com.facebook.LoggingBehavior;
import com.facebook.Settings;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String ACCESS_TOKEN_KEY = "access_token";
    static final String EXPIRES_IN_KEY = "expires_in";
    private static final Date MIN_DATE = new Date(Long.MIN_VALUE);
    private static final Date MAX_DATE;
    private static final Date DEFAULT_EXPIRATION_TIME;
    private static final Date DEFAULT_LAST_REFRESH_TIME;
    private static final AccessTokenSource DEFAULT_ACCESS_TOKEN_SOURCE;
    private static final Date ALREADY_EXPIRED_EXPIRATION_TIME;
    private final Date expires;
    private final List<String> permissions;
    private final String token;
    private final AccessTokenSource source;
    private final Date lastRefresh;

    AccessToken(String token, Date expires, List<String> permissions, AccessTokenSource source, Date lastRefresh) {
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        this.expires = expires;
        this.permissions = Collections.unmodifiableList(permissions);
        this.token = token;
        this.source = source;
        this.lastRefresh = lastRefresh;
    }

    public String getToken() {
        return this.token;
    }

    public Date getExpires() {
        return this.expires;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public AccessTokenSource getSource() {
        return this.source;
    }

    public Date getLastRefresh() {
        return this.lastRefresh;
    }

    public static AccessToken createFromExistingAccessToken(String accessToken, Date expirationTime, Date lastRefreshTime, AccessTokenSource accessTokenSource, List<String> permissions) {
        if (expirationTime == null) {
            expirationTime = DEFAULT_EXPIRATION_TIME;
        }
        if (lastRefreshTime == null) {
            lastRefreshTime = DEFAULT_LAST_REFRESH_TIME;
        }
        if (accessTokenSource == null) {
            accessTokenSource = DEFAULT_ACCESS_TOKEN_SOURCE;
        }
        return new AccessToken(accessToken, expirationTime, permissions, accessTokenSource, lastRefreshTime);
    }

    public static AccessToken createFromNativeLinkingIntent(Intent intent) {
        Validate.notNull(intent, "intent");
        if (intent.getExtras() == null) {
            return null;
        }
        return AccessToken.createFromBundle(null, intent.getExtras(), AccessTokenSource.FACEBOOK_APPLICATION_WEB, new Date());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{AccessToken");
        builder.append(" token:").append(this.tokenToString());
        this.appendPermissions(builder);
        builder.append("}");
        return builder.toString();
    }

    static AccessToken createEmptyToken(List<String> permissions) {
        return new AccessToken("", ALREADY_EXPIRED_EXPIRATION_TIME, permissions, AccessTokenSource.NONE, DEFAULT_LAST_REFRESH_TIME);
    }

    static AccessToken createFromString(String token, List<String> permissions, AccessTokenSource source) {
        return new AccessToken(token, DEFAULT_EXPIRATION_TIME, permissions, source, DEFAULT_LAST_REFRESH_TIME);
    }

    static AccessToken createFromNativeLogin(Bundle bundle, AccessTokenSource source) {
        Date expires = AccessToken.getBundleLongAsDate(bundle, "com.facebook.platform.extra.EXPIRES_SECONDS_SINCE_EPOCH", new Date(0L));
        ArrayList permissions = bundle.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
        String token = bundle.getString("com.facebook.platform.extra.ACCESS_TOKEN");
        return AccessToken.createNew(permissions, token, expires, source);
    }

    static AccessToken createFromWebBundle(List<String> requestedPermissions, Bundle bundle, AccessTokenSource source) {
        Date expires = AccessToken.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, new Date());
        String token = bundle.getString(ACCESS_TOKEN_KEY);
        return AccessToken.createNew(requestedPermissions, token, expires, source);
    }

    @SuppressLint(value={"FieldGetter"})
    static AccessToken createFromRefresh(AccessToken current, Bundle bundle) {
        assert (current.source == AccessTokenSource.FACEBOOK_APPLICATION_WEB || current.source == AccessTokenSource.FACEBOOK_APPLICATION_NATIVE || current.source == AccessTokenSource.FACEBOOK_APPLICATION_SERVICE);
        Date expires = AccessToken.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, new Date(0L));
        String token = bundle.getString(ACCESS_TOKEN_KEY);
        return AccessToken.createNew(current.getPermissions(), token, expires, current.source);
    }

    static AccessToken createFromTokenWithRefreshedPermissions(AccessToken token, List<String> permissions) {
        return new AccessToken(token.token, token.expires, permissions, token.source, token.lastRefresh);
    }

    private static AccessToken createNew(List<String> requestedPermissions, String accessToken, Date expires, AccessTokenSource source) {
        if (Utility.isNullOrEmpty(accessToken) || expires == null) {
            return AccessToken.createEmptyToken(requestedPermissions);
        }
        return new AccessToken(accessToken, expires, requestedPermissions, source, new Date());
    }

    static AccessToken createFromCache(Bundle bundle) {
        ArrayList originalPermissions = bundle.getStringArrayList("com.facebook.TokenCachingStrategy.Permissions");
        List<Object> permissions = originalPermissions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(originalPermissions));
        return new AccessToken(bundle.getString("com.facebook.TokenCachingStrategy.Token"), TokenCachingStrategy.getDate(bundle, "com.facebook.TokenCachingStrategy.ExpirationDate"), permissions, TokenCachingStrategy.getSource(bundle), TokenCachingStrategy.getDate(bundle, "com.facebook.TokenCachingStrategy.LastRefreshDate"));
    }

    Bundle toCacheBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("com.facebook.TokenCachingStrategy.Token", this.token);
        TokenCachingStrategy.putDate(bundle, "com.facebook.TokenCachingStrategy.ExpirationDate", this.expires);
        bundle.putStringArrayList("com.facebook.TokenCachingStrategy.Permissions", new ArrayList<String>(this.permissions));
        bundle.putSerializable("com.facebook.TokenCachingStrategy.AccessTokenSource", (Serializable)((Object)this.source));
        TokenCachingStrategy.putDate(bundle, "com.facebook.TokenCachingStrategy.LastRefreshDate", this.lastRefresh);
        return bundle;
    }

    boolean isInvalid() {
        return Utility.isNullOrEmpty(this.token) || new Date().after(this.expires);
    }

    private static AccessToken createFromBundle(List<String> requestedPermissions, Bundle bundle, AccessTokenSource source, Date expirationBase) {
        String token = bundle.getString(ACCESS_TOKEN_KEY);
        Date expires = AccessToken.getBundleLongAsDate(bundle, EXPIRES_IN_KEY, expirationBase);
        if (Utility.isNullOrEmpty(token) || expires == null) {
            return null;
        }
        return new AccessToken(token, expires, requestedPermissions, source, new Date());
    }

    private String tokenToString() {
        if (this.token == null) {
            return "null";
        }
        if (Settings.isLoggingBehaviorEnabled(LoggingBehavior.INCLUDE_ACCESS_TOKENS)) {
            return this.token;
        }
        return "ACCESS_TOKEN_REMOVED";
    }

    private void appendPermissions(StringBuilder builder) {
        builder.append(" permissions:");
        if (this.permissions == null) {
            builder.append("null");
        } else {
            builder.append("[");
            builder.append(TextUtils.join((CharSequence)", ", this.permissions));
            builder.append("]");
        }
    }

    private Object writeReplace() {
        return new SerializationProxyV1(this.token, this.expires, this.permissions, this.source, this.lastRefresh);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Cannot readObject, serialization proxy required");
    }

    private static Date getBundleLongAsDate(Bundle bundle, String key, Date dateBase) {
        if (bundle == null) {
            return null;
        }
        long secondsFromBase = Long.MIN_VALUE;
        Object secondsObject = bundle.get(key);
        if (secondsObject instanceof Long) {
            secondsFromBase = (Long)secondsObject;
        } else if (secondsObject instanceof String) {
            try {
                secondsFromBase = Long.parseLong((String)secondsObject);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        if (secondsFromBase == 0L) {
            return new Date(Long.MAX_VALUE);
        }
        return new Date(dateBase.getTime() + secondsFromBase * 1000L);
    }

    static {
        DEFAULT_EXPIRATION_TIME = MAX_DATE = new Date(Long.MAX_VALUE);
        DEFAULT_LAST_REFRESH_TIME = new Date();
        DEFAULT_ACCESS_TOKEN_SOURCE = AccessTokenSource.FACEBOOK_APPLICATION_WEB;
        ALREADY_EXPIRED_EXPIRATION_TIME = MIN_DATE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxyV1
    implements Serializable {
        private static final long serialVersionUID = -2488473066578201069L;
        private final Date expires;
        private final List<String> permissions;
        private final String token;
        private final AccessTokenSource source;
        private final Date lastRefresh;

        private SerializationProxyV1(String token, Date expires, List<String> permissions, AccessTokenSource source, Date lastRefresh) {
            this.expires = expires;
            this.permissions = permissions;
            this.token = token;
            this.source = source;
            this.lastRefresh = lastRefresh;
        }

        private Object readResolve() {
            return new AccessToken(this.token, this.expires, this.permissions, this.source, this.lastRefresh);
        }
    }
}

