/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.CookieSyncManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.GetTokenClient;
import com.facebook.HttpMethod;
import com.facebook.NativeProtocol;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.model.GraphMultiResult;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.GraphUser;
import com.facebook.widget.WebDialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.holoeverywhere.addon.facebook.R;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.preference.SharedPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthorizationClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "Facebook-AuthorizationClient";
    private static final String WEB_VIEW_AUTH_HANDLER_STORE = "com.facebook.AuthorizationClient.WebViewAuthHandler.TOKEN_STORE_KEY";
    private static final String WEB_VIEW_AUTH_HANDLER_TOKEN_KEY = "TOKEN";
    List<AuthHandler> handlersToTry;
    AuthHandler currentHandler;
    transient Context context;
    transient StartActivityDelegate startActivityDelegate;
    transient OnCompletedListener onCompletedListener;
    transient BackgroundProcessingListener backgroundProcessingListener;
    transient boolean checkedInternetPermission;
    AuthorizationRequest pendingRequest;

    AuthorizationClient() {
    }

    void setContext(Context context) {
        this.context = context;
        this.startActivityDelegate = null;
    }

    void setContext(final Activity activity) {
        this.context = activity;
        this.startActivityDelegate = new StartActivityDelegate(){

            public void startActivityForResult(Intent intent, int requestCode) {
                activity.startActivityForResult(intent, requestCode);
            }

            public Activity getActivityContext() {
                return activity;
            }
        };
    }

    void startOrContinueAuth(AuthorizationRequest request) {
        if (this.getInProgress()) {
            this.continueAuth();
        } else {
            this.authorize(request);
        }
    }

    void authorize(AuthorizationRequest request) {
        if (request == null) {
            return;
        }
        if (this.pendingRequest != null) {
            throw new FacebookException("Attempted to authorize while a request is pending.");
        }
        if (request.needsNewTokenValidation() && !this.checkInternetPermission()) {
            return;
        }
        this.pendingRequest = request;
        this.handlersToTry = this.getHandlerTypes(request);
        this.tryNextHandler();
    }

    void continueAuth() {
        if (this.pendingRequest == null || this.currentHandler == null) {
            throw new FacebookException("Attempted to continue authorization without a pending request.");
        }
        if (this.currentHandler.needsRestart()) {
            this.currentHandler.cancel();
            this.tryCurrentHandler();
        }
    }

    boolean getInProgress() {
        return this.pendingRequest != null && this.currentHandler != null;
    }

    void cancelCurrentHandler() {
        if (this.currentHandler != null) {
            this.currentHandler.cancel();
        }
    }

    boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.pendingRequest.getRequestCode()) {
            return this.currentHandler.onActivityResult(requestCode, resultCode, data);
        }
        return false;
    }

    private List<AuthHandler> getHandlerTypes(AuthorizationRequest request) {
        ArrayList<AuthHandler> handlers = new ArrayList<AuthHandler>();
        SessionLoginBehavior behavior = request.getLoginBehavior();
        if (behavior.allowsKatanaAuth()) {
            if (!request.isLegacy()) {
                handlers.add(new GetTokenAuthHandler());
                handlers.add(new KatanaLoginDialogAuthHandler());
            }
            handlers.add(new KatanaProxyAuthHandler());
        }
        if (behavior.allowsWebViewAuth()) {
            handlers.add(new WebViewAuthHandler());
        }
        return handlers;
    }

    boolean checkInternetPermission() {
        if (this.checkedInternetPermission) {
            return true;
        }
        int permissionCheck = this.checkPermission("android.permission.INTERNET");
        if (permissionCheck != 0) {
            String errorType = this.context.getString(R.string.com_facebook_internet_permission_error_title);
            String errorDescription = this.context.getString(R.string.com_facebook_internet_permission_error_message);
            this.complete(Result.createErrorResult(errorType, errorDescription));
            return false;
        }
        this.checkedInternetPermission = true;
        return true;
    }

    void tryNextHandler() {
        while (this.handlersToTry != null && !this.handlersToTry.isEmpty()) {
            this.currentHandler = this.handlersToTry.remove(0);
            boolean started = this.tryCurrentHandler();
            if (!started) continue;
            return;
        }
        if (this.pendingRequest != null) {
            this.completeWithFailure();
        }
    }

    private void completeWithFailure() {
        this.complete(Result.createErrorResult("Login attempt failed.", null));
    }

    boolean tryCurrentHandler() {
        if (this.currentHandler.needsInternetPermission() && !this.checkInternetPermission()) {
            return false;
        }
        return this.currentHandler.tryAuthorize(this.pendingRequest);
    }

    void completeAndValidate(Result outcome) {
        if (outcome.token != null && this.pendingRequest.needsNewTokenValidation()) {
            this.validateSameFbidAndFinish(outcome);
        } else {
            this.complete(outcome);
        }
    }

    void complete(Result outcome) {
        this.handlersToTry = null;
        this.currentHandler = null;
        this.pendingRequest = null;
        this.notifyOnCompleteListener(outcome);
    }

    OnCompletedListener getOnCompletedListener() {
        return this.onCompletedListener;
    }

    void setOnCompletedListener(OnCompletedListener onCompletedListener) {
        this.onCompletedListener = onCompletedListener;
    }

    BackgroundProcessingListener getBackgroundProcessingListener() {
        return this.backgroundProcessingListener;
    }

    void setBackgroundProcessingListener(BackgroundProcessingListener backgroundProcessingListener) {
        this.backgroundProcessingListener = backgroundProcessingListener;
    }

    StartActivityDelegate getStartActivityDelegate() {
        if (this.startActivityDelegate != null) {
            return this.startActivityDelegate;
        }
        if (this.pendingRequest != null) {
            return new StartActivityDelegate(){

                public void startActivityForResult(Intent intent, int requestCode) {
                    AuthorizationClient.this.pendingRequest.getStartActivityDelegate().startActivityForResult(intent, requestCode);
                }

                public Activity getActivityContext() {
                    return AuthorizationClient.this.pendingRequest.getStartActivityDelegate().getActivityContext();
                }
            };
        }
        return null;
    }

    int checkPermission(String permission) {
        return this.context.checkCallingOrSelfPermission(permission);
    }

    void validateSameFbidAndFinish(Result pendingResult) {
        if (pendingResult.token == null) {
            throw new FacebookException("Can't validate without a token");
        }
        RequestBatch batch = this.createReauthValidationBatch(pendingResult);
        this.notifyBackgroundProcessingStart();
        batch.executeAsync();
    }

    RequestBatch createReauthValidationBatch(final Result pendingResult) {
        final ArrayList fbids = new ArrayList();
        final ArrayList tokenPermissions = new ArrayList();
        String newToken = pendingResult.token.getToken();
        Request.Callback meCallback = new Request.Callback(){

            public void onCompleted(Response response) {
                try {
                    GraphUser user = response.getGraphObjectAs(GraphUser.class);
                    if (user != null) {
                        fbids.add(user.getId());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        String validateSameFbidAsToken = this.pendingRequest.getPreviousAccessToken();
        Request requestCurrentTokenMe = this.createGetProfileIdRequest(validateSameFbidAsToken);
        requestCurrentTokenMe.setCallback(meCallback);
        Request requestNewTokenMe = this.createGetProfileIdRequest(newToken);
        requestNewTokenMe.setCallback(meCallback);
        Request requestCurrentTokenPermissions = this.createGetPermissionsRequest(validateSameFbidAsToken);
        requestCurrentTokenPermissions.setCallback(new Request.Callback(){

            public void onCompleted(Response response) {
                try {
                    GraphObjectList<GraphObject> data;
                    GraphMultiResult result = response.getGraphObjectAs(GraphMultiResult.class);
                    if (result != null && (data = result.getData()) != null && data.size() == 1) {
                        GraphObject permissions = (GraphObject)data.get(0);
                        tokenPermissions.addAll(permissions.asMap().keySet());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        RequestBatch batch = new RequestBatch(requestCurrentTokenMe, requestNewTokenMe, requestCurrentTokenPermissions);
        batch.setBatchApplicationId(this.pendingRequest.getApplicationId());
        batch.addCallback(new RequestBatch.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onBatchCompleted(RequestBatch batch) {
                try {
                    Result result = null;
                    if (fbids.size() == 2 && fbids.get(0) != null && fbids.get(1) != null && ((String)fbids.get(0)).equals(fbids.get(1))) {
                        AccessToken tokenWithPermissions = AccessToken.createFromTokenWithRefreshedPermissions(pendingResult.token, tokenPermissions);
                        result = Result.createTokenResult(tokenWithPermissions);
                    } else {
                        result = Result.createErrorResult("User logged in as different Facebook user.", null);
                    }
                    AuthorizationClient.this.complete(result);
                }
                catch (Exception ex) {
                    AuthorizationClient.this.complete(Result.createErrorResult("Caught exception", ex.getMessage()));
                }
                finally {
                    AuthorizationClient.this.notifyBackgroundProcessingStop();
                }
            }
        });
        return batch;
    }

    Request createGetPermissionsRequest(String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", "id");
        parameters.putString("access_token", accessToken);
        return new Request(null, "me/permissions", parameters, HttpMethod.GET, null);
    }

    Request createGetProfileIdRequest(String accessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("fields", "id");
        parameters.putString("access_token", accessToken);
        return new Request(null, "me", parameters, HttpMethod.GET, null);
    }

    private void notifyOnCompleteListener(Result outcome) {
        if (this.onCompletedListener != null) {
            this.onCompletedListener.onCompleted(outcome);
        }
    }

    private void notifyBackgroundProcessingStart() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStarted();
        }
    }

    private void notifyBackgroundProcessingStop() {
        if (this.backgroundProcessingListener != null) {
            this.backgroundProcessingListener.onBackgroundProcessingStopped();
        }
    }

    static class Result
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Code code;
        final AccessToken token;
        final String errorMessage;

        private Result(Code code, AccessToken token, String errorMessage) {
            this.token = token;
            this.errorMessage = errorMessage;
            this.code = code;
        }

        static Result createTokenResult(AccessToken token) {
            return new Result(Code.SUCCESS, token, null);
        }

        static Result createCancelResult(String message) {
            return new Result(Code.CANCEL, null, message);
        }

        static Result createErrorResult(String errorType, String errorDescription) {
            String message = errorType;
            if (errorDescription != null) {
                message = message + ": " + errorDescription;
            }
            return new Result(Code.ERROR, null, message);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Code {
            SUCCESS,
            CANCEL,
            ERROR;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AuthorizationRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final transient StartActivityDelegate startActivityDelegate;
        private SessionLoginBehavior loginBehavior;
        private int requestCode;
        private boolean isLegacy = false;
        private List<String> permissions;
        private SessionDefaultAudience defaultAudience;
        private String applicationId;
        private String previousAccessToken;

        AuthorizationRequest(SessionLoginBehavior loginBehavior, int requestCode, boolean isLegacy, List<String> permissions, SessionDefaultAudience defaultAudience, String applicationId, String validateSameFbidAsToken, StartActivityDelegate startActivityDelegate) {
            this.loginBehavior = loginBehavior;
            this.requestCode = requestCode;
            this.isLegacy = isLegacy;
            this.permissions = permissions;
            this.defaultAudience = defaultAudience;
            this.applicationId = applicationId;
            this.previousAccessToken = validateSameFbidAsToken;
            this.startActivityDelegate = startActivityDelegate;
        }

        StartActivityDelegate getStartActivityDelegate() {
            return this.startActivityDelegate;
        }

        List<String> getPermissions() {
            return this.permissions;
        }

        void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        SessionLoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        int getRequestCode() {
            return this.requestCode;
        }

        SessionDefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        String getApplicationId() {
            return this.applicationId;
        }

        boolean isLegacy() {
            return this.isLegacy;
        }

        void setIsLegacy(boolean isLegacy) {
            this.isLegacy = isLegacy;
        }

        String getPreviousAccessToken() {
            return this.previousAccessToken;
        }

        boolean needsNewTokenValidation() {
            return this.previousAccessToken != null && !this.isLegacy;
        }
    }

    static class AuthDialogBuilder
    extends WebDialog.Builder {
        private static final String OAUTH_DIALOG = "oauth";
        static final String REDIRECT_URI = "fbconnect://success";

        public AuthDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, OAUTH_DIALOG, parameters);
        }

        public WebDialog build() {
            Bundle parameters = this.getParameters();
            parameters.putString("redirect_uri", REDIRECT_URI);
            parameters.putString("client_id", this.getApplicationId());
            return new WebDialog(this.getContext(), OAUTH_DIALOG, parameters, this.getTheme(), this.getListener());
        }
    }

    class KatanaProxyAuthHandler
    extends KatanaAuthHandler {
        private static final long serialVersionUID = 1L;

        KatanaProxyAuthHandler() {
        }

        boolean tryAuthorize(AuthorizationRequest request) {
            Intent intent = NativeProtocol.createProxyAuthIntent(AuthorizationClient.this.context, request.getApplicationId(), request.getPermissions());
            return this.tryIntent(intent, request.getRequestCode());
        }

        boolean onActivityResult(int requestCode, int resultCode, Intent data) {
            Result outcome = data == null ? Result.createCancelResult("Operation canceled") : (resultCode == 0 ? Result.createCancelResult(data.getStringExtra("error")) : (resultCode != -1 ? Result.createErrorResult("Unexpected resultCode from authorization.", null) : this.handleResultOk(data)));
            if (outcome != null) {
                AuthorizationClient.this.completeAndValidate(outcome);
            } else {
                AuthorizationClient.this.tryNextHandler();
            }
            return true;
        }

        private Result handleResultOk(Intent data) {
            Bundle extras = data.getExtras();
            String error = extras.getString("error");
            if (error == null) {
                error = extras.getString("error_type");
            }
            if (error == null) {
                AccessToken token = AccessToken.createFromWebBundle(AuthorizationClient.this.pendingRequest.getPermissions(), extras, AccessTokenSource.FACEBOOK_APPLICATION_WEB);
                return Result.createTokenResult(token);
            }
            if (ServerProtocol.errorsProxyAuthDisabled.contains(error)) {
                return null;
            }
            if (ServerProtocol.errorsUserCanceled.contains(error)) {
                return Result.createCancelResult(null);
            }
            return Result.createErrorResult(error, extras.getString("error_description"));
        }
    }

    class KatanaLoginDialogAuthHandler
    extends KatanaAuthHandler {
        private static final long serialVersionUID = 1L;

        KatanaLoginDialogAuthHandler() {
        }

        boolean tryAuthorize(AuthorizationRequest request) {
            Intent intent = NativeProtocol.createLoginDialog20121101Intent(AuthorizationClient.this.context, request.getApplicationId(), new ArrayList<String>(request.getPermissions()), request.getDefaultAudience().getNativeProtocolAudience());
            return this.tryIntent(intent, request.getRequestCode());
        }

        boolean onActivityResult(int requestCode, int resultCode, Intent data) {
            Object outcome = data == null ? Result.createCancelResult("Operation canceled") : (NativeProtocol.isServiceDisabledResult20121101(data) ? null : (resultCode == 0 ? Result.createCancelResult(data.getStringExtra("com.facebook.platform.status.ERROR_DESCRIPTION")) : (resultCode != -1 ? Result.createErrorResult("Unexpected resultCode from authorization.", null) : this.handleResultOk(data))));
            if (outcome != null) {
                AuthorizationClient.this.completeAndValidate((Result)outcome);
            } else {
                AuthorizationClient.this.tryNextHandler();
            }
            return true;
        }

        private Result handleResultOk(Intent data) {
            Bundle extras = data.getExtras();
            String errorType = extras.getString("com.facebook.platform.status.ERROR_TYPE");
            if (errorType == null) {
                return Result.createTokenResult(AccessToken.createFromNativeLogin(extras, AccessTokenSource.FACEBOOK_APPLICATION_NATIVE));
            }
            if ("ServiceDisabled".equals(errorType)) {
                return null;
            }
            if ("UserCanceled".equals(errorType)) {
                return Result.createCancelResult(null);
            }
            return Result.createErrorResult(errorType, extras.getString("error_description"));
        }
    }

    abstract class KatanaAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;

        KatanaAuthHandler() {
        }

        protected boolean tryIntent(Intent intent, int requestCode) {
            if (intent == null) {
                return false;
            }
            try {
                AuthorizationClient.this.getStartActivityDelegate().startActivityForResult(intent, requestCode);
            }
            catch (ActivityNotFoundException e) {
                return false;
            }
            return true;
        }
    }

    class GetTokenAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;
        private transient GetTokenClient getTokenClient;

        GetTokenAuthHandler() {
        }

        void cancel() {
            if (this.getTokenClient != null) {
                this.getTokenClient.cancel();
                this.getTokenClient = null;
            }
        }

        boolean tryAuthorize(final AuthorizationRequest request) {
            this.getTokenClient = new GetTokenClient(AuthorizationClient.this.context, request.getApplicationId());
            if (!this.getTokenClient.start()) {
                return false;
            }
            AuthorizationClient.this.notifyBackgroundProcessingStart();
            GetTokenClient.CompletedListener callback = new GetTokenClient.CompletedListener(){

                public void completed(Bundle result) {
                    GetTokenAuthHandler.this.getTokenCompleted(request, result);
                }
            };
            this.getTokenClient.setCompletedListener(callback);
            return true;
        }

        void getTokenCompleted(AuthorizationRequest request, Bundle result) {
            this.getTokenClient = null;
            AuthorizationClient.this.notifyBackgroundProcessingStop();
            if (result != null) {
                ArrayList currentPermissions = result.getStringArrayList("com.facebook.platform.extra.PERMISSIONS");
                List<String> permissions = request.getPermissions();
                if (currentPermissions != null && (permissions == null || currentPermissions.containsAll(permissions))) {
                    AccessToken token = AccessToken.createFromNativeLogin(result, AccessTokenSource.FACEBOOK_APPLICATION_SERVICE);
                    Result outcome = Result.createTokenResult(token);
                    AuthorizationClient.this.completeAndValidate(outcome);
                    return;
                }
                ArrayList<String> newPermissions = new ArrayList<String>();
                for (String permission : permissions) {
                    if (currentPermissions.contains(permission)) continue;
                    newPermissions.add(permission);
                }
                request.setPermissions(newPermissions);
            }
            AuthorizationClient.this.tryNextHandler();
        }
    }

    class WebViewAuthHandler
    extends AuthHandler {
        private static final long serialVersionUID = 1L;
        private transient WebDialog loginDialog;

        WebViewAuthHandler() {
        }

        boolean needsRestart() {
            return true;
        }

        boolean needsInternetPermission() {
            return true;
        }

        void cancel() {
            if (this.loginDialog != null) {
                this.loginDialog.dismiss();
                this.loginDialog = null;
            }
        }

        boolean tryAuthorize(final AuthorizationRequest request) {
            String previousToken;
            String applicationId = request.getApplicationId();
            Bundle parameters = new Bundle();
            if (!Utility.isNullOrEmpty(request.getPermissions())) {
                parameters.putString("scope", TextUtils.join((CharSequence)",", request.getPermissions()));
            }
            if (!Utility.isNullOrEmpty(previousToken = request.getPreviousAccessToken()) && previousToken.equals(this.loadCookieToken())) {
                parameters.putString("access_token", previousToken);
            } else {
                Utility.clearFacebookCookies(AuthorizationClient.this.context);
            }
            WebDialog.OnCompleteListener listener = new WebDialog.OnCompleteListener(){

                public void onComplete(Bundle values, FacebookException error) {
                    WebViewAuthHandler.this.onWebDialogComplete(request, values, error);
                }
            };
            WebDialog.Builder builder = (WebDialog.Builder)new AuthDialogBuilder((Context)AuthorizationClient.this.getStartActivityDelegate().getActivityContext(), applicationId, parameters).setOnCompleteListener(listener);
            this.loginDialog = builder.build();
            this.loginDialog.show();
            return true;
        }

        void onWebDialogComplete(AuthorizationRequest request, Bundle values, FacebookException error) {
            Result outcome;
            if (values != null) {
                AccessToken token = AccessToken.createFromWebBundle(request.getPermissions(), values, AccessTokenSource.WEB_VIEW);
                outcome = Result.createTokenResult(token);
                CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)AuthorizationClient.this.context);
                syncManager.sync();
                this.saveCookieToken(token.getToken());
            } else {
                outcome = error instanceof FacebookOperationCanceledException ? Result.createCancelResult("User canceled log in.") : Result.createErrorResult(error.getMessage(), null);
            }
            AuthorizationClient.this.completeAndValidate(outcome);
        }

        private void saveCookieToken(String token) {
            Activity context = AuthorizationClient.this.getStartActivityDelegate().getActivityContext();
            SharedPreferences sharedPreferences = PreferenceManager.wrap((Context)context, AuthorizationClient.WEB_VIEW_AUTH_HANDLER_STORE, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, token);
            if (!editor.commit()) {
                Utility.logd(AuthorizationClient.TAG, "Could not update saved web view auth handler token.");
            }
        }

        private String loadCookieToken() {
            Activity context = AuthorizationClient.this.getStartActivityDelegate().getActivityContext();
            SharedPreferences sharedPreferences = PreferenceManager.wrap((Context)context, AuthorizationClient.WEB_VIEW_AUTH_HANDLER_STORE, 0);
            return sharedPreferences.getString(AuthorizationClient.WEB_VIEW_AUTH_HANDLER_TOKEN_KEY, "");
        }
    }

    abstract class AuthHandler
    implements Serializable {
        private static final long serialVersionUID = 1L;

        AuthHandler() {
        }

        abstract boolean tryAuthorize(AuthorizationRequest var1);

        boolean onActivityResult(int requestCode, int resultCode, Intent data) {
            return false;
        }

        boolean needsRestart() {
            return false;
        }

        boolean needsInternetPermission() {
            return false;
        }

        void cancel() {
        }
    }

    static interface StartActivityDelegate {
        public void startActivityForResult(Intent var1, int var2);

        public Activity getActivityContext();
    }

    static interface BackgroundProcessingListener {
        public void onBackgroundProcessingStarted();

        public void onBackgroundProcessingStopped();
    }

    static interface OnCompletedListener {
        public void onCompleted(Result var1);
    }
}

