/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.facebook.NativeProtocol;

final class GetTokenClient
implements ServiceConnection {
    final Context context;
    final String applicationId;
    final Handler handler;
    CompletedListener listener;
    boolean running;
    Messenger sender;

    GetTokenClient(Context context, String applicationId) {
        Context applicationContext = context.getApplicationContext();
        this.context = applicationContext != null ? applicationContext : context;
        this.applicationId = applicationId;
        this.handler = new Handler(){

            public void handleMessage(Message message) {
                GetTokenClient.this.handleMessage(message);
            }
        };
    }

    void setCompletedListener(CompletedListener listener) {
        this.listener = listener;
    }

    boolean start() {
        Intent intent = new Intent("com.facebook.platform.PLATFORM_SERVICE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent = NativeProtocol.validateKatanaServiceIntent(this.context, intent);
        if (intent == null) {
            this.callback(null);
            return false;
        }
        this.running = true;
        this.context.bindService(intent, (ServiceConnection)this, 1);
        return true;
    }

    void cancel() {
        this.running = false;
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.sender = new Messenger(service);
        this.getToken();
    }

    public void onServiceDisconnected(ComponentName name) {
        this.sender = null;
        this.context.unbindService((ServiceConnection)this);
        this.callback(null);
    }

    private void getToken() {
        Bundle data = new Bundle();
        data.putString("com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
        Message request = Message.obtain(null, (int)65536);
        request.arg1 = 20121101;
        request.setData(data);
        request.replyTo = new Messenger(this.handler);
        try {
            this.sender.send(request);
        }
        catch (RemoteException e) {
            this.callback(null);
        }
    }

    private void handleMessage(Message message) {
        if (message.what == 65537) {
            Bundle extras = message.getData();
            String errorType = extras.getString("com.facebook.platform.status.ERROR_TYPE");
            if (errorType != null) {
                this.callback(null);
            } else {
                this.callback(extras);
            }
            this.context.unbindService((ServiceConnection)this);
        }
    }

    private void callback(Bundle result) {
        if (!this.running) {
            return;
        }
        this.running = false;
        CompletedListener callback = this.listener;
        if (callback != null) {
            callback.completed(result);
        }
    }

    static interface CompletedListener {
        public void completed(Bundle var1);
    }
}

