/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.LoggingBehavior;
import com.facebook.NonCachingTokenCachingStrategy;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.Settings;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InsightsLogger {
    private static final String EVENT_NAME_LOG_CONVERSION_PIXEL = "fb_log_offsite_pixel";
    private static final String EVENT_NAME_LOG_MOBILE_PURCHASE = "fb_mobile_purchase";
    private static final String EVENT_PARAMETER_CURRENCY = "fb_currency";
    private static final String EVENT_PARAMETER_PIXEL_ID = "fb_offsite_pixel_id";
    private static final String EVENT_PARAMETER_PIXEL_VALUE = "fb_offsite_pixel_value";
    private static Session appAuthSession = null;
    private final Context context;
    private final String clientToken;
    private final String applicationId;
    private final Session specifiedSession;

    private InsightsLogger(Context context, String clientToken, String applicationId, Session session) {
        Validate.notNull(context, "context");
        Validate.notNullOrEmpty(clientToken, "clientToken");
        if (applicationId == null) {
            applicationId = Utility.getMetadataApplicationId(context);
        }
        this.context = context;
        this.clientToken = clientToken;
        this.applicationId = applicationId;
        this.specifiedSession = session;
    }

    public static InsightsLogger newLogger(Context context, String clientToken) {
        return new InsightsLogger(context, clientToken, null, null);
    }

    public static InsightsLogger newLogger(Context context, String clientToken, String applicationId) {
        return new InsightsLogger(context, clientToken, applicationId, null);
    }

    public static InsightsLogger newLogger(Context context, String clientToken, String applicationId, Session session) {
        return new InsightsLogger(context, clientToken, applicationId, session);
    }

    public void logPurchase(BigDecimal purchaseAmount, Currency currency) {
        this.logPurchase(purchaseAmount, currency, null);
    }

    public void logPurchase(BigDecimal purchaseAmount, Currency currency, Bundle parameters) {
        if (purchaseAmount == null) {
            InsightsLogger.notifyDeveloperError("purchaseAmount cannot be null");
            return;
        }
        if (currency == null) {
            InsightsLogger.notifyDeveloperError("currency cannot be null");
            return;
        }
        if (parameters == null) {
            parameters = new Bundle();
        }
        parameters.putString(EVENT_PARAMETER_CURRENCY, currency.getCurrencyCode());
        this.logEventNow(EVENT_NAME_LOG_MOBILE_PURCHASE, purchaseAmount.doubleValue(), parameters);
    }

    public void logConversionPixel(String pixelId, double valueOfPixel) {
        if (pixelId == null) {
            InsightsLogger.notifyDeveloperError("pixelID cannot be null");
            return;
        }
        Bundle parameters = new Bundle();
        parameters.putString(EVENT_PARAMETER_PIXEL_ID, pixelId);
        parameters.putDouble(EVENT_PARAMETER_PIXEL_VALUE, valueOfPixel);
        this.logEventNow(EVENT_NAME_LOG_CONVERSION_PIXEL, valueOfPixel, parameters);
    }

    private void logEventNow(final String eventName, final double valueToSum, final Bundle parameters) {
        Settings.getExecutor().execute(new Runnable(){

            public void run() {
                String attributionId;
                String eventJSON = InsightsLogger.buildJSONForEvent(eventName, valueToSum, parameters);
                if (eventJSON == null) {
                    return;
                }
                GraphObject publishParams = GraphObject.Factory.create();
                publishParams.setProperty("event", "CUSTOM_APP_EVENTS");
                publishParams.setProperty("custom_events", eventJSON);
                if (Utility.queryAppAttributionSupportAndWait(InsightsLogger.this.applicationId) && (attributionId = Settings.getAttributionId(InsightsLogger.this.context.getContentResolver())) != null) {
                    publishParams.setProperty("attribution", attributionId);
                }
                String publishUrl = String.format("%s/activities", InsightsLogger.this.applicationId);
                try {
                    Request postRequest = Request.newPostRequest(InsightsLogger.this.sessionToLogTo(), publishUrl, publishParams, null);
                    Response response = postRequest.executeAndWait();
                    int NO_CONNECTIVITY_ERROR_CODE = -1;
                    if (response.getError() != null && response.getError().getErrorCode() != -1) {
                        InsightsLogger.notifyDeveloperError(String.format("Error publishing Insights event '%s'\n  Response: %s\n  Error: %s", eventJSON, response.toString(), response.getError().toString()));
                    }
                }
                catch (Exception e) {
                    Utility.logd("Insights-exception: ", e);
                }
            }
        });
    }

    private static String buildJSONForEvent(String eventName, double valueToSum, Bundle parameters) {
        String result;
        try {
            JSONObject eventObject = new JSONObject();
            eventObject.put("_eventName", (Object)eventName);
            if (valueToSum != 1.0) {
                eventObject.put("_valueToSum", valueToSum);
            }
            if (parameters != null) {
                Set keys = parameters.keySet();
                for (String key : keys) {
                    Object value = parameters.get(key);
                    if (!(value instanceof String) && !(value instanceof Number)) {
                        InsightsLogger.notifyDeveloperError(String.format("Parameter '%s' must be a string or a numeric type.", key));
                    }
                    eventObject.put(key, value);
                }
            }
            JSONArray eventArray = new JSONArray();
            eventArray.put((Object)eventObject);
            result = eventArray.toString();
        }
        catch (JSONException exception) {
            InsightsLogger.notifyDeveloperError(exception.toString());
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session sessionToLogTo() {
        InsightsLogger insightsLogger = this;
        synchronized (insightsLogger) {
            Session session = this.specifiedSession;
            if (session == null || !session.isOpened()) {
                session = Session.getActiveSession();
            }
            if (session == null || !session.isOpened() || session.getAccessToken() == null) {
                if (appAuthSession == null) {
                    String tokenString = String.format("%s|%s", this.applicationId, this.clientToken);
                    AccessToken token = AccessToken.createFromString(tokenString, null, AccessTokenSource.CLIENT_TOKEN);
                    appAuthSession = new Session(null, this.applicationId, new NonCachingTokenCachingStrategy(), false);
                    appAuthSession.open(token, null);
                }
                session = appAuthSession;
            }
            return session;
        }
    }

    private static void notifyDeveloperError(String message) {
        Logger.log(LoggingBehavior.DEVELOPER_ERRORS, "Insights", message);
    }
}

