/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Intent;
import android.os.Bundle;
import com.facebook.AuthorizationClient;
import com.facebook.FacebookException;
import java.io.Serializable;
import org.holoeverywhere.addon.facebook.R;
import org.holoeverywhere.app.Activity;

public class LoginActivity
extends Activity {
    static final String RESULT_KEY = "com.facebook.LoginActivity:Result";
    private static final String NULL_CALLING_PKG_ERROR_MSG = "Cannot call LoginActivity with a null calling package. This can occur if the launchMode of the caller is singleInstance.";
    private static final String SAVED_CALLING_PKG_KEY = "callingPackage";
    private static final String SAVED_AUTH_CLIENT = "authorizationClient";
    private static final String EXTRA_REQUEST = "request";
    private String callingPackage;
    private AuthorizationClient authorizationClient;
    private AuthorizationClient.AuthorizationRequest request;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_facebook_login_activity_layout);
        if (savedInstanceState != null) {
            this.callingPackage = savedInstanceState.getString(SAVED_CALLING_PKG_KEY);
            this.authorizationClient = (AuthorizationClient)savedInstanceState.getSerializable(SAVED_AUTH_CLIENT);
        } else {
            this.callingPackage = this.getCallingPackage();
            this.authorizationClient = new AuthorizationClient();
            this.request = (AuthorizationClient.AuthorizationRequest)this.getIntent().getSerializableExtra(EXTRA_REQUEST);
        }
        this.authorizationClient.setContext(this);
        this.authorizationClient.setOnCompletedListener(new AuthorizationClient.OnCompletedListener(){

            public void onCompleted(AuthorizationClient.Result outcome) {
                LoginActivity.this.onAuthClientCompleted(outcome);
            }
        });
        this.authorizationClient.setBackgroundProcessingListener(new AuthorizationClient.BackgroundProcessingListener(){

            public void onBackgroundProcessingStarted() {
                LoginActivity.this.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(0);
            }

            public void onBackgroundProcessingStopped() {
                LoginActivity.this.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
            }
        });
    }

    private void onAuthClientCompleted(AuthorizationClient.Result outcome) {
        this.request = null;
        int resultCode = outcome.code == AuthorizationClient.Result.Code.CANCEL ? 0 : -1;
        Bundle bundle = new Bundle();
        bundle.putSerializable(RESULT_KEY, (Serializable)outcome);
        Intent resultIntent = new Intent();
        resultIntent.putExtras(bundle);
        this.setResult(resultCode, resultIntent);
        this.finish();
    }

    public void onResume() {
        super.onResume();
        if (this.callingPackage == null) {
            throw new FacebookException(NULL_CALLING_PKG_ERROR_MSG);
        }
        this.authorizationClient.startOrContinueAuth(this.request);
    }

    public void onPause() {
        super.onPause();
        this.authorizationClient.cancelCurrentHandler();
        this.findViewById(R.id.com_facebook_login_activity_progress_bar).setVisibility(8);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(SAVED_CALLING_PKG_KEY, this.callingPackage);
        outState.putSerializable(SAVED_AUTH_CLIENT, (Serializable)this.authorizationClient);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.authorizationClient.onActivityResult(requestCode, resultCode, data);
    }

    static Bundle populateIntentExtras(AuthorizationClient.AuthorizationRequest request) {
        Bundle extras = new Bundle();
        extras.putSerializable(EXTRA_REQUEST, (Serializable)request);
        return extras;
    }
}

