/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.graphics.Bitmap;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import com.facebook.FacebookException;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.RequestAsyncTask;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphMultiResult;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.GraphPlace;
import com.facebook.model.GraphUser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    public static final int MAXIMUM_BATCH_SIZE = 50;
    private static final String ME = "me";
    private static final String MY_FRIENDS = "me/friends";
    private static final String MY_PHOTOS = "me/photos";
    private static final String MY_VIDEOS = "me/videos";
    private static final String SEARCH = "search";
    private static final String MY_FEED = "me/feed";
    private static final String USER_AGENT_BASE = "FBAndroidSDK";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String PICTURE_PARAM = "picture";
    private static final String FORMAT_PARAM = "format";
    private static final String FORMAT_JSON = "json";
    private static final String SDK_PARAM = "sdk";
    private static final String SDK_ANDROID = "android";
    private static final String ACCESS_TOKEN_PARAM = "access_token";
    private static final String BATCH_ENTRY_NAME_PARAM = "name";
    private static final String BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM = "omit_response_on_success";
    private static final String BATCH_ENTRY_DEPENDS_ON_PARAM = "depends_on";
    private static final String BATCH_APP_ID_PARAM = "batch_app_id";
    private static final String BATCH_RELATIVE_URL_PARAM = "relative_url";
    private static final String BATCH_BODY_PARAM = "body";
    private static final String BATCH_METHOD_PARAM = "method";
    private static final String BATCH_PARAM = "batch";
    private static final String ATTACHMENT_FILENAME_PREFIX = "file";
    private static final String ATTACHED_FILES_PARAM = "attached_files";
    private static final String MIGRATION_BUNDLE_PARAM = "migration_bundle";
    private static final String ISO_8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String MIME_BOUNDARY = "3i2ndDfv2rTHiSisAbouNdArYfORhtTPEefj3q2f";
    private static String defaultBatchApplicationId;
    private Session session;
    private HttpMethod httpMethod;
    private String graphPath;
    private GraphObject graphObject;
    private String restMethod;
    private String batchEntryName;
    private String batchEntryDependsOn;
    private boolean batchEntryOmitResultOnSuccess = true;
    private Bundle parameters;
    private Callback callback;
    private String overriddenURL;
    private static volatile String userAgent;

    public Request() {
        this(null, null, null, null, null);
    }

    public Request(Session session, String graphPath) {
        this(session, graphPath, null, null, null);
    }

    public Request(Session session, String graphPath, Bundle parameters, HttpMethod httpMethod) {
        this(session, graphPath, parameters, httpMethod, null);
    }

    public Request(Session session, String graphPath, Bundle parameters, HttpMethod httpMethod, Callback callback) {
        this.session = session;
        this.graphPath = graphPath;
        this.callback = callback;
        this.setHttpMethod(httpMethod);
        this.parameters = parameters != null ? new Bundle(parameters) : new Bundle();
        if (!this.parameters.containsKey(MIGRATION_BUNDLE_PARAM)) {
            this.parameters.putString(MIGRATION_BUNDLE_PARAM, "fbsdk:20121026");
        }
    }

    Request(Session session, URL overriddenURL) {
        this.session = session;
        this.overriddenURL = overriddenURL.toString();
        this.setHttpMethod(HttpMethod.GET);
        this.parameters = new Bundle();
    }

    public static Request newPostRequest(Session session, String graphPath, GraphObject graphObject, Callback callback) {
        Request request = new Request(session, graphPath, null, HttpMethod.POST, callback);
        request.setGraphObject(graphObject);
        return request;
    }

    public static Request newRestRequest(Session session, String restMethod, Bundle parameters, HttpMethod httpMethod) {
        Request request = new Request(session, null, parameters, httpMethod);
        request.setRestMethod(restMethod);
        return request;
    }

    public static Request newMeRequest(Session session, final GraphUserCallback callback) {
        Callback wrapper = new Callback(){

            public void onCompleted(Response response) {
                if (callback != null) {
                    callback.onCompleted(response.getGraphObjectAs(GraphUser.class), response);
                }
            }
        };
        return new Request(session, ME, null, null, wrapper);
    }

    public static Request newMyFriendsRequest(Session session, final GraphUserListCallback callback) {
        Callback wrapper = new Callback(){

            public void onCompleted(Response response) {
                if (callback != null) {
                    callback.onCompleted(Request.typedListFromResponse(response, GraphUser.class), response);
                }
            }
        };
        return new Request(session, MY_FRIENDS, null, null, wrapper);
    }

    public static Request newUploadPhotoRequest(Session session, Bitmap image, Callback callback) {
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)image);
        return new Request(session, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static Request newUploadPhotoRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)descriptor);
        return new Request(session, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static Request newUploadVideoRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(file.getName(), (Parcelable)descriptor);
        return new Request(session, MY_VIDEOS, parameters, HttpMethod.POST, callback);
    }

    public static Request newGraphPathRequest(Session session, String graphPath, Callback callback) {
        return new Request(session, graphPath, null, null, callback);
    }

    public static Request newPlacesSearchRequest(Session session, Location location, int radiusInMeters, int resultsLimit, String searchText, final GraphPlaceListCallback callback) {
        if (location == null && Utility.isNullOrEmpty(searchText)) {
            throw new FacebookException("Either location or searchText must be specified.");
        }
        Bundle parameters = new Bundle(5);
        parameters.putString("type", "place");
        parameters.putInt("limit", resultsLimit);
        if (location != null) {
            parameters.putString("center", String.format(Locale.US, "%f,%f", location.getLatitude(), location.getLongitude()));
            parameters.putInt("distance", radiusInMeters);
        }
        if (!Utility.isNullOrEmpty(searchText)) {
            parameters.putString("q", searchText);
        }
        Callback wrapper = new Callback(){

            public void onCompleted(Response response) {
                if (callback != null) {
                    callback.onCompleted(Request.typedListFromResponse(response, GraphPlace.class), response);
                }
            }
        };
        return new Request(session, SEARCH, parameters, HttpMethod.GET, wrapper);
    }

    public static Request newStatusUpdateRequest(Session session, String message, Callback callback) {
        Bundle parameters = new Bundle();
        parameters.putString("message", message);
        return new Request(session, MY_FEED, parameters, HttpMethod.POST, callback);
    }

    public final GraphObject getGraphObject() {
        return this.graphObject;
    }

    public final void setGraphObject(GraphObject graphObject) {
        this.graphObject = graphObject;
    }

    public final String getGraphPath() {
        return this.graphPath;
    }

    public final void setGraphPath(String graphPath) {
        this.graphPath = graphPath;
    }

    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public final void setHttpMethod(HttpMethod httpMethod) {
        if (this.overriddenURL != null && httpMethod != HttpMethod.GET) {
            throw new FacebookException("Can't change HTTP method on request with overridden URL.");
        }
        this.httpMethod = httpMethod != null ? httpMethod : HttpMethod.GET;
    }

    public final Bundle getParameters() {
        return this.parameters;
    }

    public final void setParameters(Bundle parameters) {
        this.parameters = parameters;
    }

    public final String getRestMethod() {
        return this.restMethod;
    }

    public final void setRestMethod(String restMethod) {
        this.restMethod = restMethod;
    }

    public final Session getSession() {
        return this.session;
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    public final String getBatchEntryName() {
        return this.batchEntryName;
    }

    public final void setBatchEntryName(String batchEntryName) {
        this.batchEntryName = batchEntryName;
    }

    public final String getBatchEntryDependsOn() {
        return this.batchEntryDependsOn;
    }

    public final void setBatchEntryDependsOn(String batchEntryDependsOn) {
        this.batchEntryDependsOn = batchEntryDependsOn;
    }

    public final boolean getBatchEntryOmitResultOnSuccess() {
        return this.batchEntryOmitResultOnSuccess;
    }

    public final void setBatchEntryOmitResultOnSuccess(boolean batchEntryOmitResultOnSuccess) {
        this.batchEntryOmitResultOnSuccess = batchEntryOmitResultOnSuccess;
    }

    public static final String getDefaultBatchApplicationId() {
        return defaultBatchApplicationId;
    }

    public static final void setDefaultBatchApplicationId(String applicationId) {
        defaultBatchApplicationId = applicationId;
    }

    public final Callback getCallback() {
        return this.callback;
    }

    public final void setCallback(Callback callback) {
        this.callback = callback;
    }

    public static RequestAsyncTask executePostRequestAsync(Session session, String graphPath, GraphObject graphObject, Callback callback) {
        return Request.newPostRequest(session, graphPath, graphObject, callback).executeAsync();
    }

    public static RequestAsyncTask executeRestRequestAsync(Session session, String restMethod, Bundle parameters, HttpMethod httpMethod) {
        return Request.newRestRequest(session, restMethod, parameters, httpMethod).executeAsync();
    }

    public static RequestAsyncTask executeMeRequestAsync(Session session, GraphUserCallback callback) {
        return Request.newMeRequest(session, callback).executeAsync();
    }

    public static RequestAsyncTask executeMyFriendsRequestAsync(Session session, GraphUserListCallback callback) {
        return Request.newMyFriendsRequest(session, callback).executeAsync();
    }

    public static RequestAsyncTask executeUploadPhotoRequestAsync(Session session, Bitmap image, Callback callback) {
        return Request.newUploadPhotoRequest(session, image, callback).executeAsync();
    }

    public static RequestAsyncTask executeUploadPhotoRequestAsync(Session session, File file, Callback callback) throws FileNotFoundException {
        return Request.newUploadPhotoRequest(session, file, callback).executeAsync();
    }

    public static RequestAsyncTask executeGraphPathRequestAsync(Session session, String graphPath, Callback callback) {
        return Request.newGraphPathRequest(session, graphPath, callback).executeAsync();
    }

    public static RequestAsyncTask executePlacesSearchRequestAsync(Session session, Location location, int radiusInMeters, int resultsLimit, String searchText, GraphPlaceListCallback callback) {
        return Request.newPlacesSearchRequest(session, location, radiusInMeters, resultsLimit, searchText, callback).executeAsync();
    }

    public static RequestAsyncTask executeStatusUpdateRequestAsync(Session session, String message, Callback callback) {
        return Request.newStatusUpdateRequest(session, message, callback).executeAsync();
    }

    public final Response executeAndWait() {
        return Request.executeAndWait(this);
    }

    public final RequestAsyncTask executeAsync() {
        return Request.executeBatchAsync(this);
    }

    public static HttpURLConnection toHttpConnection(Request ... requests) {
        return Request.toHttpConnection(Arrays.asList(requests));
    }

    public static HttpURLConnection toHttpConnection(Collection<Request> requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        return Request.toHttpConnection(new RequestBatch(requests));
    }

    public static HttpURLConnection toHttpConnection(RequestBatch requests) {
        HttpURLConnection connection;
        for (Request request : requests) {
            request.validate();
        }
        URL url = null;
        try {
            if (requests.size() == 1) {
                Request request;
                request = requests.get(0);
                url = new URL(request.getUrlForSingleRequest());
            } else {
                url = new URL("https://graph.facebook.com");
            }
        }
        catch (MalformedURLException e) {
            throw new FacebookException("could not construct URL for request", e);
        }
        try {
            connection = Request.createConnection(url);
            Request.serializeToUrlConnection(requests, connection);
        }
        catch (IOException e) {
            throw new FacebookException("could not construct request body", e);
        }
        catch (JSONException e) {
            throw new FacebookException("could not construct request body", e);
        }
        return connection;
    }

    public static Response executeAndWait(Request request) {
        List<Response> responses = Request.executeBatchAndWait(request);
        if (responses == null || responses.size() != 1) {
            throw new FacebookException("invalid state: expected a single response");
        }
        return responses.get(0);
    }

    public static List<Response> executeBatchAndWait(Request ... requests) {
        Validate.notNull(requests, "requests");
        return Request.executeBatchAndWait(Arrays.asList(requests));
    }

    public static List<Response> executeBatchAndWait(Collection<Request> requests) {
        return Request.executeBatchAndWait(new RequestBatch(requests));
    }

    public static List<Response> executeBatchAndWait(RequestBatch requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        HttpURLConnection connection = null;
        try {
            connection = Request.toHttpConnection(requests);
        }
        catch (Exception ex) {
            List<Response> responses = Response.constructErrorResponses(requests.getRequests(), null, new FacebookException(ex));
            Request.runCallbacks(requests, responses);
            return responses;
        }
        List<Response> responses = Request.executeConnectionAndWait(connection, requests);
        return responses;
    }

    public static RequestAsyncTask executeBatchAsync(Request ... requests) {
        Validate.notNull(requests, "requests");
        return Request.executeBatchAsync(Arrays.asList(requests));
    }

    public static RequestAsyncTask executeBatchAsync(Collection<Request> requests) {
        return Request.executeBatchAsync(new RequestBatch(requests));
    }

    public static RequestAsyncTask executeBatchAsync(RequestBatch requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        RequestAsyncTask asyncTask = new RequestAsyncTask(requests);
        asyncTask.executeOnSettingsExecutor();
        return asyncTask;
    }

    public static List<Response> executeConnectionAndWait(HttpURLConnection connection, Collection<Request> requests) {
        return Request.executeConnectionAndWait(connection, new RequestBatch(requests));
    }

    public static List<Response> executeConnectionAndWait(HttpURLConnection connection, RequestBatch requests) {
        List<Response> responses = Response.fromHttpConnection(connection, requests);
        Utility.disconnectQuietly(connection);
        int numRequests = requests.size();
        if (numRequests != responses.size()) {
            throw new FacebookException(String.format("Received %d responses while expecting %d", responses.size(), numRequests));
        }
        Request.runCallbacks(requests, responses);
        HashSet<Session> sessions = new HashSet<Session>();
        for (Request request : requests) {
            if (request.session == null) continue;
            sessions.add(request.session);
        }
        for (Session session : sessions) {
            session.extendAccessTokenIfNeeded();
        }
        return responses;
    }

    public static RequestAsyncTask executeConnectionAsync(HttpURLConnection connection, RequestBatch requests) {
        return Request.executeConnectionAsync(null, connection, requests);
    }

    public static RequestAsyncTask executeConnectionAsync(Handler callbackHandler, HttpURLConnection connection, RequestBatch requests) {
        Validate.notNull(connection, "connection");
        RequestAsyncTask asyncTask = new RequestAsyncTask(connection, requests);
        requests.setCallbackHandler(callbackHandler);
        asyncTask.executeOnSettingsExecutor();
        return asyncTask;
    }

    public String toString() {
        return "{Request: " + " session: " + this.session + ", graphPath: " + this.graphPath + ", graphObject: " + this.graphObject + ", restMethod: " + this.restMethod + ", httpMethod: " + (Object)((Object)this.httpMethod) + ", parameters: " + this.parameters + "}";
    }

    static void runCallbacks(final RequestBatch requests, List<Response> responses) {
        int numRequests = requests.size();
        final ArrayList<Pair> callbacks = new ArrayList<Pair>();
        for (int i = 0; i < numRequests; ++i) {
            Request request = requests.get(i);
            if (request.callback == null) continue;
            callbacks.add(new Pair((Object)request.callback, (Object)responses.get(i)));
        }
        if (callbacks.size() > 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    for (Pair pair : callbacks) {
                        ((Callback)pair.first).onCompleted((Response)pair.second);
                    }
                    List<RequestBatch.Callback> batchCallbacks = requests.getCallbacks();
                    for (RequestBatch.Callback batchCallback : batchCallbacks) {
                        batchCallback.onBatchCompleted(requests);
                    }
                }
            };
            Handler callbackHandler = requests.getCallbackHandler();
            if (callbackHandler == null) {
                runnable.run();
            } else {
                callbackHandler.post(runnable);
            }
        }
    }

    static HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty(USER_AGENT_HEADER, Request.getUserAgent());
        connection.setRequestProperty(CONTENT_TYPE_HEADER, Request.getMimeContentType());
        connection.setChunkedStreamingMode(0);
        return connection;
    }

    private void addCommonParameters() {
        if (this.session != null) {
            if (!this.session.isOpened()) {
                throw new FacebookException("Session provided to a Request in un-opened state.");
            }
            if (!this.parameters.containsKey(ACCESS_TOKEN_PARAM)) {
                String accessToken = this.session.getAccessToken();
                Logger.registerAccessToken(accessToken);
                this.parameters.putString(ACCESS_TOKEN_PARAM, accessToken);
            }
        }
        this.parameters.putString(SDK_PARAM, SDK_ANDROID);
        this.parameters.putString(FORMAT_PARAM, FORMAT_JSON);
    }

    private String appendParametersToBaseUrl(String baseUrl) {
        Uri.Builder uriBuilder = new Uri.Builder().encodedPath(baseUrl);
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (value == null) {
                value = "";
            }
            if (!Request.isSupportedParameterType(value)) {
                if (this.httpMethod != HttpMethod.GET) continue;
                throw new IllegalArgumentException(String.format("Unsupported parameter type for GET request: %s", value.getClass().getSimpleName()));
            }
            value = Request.parameterToString(value);
            uriBuilder.appendQueryParameter(key, value.toString());
        }
        return uriBuilder.toString();
    }

    final String getUrlForBatchedRequest() {
        if (this.overriddenURL != null) {
            throw new FacebookException("Can't override URL for a batch request");
        }
        String baseUrl = this.restMethod != null ? "method/" + this.restMethod : this.graphPath;
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(baseUrl);
    }

    final String getUrlForSingleRequest() {
        if (this.overriddenURL != null) {
            return this.overriddenURL.toString();
        }
        String baseUrl = this.restMethod != null ? "https://api.facebook.com/method/" + this.restMethod : "https://graph.facebook.com/" + this.graphPath;
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(baseUrl);
    }

    private void serializeToBatch(JSONArray batch, Bundle attachments) throws JSONException, IOException {
        JSONObject batchEntry = new JSONObject();
        if (this.batchEntryName != null) {
            batchEntry.put(BATCH_ENTRY_NAME_PARAM, (Object)this.batchEntryName);
            batchEntry.put(BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM, this.batchEntryOmitResultOnSuccess);
        }
        if (this.batchEntryDependsOn != null) {
            batchEntry.put(BATCH_ENTRY_DEPENDS_ON_PARAM, (Object)this.batchEntryDependsOn);
        }
        String relativeURL = this.getUrlForBatchedRequest();
        batchEntry.put(BATCH_RELATIVE_URL_PARAM, (Object)relativeURL);
        batchEntry.put(BATCH_METHOD_PARAM, (Object)this.httpMethod);
        if (this.session != null) {
            String accessToken = this.session.getAccessToken();
            Logger.registerAccessToken(accessToken);
        }
        ArrayList<String> attachmentNames = new ArrayList<String>();
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (!Request.isSupportedAttachmentType(value)) continue;
            String name = String.format("%s%d", ATTACHMENT_FILENAME_PREFIX, attachments.size());
            attachmentNames.add(name);
            Utility.putObjectInBundle(attachments, name, value);
        }
        if (!attachmentNames.isEmpty()) {
            String attachmentNamesString = TextUtils.join((CharSequence)",", attachmentNames);
            batchEntry.put(ATTACHED_FILES_PARAM, (Object)attachmentNamesString);
        }
        if (this.graphObject != null) {
            final ArrayList keysAndValues = new ArrayList();
            Request.processGraphObject(this.graphObject, relativeURL, new KeyValueSerializer(){

                public void writeString(String key, String value) throws IOException {
                    keysAndValues.add(String.format("%s=%s", key, URLEncoder.encode(value, "UTF-8")));
                }
            });
            String bodyValue = TextUtils.join((CharSequence)"&", keysAndValues);
            batchEntry.put(BATCH_BODY_PARAM, (Object)bodyValue);
        }
        batch.put((Object)batchEntry);
    }

    private void validate() {
        if (this.graphPath != null && this.restMethod != null) {
            throw new IllegalArgumentException("Only one of a graph path or REST method may be specified per request.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void serializeToUrlConnection(RequestBatch requests, HttpURLConnection connection) throws IOException, JSONException {
        boolean isPost;
        Logger logger = new Logger(LoggingBehavior.REQUESTS, "Request");
        int numRequests = requests.size();
        HttpMethod connectionHttpMethod = numRequests == 1 ? requests.get((int)0).httpMethod : HttpMethod.POST;
        connection.setRequestMethod(connectionHttpMethod.name());
        URL url = connection.getURL();
        logger.append("Request:\n");
        logger.appendKeyValue("Id", requests.getId());
        logger.appendKeyValue("URL", url);
        logger.appendKeyValue("Method", connection.getRequestMethod());
        logger.appendKeyValue(USER_AGENT_HEADER, connection.getRequestProperty(USER_AGENT_HEADER));
        logger.appendKeyValue(CONTENT_TYPE_HEADER, connection.getRequestProperty(CONTENT_TYPE_HEADER));
        connection.setConnectTimeout(requests.getTimeout());
        connection.setReadTimeout(requests.getTimeout());
        boolean bl = isPost = connectionHttpMethod == HttpMethod.POST;
        if (!isPost) {
            logger.log();
            return;
        }
        connection.setDoOutput(true);
        BufferedOutputStream outputStream = new BufferedOutputStream(connection.getOutputStream());
        try {
            Serializer serializer = new Serializer(outputStream, logger);
            if (numRequests == 1) {
                Request request = requests.get(0);
                logger.append("  Parameters:\n");
                Request.serializeParameters(request.parameters, serializer);
                logger.append("  Attachments:\n");
                Request.serializeAttachments(request.parameters, serializer);
                if (request.graphObject != null) {
                    Request.processGraphObject(request.graphObject, url.getPath(), serializer);
                }
            } else {
                String batchAppID = Request.getBatchAppId(requests);
                if (Utility.isNullOrEmpty(batchAppID)) {
                    throw new FacebookException("At least one request in a batch must have an open Session, or a default app ID must be specified.");
                }
                serializer.writeString(BATCH_APP_ID_PARAM, batchAppID);
                Bundle attachments = new Bundle();
                Request.serializeRequestsAsJSON(serializer, requests, attachments);
                logger.append("  Attachments:\n");
                Request.serializeAttachments(attachments, serializer);
            }
        }
        finally {
            outputStream.close();
        }
        logger.log();
    }

    private static void processGraphObject(GraphObject graphObject, String path, KeyValueSerializer serializer) throws IOException {
        boolean isOGAction = false;
        if (path.startsWith("me/") || path.startsWith("/me/")) {
            int colonLocation = path.indexOf(":");
            int questionMarkLocation = path.indexOf("?");
            isOGAction = colonLocation > 3 && (questionMarkLocation == -1 || colonLocation < questionMarkLocation);
        }
        Set<Map.Entry<String, Object>> entries = graphObject.asMap().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            boolean passByValue = isOGAction && entry.getKey().equalsIgnoreCase("image");
            Request.processGraphObjectProperty(entry.getKey(), entry.getValue(), serializer, passByValue);
        }
    }

    private static void processGraphObjectProperty(String key, Object value, KeyValueSerializer serializer, boolean passByValue) throws IOException {
        Class<?> valueClass = value.getClass();
        if (GraphObject.class.isAssignableFrom(valueClass)) {
            value = ((GraphObject)value).getInnerJSONObject();
            valueClass = value.getClass();
        } else if (GraphObjectList.class.isAssignableFrom(valueClass)) {
            value = ((GraphObjectList)value).getInnerJSONArray();
            valueClass = value.getClass();
        }
        if (JSONObject.class.isAssignableFrom(valueClass)) {
            JSONObject jsonObject = (JSONObject)value;
            if (passByValue) {
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String propertyName = (String)keys.next();
                    String subKey = String.format("%s[%s]", key, propertyName);
                    Request.processGraphObjectProperty(subKey, jsonObject.opt(propertyName), serializer, passByValue);
                }
            } else if (jsonObject.has("id")) {
                Request.processGraphObjectProperty(key, jsonObject.optString("id"), serializer, passByValue);
            } else if (jsonObject.has("url")) {
                Request.processGraphObjectProperty(key, jsonObject.optString("url"), serializer, passByValue);
            }
        } else if (JSONArray.class.isAssignableFrom(valueClass)) {
            JSONArray jsonArray = (JSONArray)value;
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                String subKey = String.format("%s[%d]", key, i);
                Request.processGraphObjectProperty(subKey, jsonArray.opt(i), serializer, passByValue);
            }
        } else if (String.class.isAssignableFrom(valueClass) || Number.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
            serializer.writeString(key, value.toString());
        } else if (Date.class.isAssignableFrom(valueClass)) {
            Date date = (Date)value;
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            serializer.writeString(key, iso8601DateFormat.format(date));
        }
    }

    private static void serializeParameters(Bundle bundle, Serializer serializer) throws IOException {
        Set keys = bundle.keySet();
        for (String key : keys) {
            Object value = bundle.get(key);
            if (!Request.isSupportedParameterType(value)) continue;
            serializer.writeObject(key, value);
        }
    }

    private static void serializeAttachments(Bundle bundle, Serializer serializer) throws IOException {
        Set keys = bundle.keySet();
        for (String key : keys) {
            Object value = bundle.get(key);
            if (!Request.isSupportedAttachmentType(value)) continue;
            serializer.writeObject(key, value);
        }
    }

    private static void serializeRequestsAsJSON(Serializer serializer, Collection<Request> requests, Bundle attachments) throws JSONException, IOException {
        JSONArray batch = new JSONArray();
        for (Request request : requests) {
            request.serializeToBatch(batch, attachments);
        }
        String batchAsString = batch.toString();
        serializer.writeString(BATCH_PARAM, batchAsString);
    }

    private static String getMimeContentType() {
        return String.format("multipart/form-data; boundary=%s", MIME_BOUNDARY);
    }

    private static String getUserAgent() {
        if (userAgent == null) {
            userAgent = String.format("%s.%s", USER_AGENT_BASE, "3.0.0");
        }
        return userAgent;
    }

    private static String getBatchAppId(RequestBatch batch) {
        if (!Utility.isNullOrEmpty(batch.getBatchApplicationId())) {
            return batch.getBatchApplicationId();
        }
        for (Request request : batch) {
            Session session = request.session;
            if (session == null) continue;
            return session.getApplicationId();
        }
        return defaultBatchApplicationId;
    }

    private static <T extends GraphObject> List<T> typedListFromResponse(Response response, Class<T> clazz) {
        GraphMultiResult multiResult = response.getGraphObjectAs(GraphMultiResult.class);
        if (multiResult == null) {
            return null;
        }
        GraphObjectList<GraphObject> data = multiResult.getData();
        if (data == null) {
            return null;
        }
        return data.castToListOf(clazz);
    }

    private static boolean isSupportedAttachmentType(Object value) {
        return value instanceof Bitmap || value instanceof byte[] || value instanceof ParcelFileDescriptor;
    }

    private static boolean isSupportedParameterType(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Date;
    }

    private static String parameterToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Date) {
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            return iso8601DateFormat.format(value);
        }
        throw new IllegalArgumentException("Unsupported parameter type.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GraphPlaceListCallback {
        public void onCompleted(List<GraphPlace> var1, Response var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GraphUserListCallback {
        public void onCompleted(List<GraphUser> var1, Response var2);
    }

    public static interface GraphUserCallback {
        public void onCompleted(GraphUser var1, Response var2);
    }

    public static interface Callback {
        public void onCompleted(Response var1);
    }

    private static class Serializer
    implements KeyValueSerializer {
        private final BufferedOutputStream outputStream;
        private final Logger logger;
        private boolean firstWrite = true;

        public Serializer(BufferedOutputStream outputStream, Logger logger) {
            this.outputStream = outputStream;
            this.logger = logger;
        }

        public void writeObject(String key, Object value) throws IOException {
            if (Request.isSupportedParameterType(value)) {
                this.writeString(key, Request.parameterToString(value));
            } else if (value instanceof Bitmap) {
                this.writeBitmap(key, (Bitmap)value);
            } else if (value instanceof byte[]) {
                this.writeBytes(key, (byte[])value);
            } else if (value instanceof ParcelFileDescriptor) {
                this.writeFile(key, (ParcelFileDescriptor)value);
            } else {
                throw new IllegalArgumentException("value is not a supported type: String, Bitmap, byte[]");
            }
        }

        public void writeString(String key, String value) throws IOException {
            this.writeContentDisposition(key, null, null);
            this.writeLine("%s", value);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, value);
            }
        }

        public void writeBitmap(String key, Bitmap bitmap) throws IOException {
            this.writeContentDisposition(key, key, "image/png");
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)this.outputStream);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            this.logger.appendKeyValue("    " + key, "<Image>");
        }

        public void writeBytes(String key, byte[] bytes) throws IOException {
            this.writeContentDisposition(key, key, "content/unknown");
            this.outputStream.write(bytes);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            this.logger.appendKeyValue("    " + key, String.format("<Data: %d>", bytes.length));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFile(String key, ParcelFileDescriptor descriptor) throws IOException {
            this.writeContentDisposition(key, key, "content/unknown");
            ParcelFileDescriptor.AutoCloseInputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            int totalBytes = 0;
            try {
                int bytesRead;
                inputStream = new ParcelFileDescriptor.AutoCloseInputStream(descriptor);
                bufferedInputStream = new BufferedInputStream((InputStream)inputStream);
                byte[] buffer = new byte[8192];
                while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                    this.outputStream.write(buffer, 0, bytesRead);
                    totalBytes += bytesRead;
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            this.logger.appendKeyValue("    " + key, String.format("<Data: %d>", totalBytes));
        }

        public void writeRecordBoundary() throws IOException {
            this.writeLine("--%s", Request.MIME_BOUNDARY);
        }

        public void writeContentDisposition(String name, String filename, String contentType) throws IOException {
            this.write("Content-Disposition: form-data; name=\"%s\"", name);
            if (filename != null) {
                this.write("; filename=\"%s\"", filename);
            }
            this.writeLine("", new Object[0]);
            if (contentType != null) {
                this.writeLine("%s: %s", Request.CONTENT_TYPE_HEADER, contentType);
            }
            this.writeLine("", new Object[0]);
        }

        public void write(String format, Object ... args) throws IOException {
            if (this.firstWrite) {
                this.outputStream.write("--".getBytes());
                this.outputStream.write(Request.MIME_BOUNDARY.getBytes());
                this.outputStream.write("\r\n".getBytes());
                this.firstWrite = false;
            }
            this.outputStream.write(String.format(format, args).getBytes());
        }

        public void writeLine(String format, Object ... args) throws IOException {
            this.write(format, args);
            this.write("\r\n", new Object[0]);
        }
    }

    private static interface KeyValueSerializer {
        public void writeString(String var1, String var2) throws IOException;
    }
}

