/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.preference.SharedPreferences;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Settings {
    private static final HashSet<LoggingBehavior> loggingBehaviors = new HashSet<LoggingBehavior>(Arrays.asList(LoggingBehavior.DEVELOPER_ERRORS));
    private static volatile Executor executor;
    private static volatile boolean shouldAutoPublishInstall;
    private static final int DEFAULT_CORE_POOL_SIZE = 5;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 128;
    private static final int DEFAULT_KEEP_ALIVE = 1;
    private static final Object LOCK;
    private static final Uri ATTRIBUTION_ID_CONTENT_URI;
    private static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final String ATTRIBUTION_PREFERENCES = "com.facebook.sdk.attributionTracking";
    private static final String PUBLISH_ACTIVITY_PATH = "%s/activities";
    private static final String MOBILE_INSTALL_EVENT = "MOBILE_APP_INSTALL";
    private static final String ANALYTICS_EVENT = "event";
    private static final String ATTRIBUTION_KEY = "attribution";
    private static final BlockingQueue<Runnable> DEFAULT_WORK_QUEUE;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set<LoggingBehavior> getLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return Collections.unmodifiableSet(new HashSet<LoggingBehavior>(loggingBehaviors));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.add(behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.remove((Object)behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isLoggingBehaviorEnabled(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return loggingBehaviors.contains((Object)behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                Executor executor = Settings.getAsyncTaskExecutor();
                if (executor == null) {
                    executor = new ThreadPoolExecutor(5, 128, 1L, TimeUnit.SECONDS, DEFAULT_WORK_QUEUE, DEFAULT_THREAD_FACTORY);
                }
                Settings.executor = executor;
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutor(Executor executor) {
        Validate.notNull(executor, "executor");
        Object object = LOCK;
        synchronized (object) {
            Settings.executor = executor;
        }
    }

    private static Executor getAsyncTaskExecutor() {
        Field executorField = null;
        try {
            executorField = AsyncTask.class.getField("THREAD_POOL_EXECUTOR");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (executorField == null) {
            return null;
        }
        Object executorObject = null;
        try {
            executorObject = executorField.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (executorObject == null) {
            return null;
        }
        if (!(executorObject instanceof Executor)) {
            return null;
        }
        return (Executor)executorObject;
    }

    public static void publishInstallAsync(Context context, String applicationId) {
        Settings.publishInstallAsync(context, applicationId, null);
    }

    public static void publishInstallAsync(Context context, final String applicationId, final Request.Callback callback) {
        final Context applicationContext = context.getApplicationContext();
        Settings.getExecutor().execute(new Runnable(){

            public void run() {
                final Response response = Settings.publishInstallAndWaitForResponse(applicationContext, applicationId);
                if (callback != null) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        public void run() {
                            callback.onCompleted(response);
                        }
                    });
                }
            }
        });
    }

    public static void setShouldAutoPublishInstall(boolean shouldAutoPublishInstall) {
        Settings.shouldAutoPublishInstall = shouldAutoPublishInstall;
    }

    public static boolean getShouldAutoPublishInstall() {
        return shouldAutoPublishInstall;
    }

    public static boolean publishInstallAndWait(Context context, String applicationId) {
        Response response = Settings.publishInstallAndWaitForResponse(context, applicationId);
        return response != null && response.getError() == null;
    }

    public static Response publishInstallAndWaitForResponse(Context context, String applicationId) {
        try {
            if (context == null || applicationId == null) {
                throw new IllegalArgumentException("Both context and applicationId must be non-null");
            }
            String attributionId = Settings.getAttributionId(context.getContentResolver());
            SharedPreferences preferences = PreferenceManager.wrap(context, ATTRIBUTION_PREFERENCES, 0);
            String pingKey = applicationId + "ping";
            String jsonKey = applicationId + "json";
            long lastPing = preferences.getLong(pingKey, 0L);
            String lastResponseJSON = preferences.getString(jsonKey, null);
            GraphObject publishParams = GraphObject.Factory.create();
            publishParams.setProperty(ANALYTICS_EVENT, MOBILE_INSTALL_EVENT);
            publishParams.setProperty(ATTRIBUTION_KEY, attributionId);
            String publishUrl = String.format(PUBLISH_ACTIVITY_PATH, applicationId);
            Request publishRequest = Request.newPostRequest(null, publishUrl, publishParams, null);
            if (lastPing != 0L) {
                GraphObject graphObject = null;
                try {
                    if (lastResponseJSON != null) {
                        graphObject = GraphObject.Factory.create(new JSONObject(lastResponseJSON));
                    }
                }
                catch (JSONException je) {
                    // empty catch block
                }
                if (graphObject == null) {
                    return Response.createResponsesFromString("true", null, new RequestBatch(publishRequest), true).get(0);
                }
                return new Response(null, null, graphObject, true);
            }
            if (attributionId == null) {
                throw new FacebookException("No attribution id returned from the Facebook application");
            }
            if (!Utility.queryAppAttributionSupportAndWait(applicationId)) {
                throw new FacebookException("Install attribution has been disabled on the server.");
            }
            Response publishResponse = publishRequest.executeAndWait();
            SharedPreferences.Editor editor = preferences.edit();
            lastPing = System.currentTimeMillis();
            editor.putLong(pingKey, lastPing);
            if (publishResponse.getGraphObject() != null && publishResponse.getGraphObject().getInnerJSONObject() != null) {
                editor.putString(jsonKey, publishResponse.getGraphObject().getInnerJSONObject().toString());
            }
            editor.commit();
            return publishResponse;
        }
        catch (Exception e) {
            Utility.logd("Facebook-publish", e);
            return new Response(null, null, new FacebookRequestError(null, e));
        }
    }

    public static String getAttributionId(ContentResolver contentResolver) {
        String[] projection = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
        Cursor c = contentResolver.query(ATTRIBUTION_ID_CONTENT_URI, projection, null, null, null);
        if (c == null || !c.moveToFirst()) {
            return null;
        }
        String attributionId = c.getString(c.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
        c.close();
        return attributionId;
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    public static String getMigrationBundle() {
        return "fbsdk:20121026";
    }

    static {
        LOCK = new Object();
        ATTRIBUTION_ID_CONTENT_URI = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
        DEFAULT_WORK_QUEUE = new LinkedBlockingQueue<Runnable>(10);
        DEFAULT_THREAD_FACTORY = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "FacebookSdk #" + this.counter.incrementAndGet());
            }
        };
    }
}

