/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.HttpMethod;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionState;
import com.facebook.TokenCachingStrategy;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.holoeverywhere.app.Activity;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSession
extends Session {
    private static final long serialVersionUID = 1L;
    private static final String LOG_TAG = "FacebookSDK.TestSession";
    private static Map<String, TestAccount> appTestAccounts;
    private static String testApplicationSecret;
    private static String testApplicationId;
    private final String sessionUniqueUserTag;
    private final List<String> requestedPermissions;
    private final Mode mode;
    private String testAccountId;
    private boolean wasAskedToExtendAccessToken;

    TestSession(Activity activity, List<String> permissions, TokenCachingStrategy tokenCachingStrategy, String sessionUniqueUserTag, Mode mode) {
        super((Context)activity, testApplicationId, tokenCachingStrategy);
        Validate.notNull(permissions, "permissions");
        Validate.notNullOrEmpty(testApplicationId, "testApplicationId");
        Validate.notNullOrEmpty(testApplicationSecret, "testApplicationSecret");
        this.sessionUniqueUserTag = sessionUniqueUserTag;
        this.mode = mode;
        this.requestedPermissions = permissions;
    }

    public static TestSession createSessionWithPrivateUser(Activity activity, List<String> permissions) {
        return TestSession.createTestSession(activity, permissions, Mode.PRIVATE, null);
    }

    public static TestSession createSessionWithSharedUser(Activity activity, List<String> permissions) {
        return TestSession.createSessionWithSharedUser(activity, permissions, null);
    }

    public static TestSession createSessionWithSharedUser(Activity activity, List<String> permissions, String sessionUniqueUserTag) {
        return TestSession.createTestSession(activity, permissions, Mode.SHARED, sessionUniqueUserTag);
    }

    public static synchronized String getTestApplicationId() {
        return testApplicationId;
    }

    public static synchronized void setTestApplicationId(String applicationId) {
        if (testApplicationId != null && !testApplicationId.equals(applicationId)) {
            throw new FacebookException("Can't have more than one test application ID");
        }
        testApplicationId = applicationId;
    }

    public static synchronized String getTestApplicationSecret() {
        return testApplicationSecret;
    }

    public static synchronized void setTestApplicationSecret(String applicationSecret) {
        if (testApplicationSecret != null && !testApplicationSecret.equals(applicationSecret)) {
            throw new FacebookException("Can't have more than one test application secret");
        }
        testApplicationSecret = applicationSecret;
    }

    public final String getTestUserId() {
        return this.testAccountId;
    }

    private static synchronized TestSession createTestSession(Activity activity, List<String> permissions, Mode mode, String sessionUniqueUserTag) {
        if (Utility.isNullOrEmpty(testApplicationId) || Utility.isNullOrEmpty(testApplicationSecret)) {
            throw new FacebookException("Must provide app ID and secret");
        }
        if (Utility.isNullOrEmpty(permissions)) {
            permissions = Arrays.asList("email", "publish_actions");
        }
        return new TestSession(activity, permissions, new TestTokenCachingStrategy(), sessionUniqueUserTag, mode);
    }

    private static synchronized void retrieveTestAccountsForAppIfNeeded() {
        JSONObject multiquery;
        if (appTestAccounts != null) {
            return;
        }
        appTestAccounts = new HashMap<String, TestAccount>();
        String testAccountQuery = String.format("SELECT id,access_token FROM test_account WHERE app_id = %s", testApplicationId);
        String userQuery = "SELECT uid,name FROM user WHERE uid IN (SELECT id FROM #test_accounts)";
        Bundle parameters = new Bundle();
        try {
            multiquery = new JSONObject();
            multiquery.put("test_accounts", (Object)testAccountQuery);
            multiquery.put("users", (Object)userQuery);
        }
        catch (JSONException exception) {
            throw new FacebookException(exception);
        }
        parameters.putString("q", multiquery.toString());
        parameters.putString("access_token", TestSession.getAppAccessToken());
        Request request = new Request(null, "fql", parameters, null);
        Response response = request.executeAndWait();
        if (response.getError() != null) {
            throw response.getError().getException();
        }
        FqlResponse fqlResponse = response.getGraphObjectAs(FqlResponse.class);
        GraphObjectList<FqlResult> fqlResults = fqlResponse.getData();
        if (fqlResults == null || fqlResults.size() != 2) {
            throw new FacebookException("Unexpected number of results from FQL query");
        }
        GraphObjectList<TestAccount> testAccounts = ((FqlResult)fqlResults.get(0)).getFqlResultSet().castToListOf(TestAccount.class);
        GraphObjectList<UserAccount> userAccounts = ((FqlResult)fqlResults.get(1)).getFqlResultSet().castToListOf(UserAccount.class);
        TestSession.populateTestAccounts(testAccounts, userAccounts);
    }

    private static synchronized void populateTestAccounts(Collection<TestAccount> testAccounts, Collection<UserAccount> userAccounts) {
        for (TestAccount testAccount : testAccounts) {
            TestSession.storeTestAccount(testAccount);
        }
        for (UserAccount userAccount : userAccounts) {
            TestAccount testAccount = appTestAccounts.get(userAccount.getUid());
            if (testAccount == null) continue;
            testAccount.setName(userAccount.getName());
        }
    }

    private static synchronized void storeTestAccount(TestAccount testAccount) {
        appTestAccounts.put(testAccount.getId(), testAccount);
    }

    private static synchronized TestAccount findTestAccountMatchingIdentifier(String identifier) {
        TestSession.retrieveTestAccountsForAppIfNeeded();
        for (TestAccount testAccount : appTestAccounts.values()) {
            if (!testAccount.getName().contains(identifier)) continue;
            return testAccount;
        }
        return null;
    }

    @Override
    public final String toString() {
        String superString = super.toString();
        return "{TestSession" + " testUserId:" + this.testAccountId + " " + superString + "}";
    }

    @Override
    void authorize(Session.AuthorizationRequest request) {
        if (this.mode == Mode.PRIVATE) {
            this.createTestAccountAndFinishAuth();
        } else {
            this.findOrCreateSharedTestAccount();
        }
    }

    @Override
    void postStateChange(SessionState oldState, SessionState newState, Exception error) {
        String id2 = this.testAccountId;
        super.postStateChange(oldState, newState, error);
        if (newState.isClosed() && id2 != null && this.mode == Mode.PRIVATE) {
            this.deleteTestAccount(id2, TestSession.getAppAccessToken());
        }
    }

    boolean getWasAskedToExtendAccessToken() {
        return this.wasAskedToExtendAccessToken;
    }

    void forceExtendAccessToken(boolean forceExtendAccessToken) {
        AccessToken currentToken = this.getTokenInfo();
        this.setTokenInfo(new AccessToken(currentToken.getToken(), new Date(), currentToken.getPermissions(), AccessTokenSource.TEST_USER, new Date(0L)));
        this.setLastAttemptedTokenExtendDate(new Date(0L));
    }

    @Override
    boolean shouldExtendAccessToken() {
        boolean result = super.shouldExtendAccessToken();
        this.wasAskedToExtendAccessToken = false;
        return result;
    }

    @Override
    void extendAccessToken() {
        this.wasAskedToExtendAccessToken = true;
        super.extendAccessToken();
    }

    void fakeTokenRefreshAttempt() {
        this.setCurrentTokenRefreshRequest(new Session.TokenRefreshRequest(this));
    }

    static final String getAppAccessToken() {
        return testApplicationId + "|" + testApplicationSecret;
    }

    private void findOrCreateSharedTestAccount() {
        TestAccount testAccount = TestSession.findTestAccountMatchingIdentifier(this.getSharedTestAccountIdentifier());
        if (testAccount != null) {
            this.finishAuthWithTestAccount(testAccount);
        } else {
            this.createTestAccountAndFinishAuth();
        }
    }

    private void finishAuthWithTestAccount(TestAccount testAccount) {
        this.testAccountId = testAccount.getId();
        AccessToken accessToken = AccessToken.createFromString(testAccount.getAccessToken(), this.requestedPermissions, AccessTokenSource.TEST_USER);
        this.finishAuthOrReauth(accessToken, null);
    }

    private TestAccount createTestAccountAndFinishAuth() {
        Bundle parameters = new Bundle();
        parameters.putString("installed", "true");
        parameters.putString("permissions", this.getPermissionsString());
        parameters.putString("access_token", TestSession.getAppAccessToken());
        if (this.mode == Mode.SHARED) {
            parameters.putString("name", String.format("Shared %s Testuser", this.getSharedTestAccountIdentifier()));
        }
        String graphPath = String.format("%s/accounts/test-users", testApplicationId);
        Request createUserRequest = new Request(null, graphPath, parameters, HttpMethod.POST);
        Response response = createUserRequest.executeAndWait();
        FacebookRequestError error = response.getError();
        TestAccount testAccount = response.getGraphObjectAs(TestAccount.class);
        if (error != null) {
            this.finishAuthOrReauth(null, error.getException());
            return null;
        }
        assert (testAccount != null);
        if (this.mode == Mode.SHARED) {
            testAccount.setName(parameters.getString("name"));
            TestSession.storeTestAccount(testAccount);
        }
        this.finishAuthWithTestAccount(testAccount);
        return testAccount;
    }

    private void deleteTestAccount(String testAccountId, String appAccessToken) {
        Bundle parameters = new Bundle();
        parameters.putString("access_token", appAccessToken);
        Request request = new Request(null, testAccountId, parameters, HttpMethod.DELETE);
        Response response = request.executeAndWait();
        FacebookRequestError error = response.getError();
        GraphObject graphObject = response.getGraphObject();
        if (error != null) {
            Log.w((String)LOG_TAG, (String)String.format("Could not delete test account %s: %s", testAccountId, error.getException().toString()));
        } else if (graphObject.getProperty("FACEBOOK_NON_JSON_RESULT") == Boolean.valueOf(false)) {
            Log.w((String)LOG_TAG, (String)String.format("Could not delete test account %s: unknown reason", testAccountId));
        }
    }

    private String getPermissionsString() {
        return TextUtils.join((CharSequence)",", this.requestedPermissions);
    }

    private String getSharedTestAccountIdentifier() {
        long permissionsHash = (long)this.getPermissionsString().hashCode() & 0xFFFFFFFFL;
        long sessionTagHash = this.sessionUniqueUserTag != null ? (long)this.sessionUniqueUserTag.hashCode() & 0xFFFFFFFFL : 0L;
        long combinedHash = permissionsHash ^ sessionTagHash;
        return this.validNameStringFromInteger(combinedHash);
    }

    private String validNameStringFromInteger(long i) {
        String s = Long.toString(i);
        StringBuilder result = new StringBuilder("Perm");
        char lastChar = '\u0000';
        for (char c : s.toCharArray()) {
            if (c == lastChar) {
                c = (char)(c + 10);
            }
            result.append((char)(c + 97 - 48));
            lastChar = c;
        }
        return result.toString();
    }

    private static final class TestTokenCachingStrategy
    extends TokenCachingStrategy {
        private Bundle bundle;

        private TestTokenCachingStrategy() {
        }

        public Bundle load() {
            return this.bundle;
        }

        public void save(Bundle value) {
            this.bundle = value;
        }

        public void clear() {
            this.bundle = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface FqlResponse
    extends GraphObject {
        public GraphObjectList<FqlResult> getData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface FqlResult
    extends GraphObject {
        public GraphObjectList<GraphObject> getFqlResultSet();
    }

    private static interface UserAccount
    extends GraphObject {
        public String getUid();

        public String getName();

        public void setName(String var1);
    }

    private static interface TestAccount
    extends GraphObject {
        public String getId();

        public String getAccessToken();

        public String getName();

        public void setName(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        PRIVATE,
        SHARED;

    }
}

