/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.model.GraphObject;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utility {
    static final String LOG_TAG = "FacebookSDK";
    private static final String HASH_ALGORITHM_MD5 = "MD5";
    private static final String URL_SCHEME = "https";
    private static final String SUPPORTS_ATTRIBUTION = "supports_attribution";
    private static final String APPLICATION_FIELDS = "fields";
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 8192;
    private static final Object LOCK = new Object();
    private static volatile boolean attributionAllowedForLastAppChecked = false;
    private static volatile String lastAppCheckedForAttributionStatus = "";

    public static <T> boolean isSubset(Collection<T> subset, Collection<T> superset) {
        if (superset == null || superset.size() == 0) {
            return subset == null || subset.size() == 0;
        }
        HashSet<T> hash = new HashSet<T>(superset);
        for (T t : subset) {
            if (hash.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static <T> Collection<T> unmodifiableCollection(T ... ts) {
        return Collections.unmodifiableCollection(Arrays.asList(ts));
    }

    public static <T> ArrayList<T> arrayList(T ... ts) {
        ArrayList<T> arrayList = new ArrayList<T>(ts.length);
        for (T t : ts) {
            arrayList.add(t);
        }
        return arrayList;
    }

    static String md5hash(String key) {
        MessageDigest hash = null;
        try {
            hash = MessageDigest.getInstance(HASH_ALGORITHM_MD5);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        hash.update(key.getBytes());
        byte[] digest = hash.digest();
        StringBuilder builder = new StringBuilder();
        for (byte b : digest) {
            builder.append(Integer.toHexString(b >> 4 & 0xF));
            builder.append(Integer.toHexString(b >> 0 & 0xF));
        }
        return builder.toString();
    }

    public static Uri buildUri(String authority, String path, Bundle parameters) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(URL_SCHEME);
        builder.authority(authority);
        builder.path(path);
        for (String key : parameters.keySet()) {
            Object parameter = parameters.get(key);
            if (!(parameter instanceof String)) continue;
            builder.appendQueryParameter(key, (String)parameter);
        }
        return builder.build();
    }

    public static void putObjectInBundle(Bundle bundle, String key, Object value) {
        if (value instanceof String) {
            bundle.putString(key, (String)value);
        } else if (value instanceof Parcelable) {
            bundle.putParcelable(key, (Parcelable)value);
        } else if (value instanceof byte[]) {
            bundle.putByteArray(key, (byte[])value);
        } else {
            throw new FacebookException("attempted to add unsupported type to Bundle");
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void disconnectQuietly(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public static String getMetadataApplicationId(Context context) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (ai.metaData != null) {
                return ai.metaData.getString("com.facebook.sdk.ApplicationId");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static Map<String, Object> convertJSONObjectToHashMap(JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONArray keys = jsonObject.names();
        for (int i = 0; i < keys.length(); ++i) {
            try {
                String key = keys.getString(i);
                Map<String, Object> value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    value = Utility.convertJSONObjectToHashMap((JSONObject)value);
                }
                map.put(key, value);
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        return map;
    }

    public static Object getStringPropertyAsJSON(JSONObject jsonObject, String key, String nonJSONPropertyKey) throws JSONException {
        Object value = jsonObject.opt(key);
        if (value != null && value instanceof String) {
            JSONTokener tokener = new JSONTokener((String)value);
            value = tokener.nextValue();
        }
        if (value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray)) {
            if (nonJSONPropertyKey != null) {
                jsonObject = new JSONObject();
                jsonObject.putOpt(nonJSONPropertyKey, value);
                return jsonObject;
            }
            throw new FacebookException("Got an unexpected non-JSON object.");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamToString(InputStream inputStream) throws IOException {
        String string2;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            reader = new InputStreamReader(bufferedInputStream);
            StringBuilder stringBuilder = new StringBuilder();
            int bufferSize = 2048;
            char[] buffer = new char[2048];
            int n = 0;
            while ((n = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, n);
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            Utility.closeQuietly(bufferedInputStream);
            Utility.closeQuietly(reader);
            throw throwable;
        }
        Utility.closeQuietly(bufferedInputStream);
        Utility.closeQuietly(reader);
        return string2;
    }

    public static boolean stringsEqualOrEmpty(String a, String b) {
        boolean aEmpty = TextUtils.isEmpty((CharSequence)a);
        boolean bEmpty = TextUtils.isEmpty((CharSequence)b);
        if (aEmpty && bEmpty) {
            return true;
        }
        if (!aEmpty && !bEmpty) {
            return a.equals(b);
        }
        return false;
    }

    private static void clearCookiesForDomain(Context context, String domain) {
        String[] splitCookies;
        CookieSyncManager syncManager = CookieSyncManager.createInstance((Context)context);
        syncManager.sync();
        CookieManager cookieManager = CookieManager.getInstance();
        String cookies = cookieManager.getCookie(domain);
        if (cookies == null) {
            return;
        }
        for (String cookie : splitCookies = cookies.split(";")) {
            String[] cookieParts = cookie.split("=");
            if (cookieParts.length <= 0) continue;
            String newCookie = cookieParts[0].trim() + "=;expires=Sat, 1 Jan 2000 00:00:01 UTC;";
            cookieManager.setCookie(domain, newCookie);
        }
        cookieManager.removeExpiredCookie();
    }

    public static void clearFacebookCookies(Context context) {
        Utility.clearCookiesForDomain(context, "facebook.com");
        Utility.clearCookiesForDomain(context, ".facebook.com");
        Utility.clearCookiesForDomain(context, "https://facebook.com");
        Utility.clearCookiesForDomain(context, "https://.facebook.com");
    }

    public static void logd(String tag, Exception e) {
        if (tag != null && e != null) {
            Log.d((String)tag, (String)(e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    public static void logd(String tag, String msg) {
        if (tag != null && msg != null) {
            Log.d((String)tag, (String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean queryAppAttributionSupportAndWait(String applicationId) {
        Object object = LOCK;
        synchronized (object) {
            if (applicationId.equals(lastAppCheckedForAttributionStatus)) {
                return attributionAllowedForLastAppChecked;
            }
            Bundle supportsAttributionParams = new Bundle();
            supportsAttributionParams.putString(APPLICATION_FIELDS, SUPPORTS_ATTRIBUTION);
            Request pingRequest = Request.newGraphPathRequest(null, applicationId, null);
            pingRequest.setParameters(supportsAttributionParams);
            GraphObject supportResponse = pingRequest.executeAndWait().getGraphObject();
            Object doesSupportAttribution = false;
            if (supportResponse != null) {
                doesSupportAttribution = supportResponse.getProperty(SUPPORTS_ATTRIBUTION);
            }
            if (!(doesSupportAttribution instanceof Boolean)) {
                doesSupportAttribution = false;
            }
            lastAppCheckedForAttributionStatus = applicationId;
            attributionAllowedForLastAppChecked = (Boolean)doesSupportAttribution == true;
            return attributionAllowedForLastAppChecked;
        }
    }
}

