/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.facebook.FacebookException;
import com.facebook.Request;
import com.facebook.Session;
import com.facebook.model.GraphUser;
import com.facebook.widget.GraphObjectPagingLoader;
import com.facebook.widget.PickerFragment;
import com.facebook.widget.SimpleGraphObjectCursor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.holoeverywhere.addon.facebook.R;
import org.holoeverywhere.app.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FriendPickerFragment
extends PickerFragment<GraphUser> {
    public static final String USER_ID_BUNDLE_KEY = "com.facebook.widget.FriendPickerFragment.UserId";
    public static final String MULTI_SELECT_BUNDLE_KEY = "com.facebook.widget.FriendPickerFragment.MultiSelect";
    private static final String ID = "id";
    private static final String NAME = "name";
    private String userId;
    private boolean multiSelect = true;

    public FriendPickerFragment() {
        this(null);
    }

    @SuppressLint(value={"ValidFragment"})
    public FriendPickerFragment(Bundle args) {
        super(GraphUser.class, R.layout.com_facebook_friendpickerfragment, args);
        this.setFriendPickerSettingsFromBundle(args);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean getMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        if (this.multiSelect != multiSelect) {
            this.multiSelect = multiSelect;
            this.setSelectionStrategy(this.createSelectionStrategy());
        }
    }

    public List<GraphUser> getSelection() {
        return this.getSelectedGraphObjects();
    }

    @Override
    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        TypedArray a = activity.obtainStyledAttributes(attrs, R.styleable.com_facebook_friend_picker_fragment);
        this.setMultiSelect(a.getBoolean(0, this.multiSelect));
        a.recycle();
    }

    @Override
    public void setSettingsFromBundle(Bundle inState) {
        super.setSettingsFromBundle(inState);
        this.setFriendPickerSettingsFromBundle(inState);
    }

    @Override
    void saveSettingsToBundle(Bundle outState) {
        super.saveSettingsToBundle(outState);
        outState.putString(USER_ID_BUNDLE_KEY, this.userId);
        outState.putBoolean(MULTI_SELECT_BUNDLE_KEY, this.multiSelect);
    }

    @Override
    PickerFragment.PickerFragmentAdapter<GraphUser> createAdapter() {
        PickerFragment.PickerFragmentAdapter<GraphUser> adapter = new PickerFragment.PickerFragmentAdapter<GraphUser>((Context)this.getSupportActivity()){

            @Override
            protected int getGraphObjectRowLayoutId(GraphUser graphObject) {
                return R.layout.com_facebook_picker_list_row;
            }

            @Override
            protected int getDefaultPicture() {
                return R.drawable.com_facebook_profile_default_icon;
            }
        };
        adapter.setShowCheckbox(true);
        adapter.setShowPicture(this.getShowPictures());
        adapter.setSortFields(Arrays.asList(NAME));
        adapter.setGroupByField(NAME);
        return adapter;
    }

    @Override
    PickerFragment.LoadingStrategy createLoadingStrategy() {
        return new ImmediateLoadingStrategy();
    }

    @Override
    PickerFragment.SelectionStrategy createSelectionStrategy() {
        return this.multiSelect ? new PickerFragment.MultiSelectionStrategy() : new PickerFragment.SingleSelectionStrategy();
    }

    @Override
    Request getRequestForLoadData(Session session) {
        if (this.adapter == null) {
            throw new FacebookException("Can't issue requests until Fragment has been created.");
        }
        String userToFetch = this.userId != null ? this.userId : "me";
        return this.createRequest(userToFetch, this.extraFields, session);
    }

    @Override
    String getDefaultTitleText() {
        return this.getString(R.string.com_facebook_choose_friends);
    }

    private Request createRequest(String userID, Set<String> extraFields, Session session) {
        Request request = Request.newGraphPathRequest(session, userID + "/friends", null);
        HashSet<String> fields = new HashSet<String>(extraFields);
        String[] requiredFields = new String[]{ID, NAME};
        fields.addAll(Arrays.asList(requiredFields));
        String pictureField = this.adapter.getPictureFieldSpecifier();
        if (pictureField != null) {
            fields.add(pictureField);
        }
        Bundle parameters = request.getParameters();
        parameters.putString("fields", TextUtils.join((CharSequence)",", fields));
        request.setParameters(parameters);
        return request;
    }

    private void setFriendPickerSettingsFromBundle(Bundle inState) {
        if (inState != null) {
            if (inState.containsKey(USER_ID_BUNDLE_KEY)) {
                this.setUserId(inState.getString(USER_ID_BUNDLE_KEY));
            }
            this.setMultiSelect(inState.getBoolean(MULTI_SELECT_BUNDLE_KEY, this.multiSelect));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmediateLoadingStrategy
    extends PickerFragment.LoadingStrategy {
        private ImmediateLoadingStrategy() {
        }

        protected void onLoadFinished(GraphObjectPagingLoader<GraphUser> loader, SimpleGraphObjectCursor<GraphUser> data) {
            super.onLoadFinished(loader, data);
            if (data == null || loader.isLoading()) {
                return;
            }
            if (data.areMoreObjectsAvailable()) {
                this.followNextLink();
            } else {
                FriendPickerFragment.this.hideActivityCircle();
                if (data.isFromCache()) {
                    loader.refreshOriginalRequest(data.getCount() == 0 ? 2000L : 0L);
                }
            }
        }

        private void followNextLink() {
            FriendPickerFragment.this.displayActivityCircle();
            this.loader.followNextLink();
        }
    }
}

