/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.widget.ImageRequest;
import com.facebook.widget.ImageResponse;
import com.facebook.widget.ImageResponseCache;
import com.facebook.widget.UrlRedirectCache;
import com.facebook.widget.WorkQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class ImageDownloader {
    private static final int DOWNLOAD_QUEUE_MAX_CONCURRENT = 8;
    private static final int CACHE_READ_QUEUE_MAX_CONCURRENT = 2;
    private static final Handler handler = new Handler();
    private static WorkQueue downloadQueue = new WorkQueue(8);
    private static WorkQueue cacheReadQueue = new WorkQueue(2);
    private static final Map<RequestKey, DownloaderContext> pendingRequests = new HashMap<RequestKey, DownloaderContext>();

    ImageDownloader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void downloadAsync(ImageRequest request) {
        if (request == null) {
            return;
        }
        RequestKey key = new RequestKey(request.getImageUrl(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                downloaderContext.request = request;
                downloaderContext.isCancelled = false;
                downloaderContext.workItem.moveToFront();
            } else {
                ImageDownloader.enqueueCacheRead(request, key, request.isCachedRedirectAllowed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean cancelRequest(ImageRequest request) {
        boolean cancelled = false;
        RequestKey key = new RequestKey(request.getImageUrl(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                cancelled = true;
                if (downloaderContext.workItem.cancel()) {
                    pendingRequests.remove(key);
                } else {
                    downloaderContext.isCancelled = true;
                }
            }
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void prioritizeRequest(ImageRequest request) {
        RequestKey key = new RequestKey(request.getImageUrl(), request.getCallerTag());
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = pendingRequests.get(key);
            if (downloaderContext != null) {
                downloaderContext.workItem.moveToFront();
            }
        }
    }

    private static void enqueueCacheRead(ImageRequest request, RequestKey key, boolean allowCachedRedirects) {
        ImageDownloader.enqueueRequest(request, key, cacheReadQueue, new CacheReadWorkItem(request.getContext(), key, allowCachedRedirects));
    }

    private static void enqueueDownload(ImageRequest request, RequestKey key) {
        ImageDownloader.enqueueRequest(request, key, downloadQueue, new DownloadImageWorkItem(request.getContext(), key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueueRequest(ImageRequest request, RequestKey key, WorkQueue workQueue, Runnable workItem) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            DownloaderContext downloaderContext = new DownloaderContext();
            downloaderContext.request = request;
            pendingRequests.put(key, downloaderContext);
            downloaderContext.workItem = workQueue.addActiveWorkItem(workItem);
        }
    }

    private static void issueResponse(RequestKey key, final Exception error, final Bitmap bitmap, final boolean isCachedRedirect) {
        ImageRequest request;
        ImageRequest.Callback callback;
        DownloaderContext completedRequestContext = ImageDownloader.removePendingRequest(key);
        if (completedRequestContext != null && !completedRequestContext.isCancelled && (callback = (request = completedRequestContext.request).getCallback()) != null) {
            handler.post(new Runnable(){

                public void run() {
                    ImageResponse response = new ImageResponse(request, error, isCachedRedirect, bitmap);
                    callback.onCompleted(response);
                }
            });
        }
    }

    private static void readFromCache(RequestKey key, Context context, boolean allowCachedRedirects) {
        URL redirectUrl;
        InputStream cachedStream = null;
        boolean isCachedRedirect = false;
        if (allowCachedRedirects && (redirectUrl = UrlRedirectCache.getRedirectedUrl(context, key.url)) != null) {
            cachedStream = ImageResponseCache.getCachedImageStream(redirectUrl, context);
            boolean bl = isCachedRedirect = cachedStream != null;
        }
        if (!isCachedRedirect) {
            cachedStream = ImageResponseCache.getCachedImageStream(key.url, context);
        }
        if (cachedStream != null) {
            Bitmap bitmap = BitmapFactory.decodeStream(cachedStream);
            Utility.closeQuietly(cachedStream);
            ImageDownloader.issueResponse(key, null, bitmap, isCachedRedirect);
        } else {
            DownloaderContext downloaderContext = ImageDownloader.removePendingRequest(key);
            if (downloaderContext != null && !downloaderContext.isCancelled) {
                ImageDownloader.enqueueDownload(downloaderContext.request, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(RequestKey key, Context context) {
        boolean issueResponse;
        Bitmap bitmap;
        Exception error;
        block11: {
            HttpURLConnection connection = null;
            InputStream stream = null;
            error = null;
            bitmap = null;
            issueResponse = true;
            try {
                connection = (HttpURLConnection)key.url.openConnection();
                connection.setInstanceFollowRedirects(false);
                switch (connection.getResponseCode()) {
                    case 301: 
                    case 302: {
                        issueResponse = false;
                        String redirectLocation = connection.getHeaderField("location");
                        if (Utility.isNullOrEmpty(redirectLocation)) break;
                        URL redirectUrl = new URL(redirectLocation);
                        UrlRedirectCache.cacheUrlRedirect(context, key.url, redirectUrl);
                        DownloaderContext downloaderContext = ImageDownloader.removePendingRequest(key);
                        if (downloaderContext == null || downloaderContext.isCancelled) break;
                        ImageDownloader.enqueueCacheRead(downloaderContext.request, new RequestKey(redirectUrl, key.tag), false);
                        break;
                    }
                    case 200: {
                        stream = ImageResponseCache.interceptAndCacheImageStream(context, connection);
                        bitmap = BitmapFactory.decodeStream((InputStream)stream);
                        break;
                    }
                    default: {
                        int bufferLength;
                        stream = connection.getErrorStream();
                        InputStreamReader reader = new InputStreamReader(stream);
                        char[] buffer = new char[128];
                        StringBuilder errorMessageBuilder = new StringBuilder();
                        while ((bufferLength = reader.read(buffer, 0, buffer.length)) > 0) {
                            errorMessageBuilder.append(buffer, 0, bufferLength);
                        }
                        Utility.closeQuietly(reader);
                        error = new FacebookException(errorMessageBuilder.toString());
                    }
                }
                Utility.closeQuietly(stream);
            }
            catch (IOException e) {
                error = e;
                break block11;
            }
            finally {
                Utility.closeQuietly(stream);
                Utility.disconnectQuietly(connection);
            }
            Utility.disconnectQuietly(connection);
        }
        if (issueResponse) {
            ImageDownloader.issueResponse(key, error, bitmap, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DownloaderContext removePendingRequest(RequestKey key) {
        Map<RequestKey, DownloaderContext> map = pendingRequests;
        synchronized (map) {
            return pendingRequests.remove(key);
        }
    }

    private static class DownloadImageWorkItem
    implements Runnable {
        private Context context;
        private RequestKey key;

        DownloadImageWorkItem(Context context, RequestKey key) {
            this.context = context;
            this.key = key;
        }

        public void run() {
            ImageDownloader.download(this.key, this.context);
        }
    }

    private static class CacheReadWorkItem
    implements Runnable {
        private Context context;
        private RequestKey key;
        private boolean allowCachedRedirects;

        CacheReadWorkItem(Context context, RequestKey key, boolean allowCachedRedirects) {
            this.context = context;
            this.key = key;
            this.allowCachedRedirects = allowCachedRedirects;
        }

        public void run() {
            ImageDownloader.readFromCache(this.key, this.context, this.allowCachedRedirects);
        }
    }

    private static class DownloaderContext {
        WorkQueue.WorkItem workItem;
        ImageRequest request;
        boolean isCancelled;

        private DownloaderContext() {
        }
    }

    private static class RequestKey {
        private static final int HASH_SEED = 29;
        private static final int HASH_MULTIPLIER = 37;
        URL url;
        Object tag;

        RequestKey(URL url, Object tag) {
            this.url = url;
            this.tag = tag;
        }

        public int hashCode() {
            int result = 29;
            result = result * 37 + this.url.hashCode();
            result = result * 37 + this.tag.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            boolean isEqual = false;
            if (o != null && o instanceof RequestKey) {
                RequestKey compareTo = (RequestKey)o;
                isEqual = compareTo.url == this.url && compareTo.tag == this.tag;
            }
            return isEqual;
        }
    }
}

