/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

class UrlRedirectCache {
    static final String TAG = UrlRedirectCache.class.getSimpleName();
    private static final String REDIRECT_CONTENT_TAG = TAG + "_Redirect";
    private static volatile FileLruCache urlRedirectCache;

    UrlRedirectCache() {
    }

    static synchronized FileLruCache getCache(Context context) throws IOException {
        if (urlRedirectCache == null) {
            urlRedirectCache = new FileLruCache(context.getApplicationContext(), TAG, new FileLruCache.Limits());
        }
        return urlRedirectCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL getRedirectedUrl(Context context, URL url) {
        if (url == null) {
            return null;
        }
        String urlString = url.toString();
        URL finalUrl = null;
        InputStreamReader reader = null;
        try {
            InputStream stream;
            FileLruCache cache = UrlRedirectCache.getCache(context);
            boolean redirectExists = false;
            while ((stream = cache.get(urlString, REDIRECT_CONTENT_TAG)) != null) {
                int bufferLength;
                redirectExists = true;
                reader = new InputStreamReader(stream);
                char[] buffer = new char[128];
                StringBuilder urlBuilder = new StringBuilder();
                while ((bufferLength = reader.read(buffer, 0, buffer.length)) > 0) {
                    urlBuilder.append(buffer, 0, bufferLength);
                }
                Utility.closeQuietly(reader);
                urlString = urlBuilder.toString();
            }
            if (redirectExists) {
                finalUrl = new URL(urlString);
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException ioe) {
        }
        finally {
            Utility.closeQuietly(reader);
        }
        return finalUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void cacheUrlRedirect(Context context, URL fromUrl, URL toUrl) {
        if (fromUrl == null || toUrl == null) {
            return;
        }
        OutputStream redirectStream = null;
        try {
            FileLruCache cache = UrlRedirectCache.getCache(context);
            redirectStream = cache.openPutStream(fromUrl.toString(), REDIRECT_CONTENT_TAG);
            redirectStream.write(toUrl.toString().getBytes());
        }
        catch (IOException e) {
            Utility.closeQuietly(redirectStream);
            catch (Throwable throwable) {
                Utility.closeQuietly(redirectStream);
                throw throwable;
            }
        }
        Utility.closeQuietly(redirectStream);
    }
}

