/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionDefaultAudience;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.model.GraphUser;
import com.facebook.widget.FacebookFragment;
import com.facebook.widget.ImageDownloader;
import com.facebook.widget.ImageRequest;
import com.facebook.widget.ImageResponse;
import com.facebook.widget.LoginButton;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.addon.facebook.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSettingsFragment
extends FacebookFragment {
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String PICTURE = "picture";
    private static final String FIELDS = "fields";
    private static final String REQUEST_FIELDS = TextUtils.join((CharSequence)",", (Object[])new String[]{"id", "name", "picture"});
    private LoginButton loginButton;
    private LoginButton.LoginButtonProperties loginButtonProperties = new LoginButton.LoginButtonProperties();
    private TextView connectedStateLabel;
    private GraphUser user;
    private Session userInfoSession;
    private Drawable userProfilePic;
    private String userProfilePicID;
    private Session.StatusCallback sessionStatusCallback;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.com_facebook_usersettingsfragment, container, false);
        this.loginButton = (LoginButton)view.findViewById(R.id.com_facebook_usersettingsfragment_login_button);
        this.loginButton.setProperties(this.loginButtonProperties);
        this.loginButton.setFragment(this);
        Session session = this.getSession();
        if (session != null && !session.equals(Session.getActiveSession())) {
            this.loginButton.setSession(session);
        }
        this.connectedStateLabel = (TextView)view.findViewById(R.id.com_facebook_usersettingsfragment_profile_name);
        if (view.getBackground() == null) {
            view.setBackgroundColor(this.getResources().getColor(R.color.com_facebook_blue));
        } else {
            view.getBackground().setDither(true);
        }
        return view;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public void onResume() {
        super.onResume();
        this.fetchUserInfo();
        this.updateUI();
    }

    @Override
    public void setSession(Session newSession) {
        super.setSession(newSession);
        if (this.loginButton != null) {
            this.loginButton.setSession(newSession);
        }
        this.fetchUserInfo();
        this.updateUI();
    }

    public void setDefaultAudience(SessionDefaultAudience defaultAudience) {
        this.loginButtonProperties.setDefaultAudience(defaultAudience);
    }

    public SessionDefaultAudience getDefaultAudience() {
        return this.loginButtonProperties.getDefaultAudience();
    }

    public void setReadPermissions(List<String> permissions) {
        this.loginButtonProperties.setReadPermissions(permissions, this.getSession());
    }

    public void setPublishPermissions(List<String> permissions) {
        this.loginButtonProperties.setPublishPermissions(permissions, this.getSession());
    }

    public void clearPermissions() {
        this.loginButtonProperties.clearPermissions();
    }

    public void setLoginBehavior(SessionLoginBehavior loginBehavior) {
        this.loginButtonProperties.setLoginBehavior(loginBehavior);
    }

    public SessionLoginBehavior getLoginBehavior() {
        return this.loginButtonProperties.getLoginBehavior();
    }

    public void setOnErrorListener(LoginButton.OnErrorListener onErrorListener) {
        this.loginButtonProperties.setOnErrorListener(onErrorListener);
    }

    public LoginButton.OnErrorListener getOnErrorListener() {
        return this.loginButtonProperties.getOnErrorListener();
    }

    public void setSessionStatusCallback(Session.StatusCallback callback) {
        this.sessionStatusCallback = callback;
    }

    public Session.StatusCallback getSessionStatusCallback() {
        return this.sessionStatusCallback;
    }

    @Override
    protected void onSessionStateChange(SessionState state, Exception exception) {
        this.fetchUserInfo();
        this.updateUI();
        if (this.sessionStatusCallback != null) {
            this.sessionStatusCallback.call(this.getSession(), state, exception);
        }
    }

    List<String> getPermissions() {
        return this.loginButtonProperties.getPermissions();
    }

    private void fetchUserInfo() {
        final Session currentSession = this.getSession();
        if (currentSession != null && currentSession.isOpened()) {
            if (currentSession != this.userInfoSession) {
                Request request = Request.newMeRequest(currentSession, new Request.GraphUserCallback(){

                    public void onCompleted(GraphUser me, Response response) {
                        if (currentSession == UserSettingsFragment.this.getSession()) {
                            UserSettingsFragment.this.user = me;
                            UserSettingsFragment.this.updateUI();
                        }
                        if (response.getError() != null) {
                            UserSettingsFragment.this.loginButton.handleError(response.getError().getException());
                        }
                    }
                });
                Bundle parameters = new Bundle();
                parameters.putString(FIELDS, REQUEST_FIELDS);
                request.setParameters(parameters);
                Request.executeBatchAsync(request);
                this.userInfoSession = currentSession;
            }
        } else {
            this.user = null;
        }
    }

    private void updateUI() {
        if (!this.isAdded()) {
            return;
        }
        if (this.isSessionOpen()) {
            this.connectedStateLabel.setTextColor(this.getResources().getColor(R.color.com_facebook_usersettingsfragment_connected_text_color));
            this.connectedStateLabel.setShadowLayer(1.0f, 0.0f, -1.0f, this.getResources().getColor(R.color.com_facebook_usersettingsfragment_connected_shadow_color));
            if (this.user != null) {
                URL requestUrl;
                ImageRequest request = this.getImageRequest();
                if (request != null && !(requestUrl = request.getImageUrl()).equals(this.connectedStateLabel.getTag())) {
                    if (this.user.getId().equals(this.userProfilePicID)) {
                        this.connectedStateLabel.setCompoundDrawables(null, this.userProfilePic, null, null);
                        this.connectedStateLabel.setTag((Object)requestUrl);
                    } else {
                        ImageDownloader.downloadAsync(request);
                    }
                }
                this.connectedStateLabel.setText((CharSequence)this.user.getName());
            } else {
                this.connectedStateLabel.setText((CharSequence)this.getResources().getString(R.string.com_facebook_usersettingsfragment_logged_in));
                Drawable noProfilePic = this.getResources().getDrawable(R.drawable.com_facebook_profile_default_icon);
                noProfilePic.setBounds(0, 0, this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_width), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_height));
                this.connectedStateLabel.setCompoundDrawables(null, noProfilePic, null, null);
            }
        } else {
            int textColor = this.getResources().getColor(R.color.com_facebook_usersettingsfragment_not_connected_text_color);
            this.connectedStateLabel.setTextColor(textColor);
            this.connectedStateLabel.setShadowLayer(0.0f, 0.0f, 0.0f, textColor);
            this.connectedStateLabel.setText((CharSequence)this.getResources().getString(R.string.com_facebook_usersettingsfragment_not_logged_in));
            this.connectedStateLabel.setCompoundDrawables(null, null, null, null);
            this.connectedStateLabel.setTag(null);
        }
    }

    private ImageRequest getImageRequest() {
        ImageRequest request = null;
        try {
            ImageRequest.Builder requestBuilder = new ImageRequest.Builder((Context)this.getActivity(), ImageRequest.getProfilePictureUrl(this.user.getId(), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_width), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_height)));
            request = requestBuilder.setCallerTag(this).setCallback(new ImageRequest.Callback(){

                public void onCompleted(ImageResponse response) {
                    UserSettingsFragment.this.processImageResponse(UserSettingsFragment.this.user.getId(), response);
                }
            }).build();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return request;
    }

    private void processImageResponse(String id2, ImageResponse response) {
        Bitmap bitmap;
        if (response != null && (bitmap = response.getBitmap()) != null) {
            BitmapDrawable drawable2 = new BitmapDrawable(this.getResources(), bitmap);
            drawable2.setBounds(0, 0, this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_width), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_usersettingsfragment_profile_picture_height));
            this.userProfilePic = drawable2;
            this.userProfilePicID = id2;
            this.connectedStateLabel.setCompoundDrawables(null, (Drawable)drawable2, null, null);
            this.connectedStateLabel.setTag((Object)response.getRequest().getImageUrl());
        }
    }
}

