/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere;

import android.content.Context;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.holoeverywhere.R;
import org.holoeverywhere.util.SparseArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontLoader {
    public static final FontCollector ROBOTO;
    public static final Font ROBOTO_BLACK;
    public static final Font ROBOTO_BLACKITALIC;
    public static final Font ROBOTO_BOLD;
    public static final Font ROBOTO_BOLDCONDENSED;
    public static final Font ROBOTO_BOLDCONDENSEDITALIC;
    public static final Font ROBOTO_BOLDITALIC;
    public static final Font ROBOTO_CONDENSED;
    public static final Font ROBOTO_CONDENSEDITALIC;
    public static final Font ROBOTO_ITALIC;
    public static final Font ROBOTO_LIGHT;
    public static final Font ROBOTO_LIGHTITALIC;
    public static final Font ROBOTO_MEDIUM;
    public static final Font ROBOTO_MEDIUMITALIC;
    public static final Font ROBOTO_REGULAR;
    public static final Font ROBOTO_THIN;
    public static final Font ROBOTO_THINITALIC;
    private static Font sDefaultFont;

    public static <T extends View> T apply(T view, Font font) {
        if (view == null || font == null) {
            return view;
        }
        font.mContext = view.getContext();
        FontLoader.applyInternal(view, font);
        return view;
    }

    public static <T extends View> T applyDefaultFont(T view) {
        return FontLoader.apply(view, sDefaultFont);
    }

    private static void applyInternal(View view, Font font) {
        if (view instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)view;
            int childCount = vg.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                FontLoader.applyInternal(vg.getChildAt(i), font);
            }
        }
        if (view instanceof FontStyleProvider) {
            if (view.getTag(R.id.fontLoaderTag) == font) {
                return;
            }
            FontStyleProvider provider = (FontStyleProvider)view;
            Typeface typeface = font.getTypeface(provider.getFontStyle());
            if (typeface != null) {
                provider.setTypeface(typeface);
                view.setTag(R.id.fontLoaderTag, (Object)font);
            }
        }
    }

    public static Font getDefaultFont() {
        return sDefaultFont;
    }

    public static void setDefaultFont(Font defaultFont) {
        sDefaultFont = defaultFont;
    }

    private FontLoader() {
    }

    static {
        ROBOTO_REGULAR = new RawFont(R.raw.roboto_regular).setFontStyle(0);
        ROBOTO_BOLD = new RawFont(R.raw.roboto_bold).setFontStyle(1);
        ROBOTO_ITALIC = new RawFont(R.raw.roboto_italic).setFontStyle(2);
        ROBOTO_BOLDITALIC = new RawFont(R.raw.roboto_bolditalic).setFontStyle(3);
        ROBOTO_BLACK = new RawLazyFont("roboto_black").setFontStyle(8);
        ROBOTO_BLACKITALIC = new RawLazyFont("roboto_blackitalic").setFontStyle(10);
        ROBOTO_BOLDCONDENSED = new RawLazyFont("roboto_boldcondensed").setFontStyle(17);
        ROBOTO_BOLDCONDENSEDITALIC = new RawLazyFont("roboto_boldcondenseditalic").setFontStyle(19);
        ROBOTO_CONDENSED = new RawLazyFont("roboto_condensed").setFontStyle(16);
        ROBOTO_CONDENSEDITALIC = new RawLazyFont("roboto_condenseditalic").setFontStyle(18);
        ROBOTO_LIGHT = new RawLazyFont("roboto_light").setFontStyle(4);
        ROBOTO_LIGHTITALIC = new RawLazyFont("roboto_lightitalic").setFontStyle(6);
        ROBOTO_MEDIUM = new RawLazyFont("roboto_medium").setFontStyle(32);
        ROBOTO_MEDIUMITALIC = new RawLazyFont("roboto_mediumitalic").setFontStyle(34);
        ROBOTO_THIN = new RawLazyFont("roboto_thin").setFontStyle(64);
        ROBOTO_THINITALIC = new RawLazyFont("roboto_thinitalic").setFontStyle(66);
        ROBOTO = new FontCollector();
        sDefaultFont = ROBOTO;
        ROBOTO.register(ROBOTO_REGULAR);
        ROBOTO.register(ROBOTO_BOLD);
        ROBOTO.register(ROBOTO_ITALIC);
        ROBOTO.register(ROBOTO_BOLDITALIC);
        ROBOTO.register(ROBOTO_BLACK);
        ROBOTO.register(ROBOTO_BLACKITALIC);
        ROBOTO.register(ROBOTO_BOLDCONDENSED);
        ROBOTO.register(ROBOTO_BOLDCONDENSEDITALIC);
        ROBOTO.register(ROBOTO_CONDENSED);
        ROBOTO.register(ROBOTO_CONDENSEDITALIC);
        ROBOTO.register(ROBOTO_LIGHT);
        ROBOTO.register(ROBOTO_LIGHTITALIC);
        ROBOTO.register(ROBOTO_MEDIUM);
        ROBOTO.register(ROBOTO_MEDIUMITALIC);
        ROBOTO.register(ROBOTO_THIN);
        ROBOTO.register(ROBOTO_THINITALIC);
    }

    public static class RawLazyFont
    extends RawFont {
        private String mRawResourceName;

        public RawLazyFont(String rawResourceName) {
            super(0);
            this.mRawResourceName = rawResourceName;
        }

        public Typeface loadTypeface() {
            this.assertParent();
            int id2 = this.getContext().getResources().getIdentifier(this.mRawResourceName, "raw", this.getContext().getPackageName());
            if (id2 == 0) {
                throw new IllegalStateException("Could not find font in raw resources: " + this.mRawResourceName);
            }
            this.setRawResourceId(id2);
            return this.loadTypeface(true);
        }
    }

    public static class RawFont
    extends Font {
        private int mRawResourceId;

        public RawFont(int rawResourceId) {
            this.mRawResourceId = rawResourceId;
        }

        public Typeface loadTypeface() {
            this.assertParent();
            return this.loadTypeface(true);
        }

        protected Typeface loadTypeface(boolean allowFileReusage) {
            return this.loadTypeface(new File(this.getContext().getCacheDir(), "font_0x" + Integer.toHexString(this.mRawResourceId)), allowFileReusage);
        }

        private Typeface loadTypeface(File file, boolean allowFileReusage) {
            if (file.exists() && allowFileReusage) {
                try {
                    Typeface typeface = Typeface.createFromFile((File)file);
                    if (typeface == null) {
                        throw new NullPointerException();
                    }
                    return typeface;
                }
                catch (Exception e) {
                    return this.loadTypeface(false);
                }
            }
            try {
                int c;
                InputStream is = this.getContext().getResources().openRawResource(this.mRawResourceId);
                FileOutputStream os = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((c = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, c);
                }
                os.flush();
                ((OutputStream)os).close();
                is.close();
                return this.loadTypeface(file, allowFileReusage);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void setRawResourceId(int rawResourceId) {
            this.mRawResourceId = rawResourceId;
            this.resetTypeface();
        }
    }

    public static interface FontStyleProvider {
        public int getFontStyle();

        public void setTypeface(Typeface var1);
    }

    public static class FontCollector
    extends Font {
        private final SparseArray<Font> mFonts = new SparseArray();

        public Typeface getTypeface(int fontStyle) {
            Font font = this.mFonts.get(fontStyle);
            if (font != null) {
                font.mContext = this.getContext();
                return font.getTypeface(fontStyle);
            }
            return null;
        }

        public void register(Font font) {
            int fontStyle = font.getFontStyle();
            if (this.mFonts.get(fontStyle) != null) {
                throw new IllegalStateException("Could not register font " + font + " with the fontStyle " + fontStyle + ": already exists");
            }
            if (font instanceof FontCollector) {
                SparseArray<Font> fonts = ((FontCollector)font).mFonts;
                for (int i = 0; i < fonts.size(); ++i) {
                    this.register(fonts.valueAt(i));
                }
                return;
            }
            this.mFonts.put(fontStyle, font);
        }

        public void unregister(Font font) {
            this.unregister(font.getFontStyle());
        }

        public void unregister(int fontStyle) {
            this.mFonts.delete(fontStyle);
        }
    }

    public static class Font {
        private Context mContext;
        private int mFontStyle;
        private Typeface mTypeface;
        private boolean mTypefaceLoaded = false;

        protected final void assertParent() {
            if (this.mContext == null) {
                throw new IllegalStateException("Cannot load typeface without attaching font instance to FontLoader");
            }
        }

        public final Context getContext() {
            return this.mContext;
        }

        public int getFontStyle() {
            return this.mFontStyle;
        }

        public Typeface getTypeface(int fontStyle) {
            if (!this.mTypefaceLoaded) {
                this.mTypeface = this.loadTypeface();
                this.mTypefaceLoaded = true;
            }
            return this.mTypeface;
        }

        public Typeface loadTypeface() {
            return null;
        }

        protected final void resetTypeface() {
            this.mTypeface = null;
            this.mTypefaceLoaded = false;
        }

        public Font setFontStyle(int fontStyle) {
            this.mFontStyle = fontStyle;
            return this;
        }
    }
}

