/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.addon;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import org.holoeverywhere.HoloEverywhere;
import org.holoeverywhere.addon.IAddonBase;
import org.holoeverywhere.util.WeaklyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IAddon {
    private static final Map<Class<? extends IAddon>, IAddon> sAddonsMap = new HashMap<Class<? extends IAddon>, IAddon>();
    private final Map<Object, Object> mStatesMap = new WeaklyMap<Object, Object>();
    private final Map<Class<?>, Class<? extends IAddonBase<?>>> mTypesMap = new HashMap();

    public static <T extends IAddon> T addon(Class<T> clazz) {
        try {
            IAddon t = sAddonsMap.get(clazz);
            if (t == null) {
                t = (IAddon)clazz.newInstance();
                sAddonsMap.put(clazz, t);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IAddon> T addon(String classname) {
        Class<T> clazz = IAddon.makeAddonClass(classname);
        return IAddon.addon(clazz);
    }

    public static <T extends IAddon> Class<T> makeAddonClass(String classname) {
        if (classname.contains(".")) {
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return IAddon.makeAddonClass(HoloEverywhere.PACKAGE + ".addon.Addon" + classname);
    }

    public static <T extends IAddon, Z extends IAddonBase<V>, V> Z obtain(Class<T> clazz, V object) {
        return (Z)((IAddon)IAddon.addon(clazz)).obtain(object);
    }

    public static <T extends IAddon, Z extends IAddonBase<V>, V> Z obtain(String classname, V object) {
        return (Z)((IAddon)IAddon.addon(classname)).obtain(object);
    }

    public <T, V extends IAddonBase<T>> V obtain(T object) {
        try {
            IAddonBase<?> addon = (IAddonBase<?>)this.mStatesMap.get(object);
            if (addon != null) {
                return (V)addon;
            }
            Class<?> clazz = object.getClass();
            while (!this.mTypesMap.containsKey(clazz)) {
                if (clazz == Object.class) {
                    return null;
                }
                clazz = clazz.getSuperclass();
            }
            addon = this.mTypesMap.get(clazz).newInstance();
            addon.attach(object, this);
            this.mStatesMap.put(object, addon);
            return (V)addon;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void register(Class<T> clazz, Class<? extends IAddonBase<T>> addonClazz) {
        this.mTypesMap.put(clazz, addonClazz);
    }

    public void unregister(Class<?> clazz) {
        this.mTypesMap.remove(clazz);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Addon {
        public boolean inhert() default false;

        public int weight() default -1;
    }
}

