/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.content.DialogInterface;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.internal.view.menu.ContextMenuDecorView;
import com.actionbarsherlock.internal.view.menu.ContextMenuItemWrapper;
import com.actionbarsherlock.internal.view.menu.ContextMenuListener;
import com.actionbarsherlock.internal.view.menu.ContextMenuWrapper;
import com.actionbarsherlock.view.ContextMenu;
import java.util.Map;
import org.holoeverywhere.HoloEverywhere;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.app.ContextThemeWrapperPlus;
import org.holoeverywhere.internal.WindowDecorView;
import org.holoeverywhere.util.WeaklyMap;

public class Dialog
extends android.app.Dialog
implements ContextMenuListener,
ContextMenuDecorView.ContextMenuListenersProvider {
    private Map<View, ContextMenuListener> mContextMenuListeners;
    private WindowDecorView mDecorView;

    private static final int checkTheme(Context context, int theme) {
        if (theme >= 0x1000000) {
            return theme;
        }
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.dialogTheme, value, true);
        if (value.resourceId > 0) {
            return value.resourceId;
        }
        return R.style.Holo_Theme_Dialog;
    }

    public Dialog(Context context) {
        this(context, 0);
    }

    public Dialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        this(context);
        this.setCancelable(cancelable);
        this.setOnCancelListener(cancelListener);
    }

    public Dialog(Context context, int theme) {
        this(context, Dialog.checkTheme(context, theme), -1);
        this.setCancelable(true);
    }

    private Dialog(Context context, int theme, int fallback) {
        super((Context)new ContextThemeWrapperPlus(context, theme), theme);
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        if (this.requestDecorView(view, params, -1)) {
            this.mDecorView.addView(view, params);
        }
    }

    public ContextMenuListener getContextMenuListener(View view) {
        if (this.mContextMenuListeners == null) {
            return null;
        }
        return this.mContextMenuListeners.get(view);
    }

    public LayoutInflater getLayoutInflater() {
        return LayoutInflater.from(this.getContext());
    }

    public final boolean onContextItemSelected(MenuItem item) {
        return this.onContextItemSelected(new ContextMenuItemWrapper(item));
    }

    public boolean onContextItemSelected(com.actionbarsherlock.view.MenuItem item) {
        if (item instanceof ContextMenuItemWrapper) {
            return super.onContextItemSelected(((ContextMenuItemWrapper)item).unwrap());
        }
        return false;
    }

    public void onContextMenuClosed(ContextMenu menu) {
        if (menu instanceof ContextMenuWrapper) {
            super.onContextMenuClosed((Menu)((ContextMenuWrapper)menu).unwrap());
        }
    }

    public final void onContextMenuClosed(Menu menu) {
        if (menu instanceof android.view.ContextMenu) {
            this.onContextMenuClosed(new ContextMenuWrapper((android.view.ContextMenu)menu));
        } else {
            super.onContextMenuClosed(menu);
        }
    }

    public final void onCreateContextMenu(android.view.ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        this.onCreateContextMenu(new ContextMenuWrapper(menu), view, menuInfo);
    }

    public void onCreateContextMenu(ContextMenu menu, View view, ContextMenu.ContextMenuInfo menuInfo) {
        if (menu instanceof ContextMenuWrapper) {
            super.onCreateContextMenu(((ContextMenuWrapper)menu).unwrap(), view, menuInfo);
        }
    }

    public void registerForContextMenu(View view) {
        if (HoloEverywhere.WRAP_TO_NATIVE_CONTEXT_MENU) {
            super.registerForContextMenu(view);
        } else {
            this.registerForContextMenu(view, this);
        }
    }

    public void registerForContextMenu(View view, ContextMenuListener listener) {
        if (this.mContextMenuListeners == null) {
            this.mContextMenuListeners = new WeaklyMap<View, ContextMenuListener>();
        }
        this.mContextMenuListeners.put(view, listener);
    }

    private boolean requestDecorView(View view, ViewGroup.LayoutParams params, int layoutRes) {
        if (this.mDecorView != null) {
            return true;
        }
        this.mDecorView = new WindowDecorView(this.getContext());
        this.mDecorView.setId(0x1020002);
        this.mDecorView.setProvider(this);
        if (view != null) {
            this.mDecorView.addView(view, params);
        } else if (layoutRes > 0) {
            this.getLayoutInflater().inflate(layoutRes, (ViewGroup)this.mDecorView, true);
        }
        this.getWindow().setContentView((View)this.mDecorView, new ViewGroup.LayoutParams(-1, -1));
        return false;
    }

    public void setCancelable(boolean flag) {
        super.setCancelable(flag);
        this.setCanceledOnTouchOutside(flag);
    }

    public void setContentView(int layoutResID) {
        if (this.requestDecorView(null, null, layoutResID)) {
            this.mDecorView.removeAllViewsInLayout();
            this.getLayoutInflater().inflate(layoutResID, (ViewGroup)this.mDecorView, true);
        }
    }

    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (this.requestDecorView(view, params, -1)) {
            this.mDecorView.removeAllViewsInLayout();
            this.mDecorView.addView(view, params);
        }
    }

    public void unregisterForContextMenu(View view) {
        if (HoloEverywhere.WRAP_TO_NATIVE_CONTEXT_MENU) {
            super.unregisterForContextMenu(view);
        } else if (this.mContextMenuListeners != null) {
            this.mContextMenuListeners.remove(view);
        }
    }
}

