/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.View;
import org.holoeverywhere.R;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.app.Fragment;
import org.holoeverywhere.app.TabSwipeFragment;
import org.holoeverywhere.app.TabSwipeInterface;
import org.holoeverywhere.widget.FrameLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabSwipeActivity
extends Activity
implements TabSwipeInterface<TabSwipeFragment.TabInfo> {
    private int mCustomLayout = 0;
    private InnerFragment mFragment;

    @Override
    public TabSwipeFragment.TabInfo addTab(CharSequence title, Class<? extends Fragment> fragmentClass) {
        return this.mFragment.addTab(title, (Class)fragmentClass);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(CharSequence title, Class<? extends Fragment> fragmentClass, Bundle fragmentArguments) {
        return this.mFragment.addTab(title, (Class)fragmentClass, fragmentArguments);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(int title, Class<? extends Fragment> fragmentClass) {
        return this.mFragment.addTab(title, (Class)fragmentClass);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(int title, Class<? extends Fragment> fragmentClass, Bundle fragmentArguments) {
        return this.mFragment.addTab(title, (Class)fragmentClass, fragmentArguments);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(TabSwipeFragment.TabInfo tabInfo) {
        return this.mFragment.addTab(tabInfo);
    }

    @Override
    public TabSwipeFragment.TabInfo addTab(TabSwipeFragment.TabInfo tabInfo, int position) {
        return this.mFragment.addTab(tabInfo, position);
    }

    @Override
    public TabSwipeInterface.OnTabSelectedListener getOnTabSelectedListener() {
        return this.mFragment.getOnTabSelectedListener();
    }

    @Override
    public boolean isSmoothScroll() {
        return this.mFragment.isSmoothScroll();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FrameLayout layout2 = new FrameLayout((Context)this);
        layout2.setId(R.id.contentPanel);
        this.setContentView((View)layout2);
        FragmentManager fm = this.getSupportFragmentManager();
        this.mFragment = (InnerFragment)fm.findFragmentById(R.id.contentPanel);
        if (this.mFragment == null) {
            this.mFragment = new InnerFragment();
        }
        this.mFragment.setActivity(this);
        if (this.mCustomLayout != 0) {
            this.mFragment.setCustomLayout(this.mCustomLayout);
        }
        if (!this.mFragment.isAdded()) {
            fm.beginTransaction().replace(R.id.contentPanel, (android.support.v4.app.Fragment)this.mFragment).commit();
        }
        fm.executePendingTransactions();
    }

    protected abstract void onHandleTabs();

    @Override
    public void reloadTabs() {
        this.mFragment.reloadTabs();
    }

    @Override
    public void removeAllTabs() {
        this.mFragment.removeAllTabs();
    }

    @Override
    public TabSwipeFragment.TabInfo removeTab(int position) {
        return this.mFragment.removeTab(position);
    }

    @Override
    public TabSwipeFragment.TabInfo removeTab(TabSwipeFragment.TabInfo tabInfo) {
        return this.mFragment.removeTab(tabInfo);
    }

    @Override
    public void setCurrentTab(int position) {
        this.mFragment.setCurrentTab(position);
    }

    @Override
    public void setCustomLayout(int customLayout) {
        this.mCustomLayout = customLayout;
    }

    @Override
    public void setOnTabSelectedListener(TabSwipeInterface.OnTabSelectedListener onTabSelectedListener) {
        this.mFragment.setOnTabSelectedListener(onTabSelectedListener);
    }

    @Override
    public void setSmoothScroll(boolean smoothScroll) {
        this.mFragment.setSmoothScroll(smoothScroll);
    }

    public static class InnerFragment
    extends TabSwipeFragment {
        private TabSwipeActivity mActivity;
        private boolean mTabsWasHandled = false;

        protected void onHandleTabs() {
            this.mTabsWasHandled = true;
            if (this.mActivity != null) {
                this.mActivity.onHandleTabs();
            }
        }

        public void setActivity(TabSwipeActivity activity) {
            if (activity == null) {
                return;
            }
            this.mActivity = activity;
            if (this.mTabsWasHandled) {
                this.mActivity.onHandleTabs();
            }
        }
    }
}

