/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.StateSet;
import java.io.IOException;
import org.holoeverywhere.R;
import org.holoeverywhere.drawable.DrawableCompat;
import org.holoeverywhere.drawable.DrawableContainer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawable
extends DrawableContainer {
    private static final boolean DEFAULT_DITHER = true;
    private boolean mMutated;
    private final StateListState mStateListState;

    public StateListDrawable() {
        this(null, null);
    }

    private StateListDrawable(StateListState state, Resources res) {
        StateListState as;
        this.mStateListState = as = new StateListState(state, this, res);
        this.setConstantState(as);
        this.onStateChange(this.getState());
    }

    public void addState(int[] stateSet, Drawable drawable2) {
        if (drawable2 != null) {
            this.mStateListState.addStateSet(stateSet, drawable2);
            this.onStateChange(this.getState());
        }
    }

    public int getStateCount() {
        return this.mStateListState.getChildCount();
    }

    public Drawable getStateDrawable(int index) {
        return this.mStateListState.getChildren()[index];
    }

    public int getStateDrawableIndex(int[] stateSet) {
        return this.mStateListState.indexOfStateSet(stateSet);
    }

    StateListState getStateListState() {
        return this.mStateListState;
    }

    public int[] getStateSet(int index) {
        return this.mStateListState.mStateSets[index];
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        TypedArray a = r.obtainAttributes(attrs, R.styleable.StateListDrawable);
        super.setVisible(a.getBoolean(1, true), false);
        this.mStateListState.setVariablePadding(a.getBoolean(2, false));
        this.mStateListState.setConstantSize(a.getBoolean(3, false));
        this.mStateListState.setEnterFadeDuration(a.getInt(4, 0));
        this.mStateListState.setExitFadeDuration(a.getInt(5, 0));
        this.setDither(a.getBoolean(0, true));
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            int stateResId;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            int drawableRes = 0;
            int j = 0;
            int numAttrs = attrs.getAttributeCount();
            int[] states = new int[numAttrs];
            for (int i = 0; i < numAttrs && (stateResId = attrs.getAttributeNameResource(i)) != 0; ++i) {
                if (stateResId == 0x1010199) {
                    drawableRes = attrs.getAttributeResourceValue(i, 0);
                    continue;
                }
                states[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
            }
            states = StateSet.trimStateSet((int[])states, (int)j);
            if (drawableRes != 0) {
                dr = DrawableCompat.getDrawable(r, drawableRes);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = DrawableCompat.createFromXmlInner(r, parser, attrs);
            }
            this.mStateListState.addStateSet(states, dr);
        }
        this.onStateChange(this.getState());
    }

    public boolean isStateful() {
        return true;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mStateListState.mStateSets = (int[][])this.mStateListState.mStateSets.clone();
            this.mMutated = true;
        }
        return this;
    }

    protected boolean onStateChange(int[] stateSet) {
        int idx = this.mStateListState.indexOfStateSet(stateSet);
        if (idx < 0) {
            idx = this.mStateListState.indexOfStateSet(StateSet.WILD_CARD);
        }
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onStateChange(stateSet);
    }

    static final class StateListState
    extends DrawableContainer.DrawableContainerState {
        int[][] mStateSets;

        StateListState(StateListState orig, StateListDrawable owner, Resources res) {
            super(orig, owner, res);
            this.mStateSets = orig != null ? orig.mStateSets : (int[][])new int[this.getChildren().length][];
        }

        int addStateSet(int[] stateSet, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mStateSets[pos] = stateSet;
            return pos;
        }

        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[][] newStateSets = new int[newSize][];
            System.arraycopy(this.mStateSets, 0, newStateSets, 0, oldSize);
            this.mStateSets = newStateSets;
        }

        private int indexOfStateSet(int[] stateSet) {
            int[][] stateSets = this.mStateSets;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (!StateSet.stateSetMatches((int[])stateSets[i], (int[])stateSet)) continue;
                return i;
            }
            return -1;
        }

        public Drawable newDrawable() {
            return new StateListDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new StateListDrawable(this, res);
        }
    }
}

