/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.actionbarsherlock.internal.view.menu.ContextMenuDecorView;
import org.holoeverywhere.R;

public class WindowDecorView
extends ContextMenuDecorView {
    private TypedValue mFixedHeightMajor;
    private TypedValue mFixedHeightMinor;
    private TypedValue mFixedWidthMajor;
    private TypedValue mFixedWidthMinor;
    private TypedValue mMinHeightMajor;
    private TypedValue mMinHeightMinor;
    private TypedValue mMinWidthMajor;
    private TypedValue mMinWidthMinor;

    public WindowDecorView(Context context) {
        super(context);
        TypedArray a = context.obtainStyledAttributes(R.styleable.WindowSizes);
        if (a.hasValue(0)) {
            this.mMinWidthMajor = new TypedValue();
            a.getValue(0, this.mMinWidthMajor);
        }
        if (a.hasValue(1)) {
            this.mMinWidthMinor = new TypedValue();
            a.getValue(1, this.mMinWidthMinor);
        }
        if (a.hasValue(6)) {
            this.mMinHeightMajor = new TypedValue();
            a.getValue(6, this.mMinHeightMajor);
        }
        if (a.hasValue(7)) {
            this.mMinHeightMinor = new TypedValue();
            a.getValue(7, this.mMinHeightMinor);
        }
        if (a.hasValue(4)) {
            this.mFixedWidthMajor = new TypedValue();
            a.getValue(4, this.mFixedWidthMajor);
        }
        if (a.hasValue(5)) {
            this.mFixedWidthMinor = new TypedValue();
            a.getValue(5, this.mFixedWidthMinor);
        }
        if (a.hasValue(2)) {
            this.mFixedHeightMajor = new TypedValue();
            a.getValue(2, this.mFixedHeightMajor);
        }
        if (a.hasValue(3)) {
            this.mFixedHeightMinor = new TypedValue();
            a.getValue(3, this.mFixedHeightMinor);
        }
        a.recycle();
    }

    protected boolean fitSystemWindows(Rect insets) {
        int left = Math.max(this.getPaddingLeft(), insets.left);
        int top = Math.max(this.getPaddingTop(), insets.top);
        int right = Math.max(this.getPaddingRight(), insets.right);
        int bottom = Math.max(this.getPaddingBottom(), insets.bottom);
        this.setPadding(left, top, right, bottom);
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int min;
        TypedValue tv;
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        boolean isPortrait = metrics.widthPixels < metrics.heightPixels;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        boolean fixedWidth = false;
        boolean fixedHeight = false;
        if (widthMode == Integer.MIN_VALUE) {
            int w;
            TypedValue tvw;
            TypedValue typedValue = tvw = isPortrait ? this.mFixedWidthMinor : this.mFixedWidthMajor;
            if (tvw != null && tvw.type != 0 && (w = tvw.type == 5 ? (int)tvw.getDimension(metrics) : (tvw.type == 6 ? (int)tvw.getFraction((float)metrics.widthPixels, (float)metrics.widthPixels) : 0)) > 0) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(w, View.MeasureSpec.getSize((int)widthMeasureSpec)), (int)0x40000000);
                fixedWidth = true;
            }
        }
        if (heightMode == Integer.MIN_VALUE) {
            int h;
            TypedValue tvh;
            TypedValue typedValue = tvh = isPortrait ? this.mFixedHeightMajor : this.mFixedHeightMinor;
            if (tvh != null && tvh.type != 0 && (h = tvh.type == 5 ? (int)tvh.getDimension(metrics) : (tvh.type == 6 ? (int)tvh.getFraction((float)metrics.heightPixels, (float)metrics.heightPixels) : 0)) > 0) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(h, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)0x40000000);
                fixedHeight = true;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        boolean measure = false;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        if (!fixedWidth && widthMode == Integer.MIN_VALUE) {
            TypedValue typedValue = tv = isPortrait ? this.mMinWidthMinor : this.mMinWidthMajor;
            if (tv != null && tv.type != 0 && width < (min = tv.type == 5 ? (int)tv.getDimension(metrics) : (tv.type == 6 ? (int)tv.getFraction((float)metrics.widthPixels, (float)metrics.widthPixels) : 0))) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)min, (int)0x40000000);
                measure = true;
            }
        }
        if (!fixedHeight && heightMode == Integer.MIN_VALUE) {
            TypedValue typedValue = tv = isPortrait ? this.mMinHeightMinor : this.mMinHeightMajor;
            if (tv != null && tv.type != 0 && height < (min = tv.type == 5 ? (int)tv.getDimension(metrics) : (tv.type == 6 ? (int)tv.getFraction((float)metrics.heightPixels, (float)metrics.heightPixels) : 0))) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)min, (int)0x40000000);
                measure = true;
            }
        }
        if (measure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

