/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import java.util.Calendar;
import org.holoeverywhere.app.DatePickerDialog;
import org.holoeverywhere.preference.DialogPreference;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.widget.DatePicker;

public class DatePreference
extends DialogPreference {
    private final DatePickerDialog.OnDateSetListener mCallback = new DatePickerDialog.OnDateSetListener(){

        public void onDateSet(DatePicker datePicker, int year, int month, int day) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(0L);
            calendar.set(1, DatePreference.this.mYear = year);
            calendar.set(2, DatePreference.this.mMonth = month);
            calendar.set(5, DatePreference.this.mDay = day);
            DatePreference.this.onDateSet(datePicker, calendar.getTimeInMillis(), year, month, day);
            DatePreference.this.updateDialogState();
        }
    };
    private long mDefaultDate;
    private boolean mDefaultDateSetted = false;
    private OnDateSetListener mOnDateSetListener;
    private int mYear;
    private int mMonth;
    private int mDay;

    public DatePreference(Context context) {
        this(context, null);
    }

    public DatePreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.datePreferenceStyle);
    }

    public DatePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePreference, defStyle, R.style.Holo_PreferenceDate);
        a.recycle();
    }

    public int getDay() {
        return this.mDay;
    }

    public long getDefaultDate() {
        if (!this.mDefaultDateSetted) {
            return System.currentTimeMillis();
        }
        return this.mDefaultDate;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public OnDateSetListener getOnDateSetListener() {
        return this.mOnDateSetListener;
    }

    public int getYear() {
        return this.mYear;
    }

    protected Dialog onCreateDialog(Context context) {
        return new DatePickerDialog(context, this.mCallback, this.mYear, this.mMonth, this.mDay);
    }

    public void onDateSet(DatePicker datePicker, long date, int year, int month, int day) {
        if (this.mOnDateSetListener == null || this.mOnDateSetListener.onDateSet(this, date, year, month, day)) {
            this.persistLong(date);
        }
    }

    protected String onGetDefaultValue(TypedArray a, int index) {
        String value = a.getString(index);
        if (value == null || value.length() == 0) {
            value = String.valueOf(this.getDefaultDate());
        }
        return value;
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        long time;
        if (restorePersistedValue) {
            defaultValue = this.getPersistedLong(this.getDefaultDate());
        }
        try {
            time = defaultValue instanceof Long ? (Long)defaultValue : Long.parseLong(String.valueOf(defaultValue));
            time = Long.parseLong(String.valueOf(defaultValue));
        }
        catch (Exception e) {
            time = this.getDefaultDate();
        }
        this.setTime(time);
    }

    public void resetDefaultDate() {
        this.mDefaultDateSetted = false;
    }

    public void setDay(int day) {
        this.mDay = day;
        this.updateDialogState();
    }

    public void setDefaultDate(long defaultDate) {
        this.mDefaultDate = defaultDate;
        this.mDefaultDateSetted = true;
    }

    public void setMonth(int month) {
        this.mMonth = month;
        this.updateDialogState();
    }

    public void setOnDateSetListener(OnDateSetListener onTimeSetListener) {
        this.mOnDateSetListener = onTimeSetListener;
    }

    private void setTime(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        this.mYear = calendar.get(1);
        this.mMonth = calendar.get(2);
        this.mDay = calendar.get(5);
        this.updateDialogState();
    }

    public void setYear(int year) {
        this.mYear = year;
        this.updateDialogState();
    }

    protected void updateDialogState() {
        DatePickerDialog dialog = (DatePickerDialog)this.getDialog();
        if (dialog != null) {
            dialog.updateDate(this.mYear, this.mMonth, this.mDay);
        }
    }

    public static interface OnDateSetListener {
        public boolean onDateSet(DatePreference var1, long var2, int var4, int var5, int var6);
    }
}

