/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.app.AlertDialog;
import org.holoeverywhere.app.ContextThemeWrapperPlus;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.preference.R;

public abstract class DialogPreference
extends Preference
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener,
PreferenceManager.OnActivityDestroyListener {
    private AlertDialog.Builder mBuilder;
    private Dialog mDialog;
    private Context mDialogContext;
    private Drawable mDialogIcon;
    private int mDialogLayoutResId;
    private CharSequence mDialogMessage;
    private CharSequence mDialogTitle;
    private InputMethodManager mInputMethodManager;
    private CharSequence mNegativeButtonText;
    private CharSequence mPositiveButtonText;
    private int mWhichButtonClicked;

    public DialogPreference(Context context) {
        this(context, null);
    }

    public DialogPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.dialogPreferenceStyle);
    }

    public DialogPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DialogPreference, defStyle, R.style.Holo_PreferenceDialog);
        this.mDialogTitle = a.getString(3);
        if (this.mDialogTitle == null) {
            this.mDialogTitle = this.getTitle();
        }
        this.mDialogMessage = a.getString(2);
        this.mDialogIcon = a.getDrawable(0);
        this.mPositiveButtonText = a.getString(5);
        this.mNegativeButtonText = a.getString(4);
        this.mDialogLayoutResId = a.getResourceId(1, this.mDialogLayoutResId);
        a.recycle();
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    protected Context getDialogContext(boolean alert) {
        if (this.mDialogContext != null) {
            return this.mDialogContext;
        }
        TypedArray a = this.getContext().obtainStyledAttributes(new int[]{alert ? R.attr.alertDialogTheme : R.attr.dialogTheme});
        int theme = a.getResourceId(0, R.style.Holo_Theme_Dialog_Alert);
        a.recycle();
        this.mDialogContext = new ContextThemeWrapperPlus(this.getContext(), theme);
        return this.mDialogContext;
    }

    public Drawable getDialogIcon() {
        return this.mDialogIcon;
    }

    public int getDialogLayoutResource() {
        return this.mDialogLayoutResId;
    }

    public CharSequence getDialogMessage() {
        return this.mDialogMessage;
    }

    public CharSequence getDialogTitle() {
        return this.mDialogTitle;
    }

    public CharSequence getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    public CharSequence getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    protected boolean needInputMethod() {
        return false;
    }

    public void onActivityDestroy() {
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return;
        }
        this.mDialog.dismiss();
    }

    protected void onBindDialogView(View view) {
        View dialogMessageView = view.findViewById(R.id.message);
        if (dialogMessageView != null) {
            CharSequence message = this.getDialogMessage();
            int newVisibility = 8;
            if (!TextUtils.isEmpty((CharSequence)message)) {
                if (dialogMessageView instanceof TextView) {
                    ((TextView)dialogMessageView).setText(message);
                }
                newVisibility = 0;
            }
            if (dialogMessageView.getVisibility() != newVisibility) {
                dialogMessageView.setVisibility(newVisibility);
            }
        }
    }

    protected void onClick() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            return;
        }
        this.showDialog(null);
    }

    public void onClick(DialogInterface dialog, int which) {
        this.mWhichButtonClicked = which;
    }

    protected Dialog onCreateDialog(Context context) {
        context = this.getDialogContext(true);
        this.mBuilder = new AlertDialog.Builder(context, ((ContextThemeWrapperPlus)context).getThemeResource());
        this.mBuilder.setTitle(this.mDialogTitle);
        this.mBuilder.setIcon(this.mDialogIcon);
        this.mBuilder.setPositiveButton(this.mPositiveButtonText, (DialogInterface.OnClickListener)this);
        this.mBuilder.setNegativeButton(this.mNegativeButtonText, (DialogInterface.OnClickListener)this);
        View contentView = this.onCreateDialogView(context);
        if (contentView != null) {
            this.onBindDialogView(contentView);
            this.mBuilder.setView(contentView);
        } else {
            this.mBuilder.setMessage(this.mDialogMessage);
        }
        this.onPrepareDialogBuilder(this.mBuilder);
        return this.mBuilder.create();
    }

    @Deprecated
    protected View onCreateDialogView() {
        return null;
    }

    protected View onCreateDialogView(Context context) {
        View view = this.onCreateDialogView();
        if (view != null) {
            return view;
        }
        if (this.mDialogLayoutResId == 0) {
            return null;
        }
        return LayoutInflater.inflate(context, this.mDialogLayoutResId);
    }

    protected void onDialogClosed(boolean positiveResult) {
    }

    public void onDismiss(DialogInterface dialog) {
        if (this.mInputMethodManager == null) {
            this.mInputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        }
        if (this.mDialog != null && this.mInputMethodManager.isActive()) {
            this.mInputMethodManager.hideSoftInputFromWindow(this.mDialog.getWindow().getDecorView().getApplicationWindowToken(), 1);
        }
        this.getPreferenceManager().unregisterOnActivityDestroyListener(this);
        this.mDialog = null;
        this.onDialogClosed(this.mWhichButtonClicked == -1);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = this.mDialog.onSaveInstanceState();
        return myState;
    }

    private void requestInputMethod(Dialog dialog) {
        Window window = dialog.getWindow();
        window.setSoftInputMode(5);
    }

    public void setDialogIcon(Drawable dialogIcon) {
        this.mDialogIcon = dialogIcon;
    }

    public void setDialogIcon(int dialogIconRes) {
        this.mDialogIcon = this.getContext().getResources().getDrawable(dialogIconRes);
    }

    public void setDialogLayoutResource(int dialogLayoutResId) {
        this.mDialogLayoutResId = dialogLayoutResId;
    }

    public void setDialogMessage(CharSequence dialogMessage) {
        this.mDialogMessage = dialogMessage;
    }

    public void setDialogMessage(int dialogMessageResId) {
        this.setDialogMessage(this.getContext().getString(dialogMessageResId));
    }

    public void setDialogTitle(CharSequence dialogTitle) {
        this.mDialogTitle = dialogTitle;
    }

    public void setDialogTitle(int dialogTitleResId) {
        this.setDialogTitle(this.getContext().getString(dialogTitleResId));
    }

    public void setNegativeButtonText(CharSequence negativeButtonText) {
        this.mNegativeButtonText = negativeButtonText;
    }

    public void setNegativeButtonText(int negativeButtonTextResId) {
        this.setNegativeButtonText(this.getContext().getString(negativeButtonTextResId));
    }

    public void setPositiveButtonText(CharSequence positiveButtonText) {
        this.mPositiveButtonText = positiveButtonText;
    }

    public void setPositiveButtonText(int positiveButtonTextResId) {
        this.setPositiveButtonText(this.getContext().getString(positiveButtonTextResId));
    }

    protected void showDialog(Bundle state) {
        this.mWhichButtonClicked = -2;
        this.mDialog = this.onCreateDialog(this.getContext());
        this.getPreferenceManager().registerOnActivityDestroyListener(this);
        if (state != null) {
            this.mDialog.onRestoreInstanceState(state);
        }
        if (this.needInputMethod()) {
            this.requestInputMethod(this.mDialog);
        }
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        this.mDialog.show();
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        Bundle dialogBundle;
        boolean isDialogShowing;

        public SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }
    }
}

