/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.widget.LinearLayout;

public class FragmentBreadCrumbs
extends ViewGroup
implements FragmentManager.OnBackStackChangedListener {
    FragmentActivity mActivity;
    LinearLayout mContainer;
    LayoutInflater mInflater;
    int mMaxVisible = -1;
    private OnBreadCrumbClickListener mOnBreadCrumbClickListener;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getTag() instanceof FragmentManager.BackStackEntry) {
                FragmentManager.BackStackEntry bse = (FragmentManager.BackStackEntry)v.getTag();
                if (bse == FragmentBreadCrumbs.this.mParentEntry) {
                    if (FragmentBreadCrumbs.this.mParentClickListener != null) {
                        FragmentBreadCrumbs.this.mParentClickListener.onClick(v);
                    }
                } else {
                    if (FragmentBreadCrumbs.this.mOnBreadCrumbClickListener != null && FragmentBreadCrumbs.this.mOnBreadCrumbClickListener.onBreadCrumbClick(bse == FragmentBreadCrumbs.this.mTopEntry ? null : bse, 0)) {
                        return;
                    }
                    if (bse == FragmentBreadCrumbs.this.mTopEntry) {
                        FragmentBreadCrumbs.this.mActivity.getSupportFragmentManager().popBackStack();
                    } else {
                        FragmentBreadCrumbs.this.mActivity.getSupportFragmentManager().popBackStack(bse.getId(), 0);
                    }
                }
            }
        }
    };
    private View.OnClickListener mParentClickListener;
    FragmentManager.BackStackEntry mParentEntry;
    FragmentManager.BackStackEntry mTopEntry;

    public FragmentBreadCrumbs(Context context) {
        this(context, null);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attrs) {
        this(context, attrs, 16973961);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private FragmentManager.BackStackEntry createBackStackEntry(final CharSequence title, final CharSequence shortTitle) {
        if (title == null) {
            return null;
        }
        return new FragmentManager.BackStackEntry(){

            public CharSequence getBreadCrumbShortTitle() {
                return shortTitle;
            }

            public int getBreadCrumbShortTitleRes() {
                return 0;
            }

            public CharSequence getBreadCrumbTitle() {
                return title;
            }

            public int getBreadCrumbTitleRes() {
                return 0;
            }

            public int getId() {
                return 2837452;
            }

            public String getName() {
                return "backstackentry";
            }
        };
    }

    private FragmentManager.BackStackEntry getPreEntry(int index) {
        if (this.mParentEntry != null) {
            return index == 0 ? this.mParentEntry : this.mTopEntry;
        }
        return this.mTopEntry;
    }

    private int getPreEntryCount() {
        return (this.mTopEntry != null ? 1 : 0) + (this.mParentEntry != null ? 1 : 0);
    }

    public void onBackStackChanged() {
        this.updateCrumbs();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childRight = this.getPaddingLeft() + child.getMeasuredWidth() - this.getPaddingRight();
            int childBottom = this.getPaddingTop() + child.getMeasuredHeight() - this.getPaddingBottom();
            child.layout(this.getPaddingLeft(), this.getPaddingTop(), childRight, childBottom);
        }
    }

    @SuppressLint(value={"NewApi"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        int measuredChildState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            measuredChildState = Build.VERSION.SDK_INT >= 11 ? View.combineMeasuredStates((int)measuredChildState, (int)child.getMeasuredState()) : View.combineMeasuredStates((int)measuredChildState, (int)0);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(View.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)measuredChildState), View.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(measuredChildState << 16)));
    }

    @SuppressLint(value={"NewApi"})
    public void setActivity(FragmentActivity a) {
        this.mActivity = a;
        this.mInflater = LayoutInflater.from((Context)a);
        this.mContainer = (LinearLayout)this.mInflater.inflate(R.layout.fragment_bread_crumbs, (ViewGroup)this, false);
        this.addView((View)this.mContainer);
        a.getSupportFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this);
        this.updateCrumbs();
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayoutTransition(new LayoutTransition());
        }
    }

    public void setMaxVisible(int visibleCrumbs) {
        if (visibleCrumbs < 1) {
            throw new IllegalArgumentException("visibleCrumbs must be greater than zero");
        }
        this.mMaxVisible = visibleCrumbs;
    }

    public void setOnBreadCrumbClickListener(OnBreadCrumbClickListener listener) {
        this.mOnBreadCrumbClickListener = listener;
    }

    public void setParentTitle(CharSequence title, CharSequence shortTitle, View.OnClickListener listener) {
        this.mParentEntry = this.createBackStackEntry(title, shortTitle);
        this.mParentClickListener = listener;
        this.updateCrumbs();
    }

    public void setTitle(CharSequence title, CharSequence shortTitle) {
        this.mTopEntry = this.createBackStackEntry(title, shortTitle);
        this.updateCrumbs();
    }

    void updateCrumbs() {
        FragmentManager fm = this.mActivity.getSupportFragmentManager();
        int numEntries = fm.getBackStackEntryCount();
        int numPreEntries = this.getPreEntryCount();
        int numViews = this.mContainer.getChildCount();
        for (int i = 0; i < numEntries + numPreEntries; ++i) {
            View v;
            Object tag;
            FragmentManager.BackStackEntry bse;
            FragmentManager.BackStackEntry backStackEntry = bse = i < numPreEntries ? this.getPreEntry(i) : fm.getBackStackEntryAt(i - numPreEntries);
            if (i < numViews && (tag = (v = this.mContainer.getChildAt(i)).getTag()) != bse) {
                for (int j = i; j < numViews; ++j) {
                    this.mContainer.removeViewAt(i);
                }
                numViews = i;
            }
            if (i < numViews) continue;
            View item = this.mInflater.inflate(R.layout.fragment_bread_crumb_item, (ViewGroup)this, false);
            TextView text = (TextView)item.findViewById(R.id.title);
            text.setText(bse.getBreadCrumbTitle());
            text.setTag((Object)bse);
            if (i == 0) {
                item.findViewById(R.id.left_icon).setVisibility(8);
            }
            this.mContainer.addView(item);
            text.setOnClickListener(this.mOnClickListener);
        }
        int viewI = numEntries + numPreEntries;
        for (numViews = this.mContainer.getChildCount(); numViews > viewI; --numViews) {
            this.mContainer.removeViewAt(numViews - 1);
        }
        for (int i = 0; i < numViews; ++i) {
            View child = this.mContainer.getChildAt(i);
            child.findViewById(R.id.title).setEnabled(i < numViews - 1);
            if (this.mMaxVisible <= 0) continue;
            child.setVisibility(i < numViews - this.mMaxVisible ? 8 : 0);
            View leftIcon = child.findViewById(R.id.left_icon);
            leftIcon.setVisibility(i > numViews - this.mMaxVisible && i != 0 ? 0 : 8);
        }
    }

    public static interface OnBreadCrumbClickListener {
        public boolean onBreadCrumbClick(FragmentManager.BackStackEntry var1, int var2);
    }
}

