/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import org.holoeverywhere.preference.DialogPreference;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.widget.NumberPicker;

public class NumberPickerPreference
extends DialogPreference {
    private final NumberPicker mNumberPicker;
    private NumberPicker.OnScrollListener mOnScrollListener;
    private NumberPicker.OnValueChangeListener mOnValueChangeListener;
    private int mValue = Integer.MIN_VALUE;
    private int mMinValue = Integer.MIN_VALUE;
    private int mMaxValue = Integer.MIN_VALUE;
    private boolean mWrapSelectorWheel = false;

    public NumberPickerPreference(Context context) {
        this(context, null);
    }

    public NumberPickerPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.numberPickerPreferenceStyle);
    }

    public NumberPickerPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NumberPickerPreference, defStyle, R.style.Holo_PreferenceDialog_NumberPickerPreference);
        int minValue = a.getInt(1, 1);
        int maxValue = a.getInt(0, 10);
        boolean wrapSelectorWheel = a.getBoolean(2, false);
        a.recycle();
        this.mNumberPicker = this.onCreateNumberPicker();
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
        this.setWrapSelectorWheel(wrapSelectorWheel);
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public NumberPicker getNumberPicker() {
        return this.mNumberPicker;
    }

    public NumberPicker.OnScrollListener getOnScrollListener() {
        return this.mOnScrollListener;
    }

    public NumberPicker.OnValueChangeListener getOnValueChangeListener() {
        return this.mOnValueChangeListener;
    }

    public int getValue() {
        return this.mValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        NumberPicker numberPicker = this.mNumberPicker;
        synchronized (numberPicker) {
            ViewParent oldParent;
            if (this.mOnValueChangeListener != null) {
                this.mNumberPicker.setOnValueChangedListener(this.mOnValueChangeListener);
            }
            if (this.mOnScrollListener != null) {
                this.mNumberPicker.setOnScrollListener(this.mOnScrollListener);
            }
            if ((oldParent = this.mNumberPicker.getParent()) != view) {
                if (oldParent != null) {
                    ((ViewGroup)oldParent).removeView((View)this.mNumberPicker);
                }
                ((ViewGroup)view).addView((View)this.mNumberPicker);
            }
        }
    }

    protected NumberPicker onCreateNumberPicker() {
        return new NumberPicker(this.getDialogContext(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDialogClosed(boolean positiveResult) {
        int value;
        super.onDialogClosed(positiveResult);
        NumberPicker numberPicker = this.mNumberPicker;
        synchronized (numberPicker) {
            this.mNumberPicker.setOnValueChangedListener(null);
            this.mNumberPicker.setOnScrollListener(null);
            value = this.mNumberPicker.getValue();
        }
        if (positiveResult && this.callChangeListener(value)) {
            this.setValue(value);
        }
    }

    protected Integer onGetDefaultValue(TypedArray a, int index) {
        return a.getInt(index, 0);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setValue(ss.mValue);
        this.setMinValue(ss.mMinValue);
        this.setMaxValue(ss.mMaxValue);
        this.setWrapSelectorWheel(ss.mWrapSelectorWheel);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.mValue = this.mValue;
        myState.mMinValue = this.mMinValue;
        myState.mMaxValue = this.mMaxValue;
        myState.mWrapSelectorWheel = this.mWrapSelectorWheel;
        return myState;
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        int def = defaultValue instanceof Integer ? (Integer)defaultValue : (defaultValue == null ? 0 : Integer.valueOf(defaultValue.toString()));
        this.setValue(restoreValue ? this.getPersistedInt(def) : def);
    }

    public void setMaxValue(int maxValue) {
        if (this.mMaxValue == maxValue) {
            return;
        }
        boolean wasBlocking = this.shouldDisableDependents();
        this.mMaxValue = maxValue;
        this.mNumberPicker.setMaxValue(maxValue);
        if (this.shouldDisableDependents() != wasBlocking) {
            this.notifyDependencyChange(!wasBlocking);
        }
    }

    public void setMinValue(int minValue) {
        if (this.mMinValue == minValue) {
            return;
        }
        boolean wasBlocking = this.shouldDisableDependents();
        this.mMinValue = minValue;
        this.mNumberPicker.setMinValue(minValue);
        if (this.shouldDisableDependents() != wasBlocking) {
            this.notifyDependencyChange(!wasBlocking);
        }
    }

    public void setOnScrollListener(NumberPicker.OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public void setOnValueChangeListener(NumberPicker.OnValueChangeListener onValueChangeListener) {
        this.mOnValueChangeListener = onValueChangeListener;
    }

    public void setValue(int value) {
        if (this.mValue == value) {
            return;
        }
        boolean wasBlocking = this.shouldDisableDependents();
        this.mValue = value;
        this.mNumberPicker.setValue(value);
        this.persistInt(value);
        if (this.shouldDisableDependents() != wasBlocking) {
            this.notifyDependencyChange(!wasBlocking);
        }
    }

    public void setWrapSelectorWheel(boolean wrapSelectorWheel) {
        if (this.mWrapSelectorWheel == wrapSelectorWheel) {
            return;
        }
        boolean wasBlocking = this.shouldDisableDependents();
        this.mWrapSelectorWheel = wrapSelectorWheel;
        this.mNumberPicker.setWrapSelectorWheel(wrapSelectorWheel);
        if (this.shouldDisableDependents() != wasBlocking) {
            this.notifyDependencyChange(!wasBlocking);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        protected int mValue;
        protected int mMinValue;
        protected int mMaxValue;
        protected boolean mWrapSelectorWheel;

        public SavedState(Parcel source) {
            super(source);
            this.mValue = source.readInt();
            this.mMinValue = source.readInt();
            this.mMaxValue = source.readInt();
            this.mWrapSelectorWheel = source.readInt() > 0;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mValue);
            dest.writeInt(this.mMinValue);
            dest.writeInt(this.mMaxValue);
            dest.writeInt(this.mWrapSelectorWheel ? 1 : 0);
        }
    }
}

