/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.holoeverywhere.internal.GenericInflater;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreferenceGroup
extends Preference
implements GenericInflater.Parent<Preference> {
    private boolean mAttachedToActivity = false;
    private int mCurrentPreferenceOrder = 0;
    private boolean mOrderingAsAdded = true;
    private List<Preference> mPreferenceList;

    public PreferenceGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PreferenceGroup(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        this.mPreferenceList = new ArrayList<Preference>();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PreferenceGroup, defStyle, 0);
        this.mOrderingAsAdded = a.getBoolean(0, this.mOrderingAsAdded);
        a.recycle();
    }

    @Override
    public void addItemFromInflater(Preference preference) {
        this.addPreference(preference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPreference(Preference preference) {
        int insertionIndex;
        if (this.mPreferenceList.contains(preference)) {
            return true;
        }
        if (preference.getOrder() == Integer.MAX_VALUE) {
            if (this.mOrderingAsAdded) {
                preference.setOrder(this.mCurrentPreferenceOrder++);
            }
            if (preference instanceof PreferenceGroup) {
                ((PreferenceGroup)preference).setOrderingAsAdded(this.mOrderingAsAdded);
            }
        }
        if ((insertionIndex = Collections.binarySearch(this.mPreferenceList, preference)) < 0) {
            insertionIndex = insertionIndex * -1 - 1;
        }
        if (!this.onPrepareAddPreference(preference)) {
            return false;
        }
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            this.mPreferenceList.add(insertionIndex, preference);
        }
        preference.onAttachedToHierarchy(this.getPreferenceManager());
        if (this.mAttachedToActivity) {
            preference.onAttachedToActivity();
        }
        this.notifyHierarchyChanged();
        return true;
    }

    @Override
    protected void dispatchRestoreInstanceState(Bundle container) {
        super.dispatchRestoreInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchRestoreInstanceState(container);
        }
    }

    @Override
    protected void dispatchSaveInstanceState(Bundle container) {
        super.dispatchSaveInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchSaveInstanceState(container);
        }
    }

    public Preference findPreference(CharSequence key) {
        if (TextUtils.equals((CharSequence)this.getKey(), (CharSequence)key)) {
            return this;
        }
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference returnedPreference;
            Preference preference = this.getPreference(i);
            String curKey = preference.getKey();
            if (curKey != null && curKey.equals(key)) {
                return preference;
            }
            if (!(preference instanceof PreferenceGroup) || (returnedPreference = ((PreferenceGroup)preference).findPreference(key)) == null) continue;
            return returnedPreference;
        }
        return null;
    }

    public Preference findPreference(int id2) {
        if (this.getResId() == id2) {
            return this;
        }
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference returnedPreference;
            Preference preference = this.getPreference(i);
            int curId = preference.getResId();
            if (curId > 0 && curId == id2) {
                return preference;
            }
            if (!(preference instanceof PreferenceGroup) || (returnedPreference = ((PreferenceGroup)preference).findPreference(id2)) == null) continue;
            return returnedPreference;
        }
        return null;
    }

    public Preference getPreference(int index) {
        return this.mPreferenceList.get(index);
    }

    public int getPreferenceCount() {
        return this.mPreferenceList.size();
    }

    protected boolean isOnSameScreenAsChildren() {
        return true;
    }

    public boolean isOrderingAsAdded() {
        return this.mOrderingAsAdded;
    }

    @Override
    protected void onAttachedToActivity() {
        super.onAttachedToActivity();
        this.mAttachedToActivity = true;
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onAttachedToActivity();
        }
    }

    protected boolean onPrepareAddPreference(Preference preference) {
        if (!super.isEnabled()) {
            preference.setEnabled(false);
        }
        return true;
    }

    @Override
    protected void onPrepareForRemoval() {
        super.onPrepareForRemoval();
        this.mAttachedToActivity = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            List<Preference> preferenceList = this.mPreferenceList;
            for (int i = preferenceList.size() - 1; i >= 0; --i) {
                this.removePreferenceInt(preferenceList.get(0));
            }
        }
        this.notifyHierarchyChanged();
    }

    public boolean removePreference(Preference preference) {
        boolean returnValue = this.removePreferenceInt(preference);
        this.notifyHierarchyChanged();
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePreferenceInt(Preference preference) {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            preference.onPrepareForRemoval();
            return this.mPreferenceList.remove(preference);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).setEnabled(enabled);
        }
    }

    public void setOrderingAsAdded(boolean orderingAsAdded) {
        this.mOrderingAsAdded = orderingAsAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortPreferences() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            Collections.sort(this.mPreferenceList);
        }
    }
}

