/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.TypedValue;
import java.io.IOException;
import org.holoeverywhere.internal.GenericInflater;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceGroup;
import org.holoeverywhere.preference.PreferenceInit;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.util.XmlUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceInflater
extends GenericInflater<Preference, PreferenceGroup> {
    private static final String EXTRA_TAG_NAME = "extra";
    private static final String INTENT_TAG_NAME = "intent";
    private PreferenceManager mPreferenceManager;

    /*
     * Enabled aggressive block sorting
     */
    private static void parseBundleExtra(Resources resources, String tagName, AttributeSet attrs, Bundle outBundle) throws XmlPullParserException {
        TypedArray sa = resources.obtainAttributes(attrs, R.styleable.Extra);
        String name = sa.getString(0);
        if (name == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an holo:name attribute at " + attrs.getPositionDescription());
        }
        TypedValue v = sa.peekValue(1);
        if (v == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an holo:value attribute at " + attrs.getPositionDescription());
        }
        if (v.type == 3) {
            CharSequence cs = v.coerceToString();
            outBundle.putCharSequence(name, cs);
        } else if (v.type == 18) {
            outBundle.putBoolean(name, v.data != 0);
        } else if (v.type >= 16 && v.type <= 31) {
            outBundle.putInt(name, v.data);
        } else {
            if (v.type != 4) {
                sa.recycle();
                throw new XmlPullParserException("<" + tagName + "> only supports string, integer, float, color, and boolean at " + attrs.getPositionDescription());
            }
            outBundle.putFloat(name, v.getFloat());
        }
        sa.recycle();
    }

    private static Intent parseIntent(Resources resources, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        Intent intent = new Intent();
        TypedArray sa = resources.obtainAttributes(attrs, R.styleable.Intent);
        intent.setAction(sa.getString(0));
        String data = sa.getString(1);
        String mimeType = sa.getString(2);
        intent.setDataAndType(data != null ? Uri.parse((String)data) : null, mimeType);
        String packageName = sa.getString(4);
        String className = sa.getString(3);
        if (packageName != null && className != null) {
            intent.setComponent(new ComponentName(packageName, className));
        }
        sa.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("category")) {
                sa = resources.obtainAttributes(attrs, R.styleable.IntentCategory);
                String cat = sa.getString(0);
                sa.recycle();
                if (cat != null) {
                    intent.addCategory(cat);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (nodeName.equals(EXTRA_TAG_NAME)) {
                Bundle bundle = new Bundle();
                PreferenceInflater.parseBundleExtra(resources, EXTRA_TAG_NAME, attrs, bundle);
                intent.putExtras(bundle);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return intent;
    }

    public PreferenceInflater(Context context, PreferenceManager preferenceManager) {
        super(PreferenceInit.context(context));
        this.init(preferenceManager);
    }

    public PreferenceInflater(PreferenceInflater original, PreferenceManager preferenceManager, Context newContext) {
        super(original, PreferenceInit.context(newContext));
        this.init(preferenceManager);
    }

    public PreferenceInflater cloneInContext(Context newContext) {
        return new PreferenceInflater(this, this.mPreferenceManager, newContext);
    }

    private void init(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.registerPackage(PreferenceInit.PACKAGE);
    }

    @Override
    protected boolean onCreateCustomFromTag(XmlPullParser parser, Preference parentPreference, AttributeSet attrs) throws XmlPullParserException {
        String tag = parser.getName();
        if (tag.equals(INTENT_TAG_NAME)) {
            Intent intent = null;
            try {
                intent = PreferenceInflater.parseIntent(this.getContext().getResources(), parser, attrs);
            }
            catch (IOException e) {
                XmlPullParserException ex = new XmlPullParserException("Error parsing preference");
                ex.initCause((Throwable)e);
                throw ex;
            }
            if (intent != null) {
                parentPreference.setIntent(intent);
            }
            return true;
        }
        if (tag.equals(EXTRA_TAG_NAME)) {
            PreferenceInflater.parseBundleExtra(this.getContext().getResources(), EXTRA_TAG_NAME, attrs, parentPreference.getExtras());
            try {
                XmlUtils.skipCurrentTag(parser);
            }
            catch (IOException e) {
                XmlPullParserException ex = new XmlPullParserException("Error parsing preference");
                ex.initCause((Throwable)e);
                throw ex;
            }
            return true;
        }
        return false;
    }

    @Override
    protected PreferenceGroup onMergeRoots(PreferenceGroup givenRoot, boolean attachToGivenRoot, PreferenceGroup xmlRoot) {
        if (givenRoot == null) {
            xmlRoot.onAttachedToHierarchy(this.mPreferenceManager);
            return xmlRoot;
        }
        return givenRoot;
    }
}

