/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.ThemeManager;
import org.holoeverywhere.addon.IAddonThemes;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.preference.FragmentBreadCrumbs;
import org.holoeverywhere.preference.PreferenceFrameLayout;
import org.holoeverywhere.preference.R;

public class PreferenceInit {
    public static final String PACKAGE;
    private static final IAddonThemes.ThemeResolver sThemeResolver;
    private static final IAddonThemes sThemes;
    public static final int THEME_FLAG;

    public static Context context(Context context) {
        return sThemes.context(context, ThemeManager.DARK, sThemeResolver);
    }

    public static void init() {
    }

    public static void map(int theme) {
        PreferenceInit.map(theme, theme, theme);
    }

    public static void map(int darkTheme, int lightTheme) {
        PreferenceInit.map(darkTheme, lightTheme, lightTheme);
    }

    public static void map(int darkTheme, int lightTheme, int mixedTheme) {
        sThemes.map(darkTheme, lightTheme, mixedTheme);
    }

    public static Context unwrap(Context context) {
        return sThemes.unwrap(context);
    }

    private PreferenceInit() {
    }

    static {
        sThemeResolver = new IAddonThemes.ThemeResolver(){

            public int resolveThemeForContext(Context context, int invalidTheme) {
                int theme;
                int mod = 0;
                TypedValue outValue = new TypedValue();
                TypedArray a = context.obtainStyledAttributes(new int[]{R.attr.preferenceTheme});
                a.getValue(0, outValue);
                a.recycle();
                switch (outValue.type) {
                    case 1: {
                        theme = outValue.resourceId;
                        if (new ContextThemeWrapper(context, theme).obtainStyledAttributes(new int[]{R.attr.holoTheme}).getInt(0, 0) != 4) break;
                        return theme;
                    }
                    case 16: 
                    case 17: {
                        mod = outValue.resourceId;
                    }
                }
                theme = THEME_FLAG;
                if (context instanceof Activity) {
                    if (mod == 0 || mod == ThemeManager.getDefaultTheme()) {
                        mod = ThemeManager.getThemeType(context);
                        if (mod == THEME_FLAG) {
                            theme = mod;
                            mod = 0;
                        } else if (mod == 0 && (mod = ThemeManager.getDefaultTheme() & ThemeManager.COLOR_SCHEME_MASK) == 0) {
                            mod = ThemeManager.DARK;
                        }
                    }
                    if (mod > 0) {
                        theme |= mod & ThemeManager.COLOR_SCHEME_MASK;
                    }
                } else {
                    theme |= ThemeManager.getDefaultTheme() & ThemeManager.COLOR_SCHEME_MASK;
                }
                if ((theme = ThemeManager.getThemeResource(theme, false)) == ThemeManager.getDefaultTheme() || theme == 0) {
                    theme = sThemes.getDarkTheme();
                }
                return theme;
            }
        };
        PACKAGE = PreferenceInit.class.getPackage().getName();
        sThemes = new IAddonThemes();
        THEME_FLAG = sThemes.getThemeFlag();
        LayoutInflater.register(PreferenceFrameLayout.class);
        LayoutInflater.register(FragmentBreadCrumbs.class);
        PreferenceInit.map(R.style.Holo_Internal_Preference, R.style.Holo_Internal_Preference_Light);
    }
}

