/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.actionbarsherlock.internal.view.menu.MenuItemWrapper;
import com.actionbarsherlock.internal.widget.ActionBarView;
import com.actionbarsherlock.view.Window;
import java.lang.reflect.Method;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.app.Dialog;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceGroup;
import org.holoeverywhere.preference.PreferenceGroupAdapter;
import org.holoeverywhere.preference.PreferenceInit;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.widget.ListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreferenceScreen
extends PreferenceGroup
implements AdapterView.OnItemClickListener,
DialogInterface.OnDismissListener {
    private PreferenceDialog mDialog;
    private ListView mListView;
    private ListAdapter mRootAdapter;

    public PreferenceScreen(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.preferenceScreenStyle);
    }

    public void bind(ListView listView) {
        listView.setOnItemClickListener(this);
        listView.setAdapter(this.getRootAdapter());
        this.onAttachedToActivity();
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public ListAdapter getRootAdapter() {
        if (this.mRootAdapter == null) {
            this.mRootAdapter = this.onCreateRootAdapter();
        }
        return this.mRootAdapter;
    }

    protected int getThemeResId(Context context) {
        try {
            int t;
            if (context instanceof Activity && (t = ((Activity)context).getLastThemeResourceId()) > 0) {
                return t;
            }
            Method method = Context.class.getDeclaredMethod("getThemeResId", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)context, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.style.Holo_Theme_NoActionBar;
        }
    }

    @Override
    protected boolean isOnSameScreenAsChildren() {
        return false;
    }

    @Override
    protected void onClick() {
        if (this.getIntent() != null || this.getFragment() != null || this.getPreferenceCount() == 0) {
            return;
        }
        this.showDialog(null);
    }

    protected ListAdapter onCreateRootAdapter() {
        return new PreferenceGroupAdapter(this);
    }

    public void onDismiss(DialogInterface dialog) {
        this.mDialog = null;
        this.getPreferenceManager().removePreferencesScreen(dialog);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object item;
        if (parent instanceof ListView) {
            position -= ((ListView)parent).getHeaderViewsCount();
        }
        if (!((item = this.getRootAdapter().getItem(position)) instanceof Preference)) {
            return;
        }
        Preference preference = (Preference)item;
        preference.performClick(this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        SavedState myState = new SavedState(super.onSaveInstanceState());
        if (this.mDialog != null) {
            myState.isShowing = true;
            myState.dialogBundle = this.mDialog.onSaveInstanceState();
        } else {
            myState.isShowing = false;
        }
        return myState;
    }

    @SuppressLint(value={"NewApi"})
    private void showDialog(Bundle state) {
        Context preferenceContext = this.getContext();
        Context context = PreferenceInit.unwrap(this.getContext());
        int contextTheme = this.getThemeResId(context);
        if (this.mListView != null) {
            this.mListView.setAdapter((ListAdapter)null);
        }
        View childPrefScreen = LayoutInflater.inflate(preferenceContext, R.layout.preference_list_fragment);
        this.mListView = (ListView)childPrefScreen.findViewById(16908298);
        this.bind(this.mListView);
        CharSequence title = this.getTitle();
        boolean titleEmpty = TextUtils.isEmpty((CharSequence)title);
        PreferenceDialog dialog = this.mDialog = new PreferenceDialog(context, contextTheme);
        if (titleEmpty) {
            dialog.requestWindowFeature(1);
        } else {
            if (Build.VERSION.SDK_INT >= 11) {
                dialog.requestWindowFeature(8);
            }
            ((Dialog)dialog).setContentView(childPrefScreen);
            dialog.setTitle(title);
        }
        dialog.setOnDismissListener(this);
        if (state != null) {
            dialog.onRestoreInstanceState(state);
        }
        this.getPreferenceManager().addPreferencesScreen((DialogInterface)dialog);
        dialog.show();
    }

    public static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        Bundle dialogBundle;
        boolean isShowing;

        public SavedState(Parcel source) {
            super(source);
            this.isShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }
    }

    private final class PreferenceDialog
    extends Dialog
    implements Window.Callback {
        public PreferenceDialog(Context context, int theme) {
            super(context, theme);
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.prepareActionBar();
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.prepareActionBar();
        }

        public boolean onMenuItemSelected(int featureId, MenuItem item) {
            return this.onMenuItemSelected(featureId, new MenuItemWrapper(item));
        }

        public boolean onMenuItemSelected(int featureId, com.actionbarsherlock.view.MenuItem item) {
            if (featureId == 0 && item.getItemId() == 16908332 && PreferenceScreen.this.mDialog != null) {
                PreferenceScreen.this.mDialog.dismiss();
                return true;
            }
            return false;
        }

        private void prepareActionBar() {
            ActionBarView actionBarView;
            if (Build.VERSION.SDK_INT < 11 && (actionBarView = (ActionBarView)this.findViewById(R.id.abs__action_bar)) != null) {
                actionBarView.setWindowCallback(PreferenceScreen.this.mDialog);
            }
        }

        public void setContentView(View view) {
            if (Build.VERSION.SDK_INT >= 11) {
                super.setContentView(view);
            } else {
                FrameLayout content = (FrameLayout)this.findViewById(R.id.abs__content);
                if (content == null) {
                    View container = this.getLayoutInflater().inflate(R.layout.abs__screen_action_bar);
                    content = (FrameLayout)container.findViewById(R.id.abs__content);
                    super.setContentView(container);
                }
                content.removeAllViews();
                content.addView(view);
            }
        }

        public void setTitle(CharSequence title) {
            super.setTitle(title);
            if (Build.VERSION.SDK_INT < 11) {
                ((ActionBarView)this.findViewById(R.id.abs__action_bar)).setTitle(title);
            }
        }

        public void setTitle(int titleId) {
            this.setTitle(this.getContext().getText(titleId));
        }
    }
}

