/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import org.holoeverywhere.preference.DialogPreference;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.preference._RingtonePickerDialog;

public class RingtonePreference
extends DialogPreference
implements _RingtonePickerDialog.RingtonePickerListener {
    private Uri mLastUri;
    private int mRingtoneType;
    private boolean mShowDefault;
    private boolean mShowSilent;

    public RingtonePreference(Context context) {
        this(context, null);
    }

    public RingtonePreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.ringtonePreferenceStyle);
    }

    public RingtonePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RingtonePreference, defStyle, 0);
        this.mRingtoneType = a.getInt(0, 1);
        this.mShowDefault = a.getBoolean(1, true);
        this.mShowSilent = a.getBoolean(2, true);
        a.recycle();
    }

    public int getRingtoneType() {
        return this.mRingtoneType;
    }

    public boolean getShowDefault() {
        return this.mShowDefault;
    }

    public boolean getShowSilent() {
        return this.mShowSilent;
    }

    protected Dialog onCreateDialog(Context context) {
        Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
        this.onPrepareRingtonePickerIntent(intent);
        return new _RingtonePickerDialog(this.getContext(), intent, this).makeDialog();
    }

    protected void onDialogClosed(boolean positiveResult) {
        String uri;
        String string2 = uri = this.mLastUri == null ? "" : this.mLastUri.toString();
        if (positiveResult && this.callChangeListener(uri)) {
            this.persistString(uri);
        }
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onPrepareRingtonePickerIntent(Intent ringtonePickerIntent) {
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.EXISTING_URI", (Parcelable)this.onRestoreRingtone());
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", this.mShowDefault);
        if (this.mShowDefault) {
            ringtonePickerIntent.putExtra("android.intent.extra.ringtone.DEFAULT_URI", (Parcelable)RingtoneManager.getDefaultUri((int)this.getRingtoneType()));
        }
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", this.mShowSilent);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TYPE", this.mRingtoneType);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TITLE", this.getTitle());
    }

    protected Uri onRestoreRingtone() {
        String uriString = this.getPersistedString(null);
        return !TextUtils.isEmpty((CharSequence)uriString) ? Uri.parse((String)uriString) : null;
    }

    public void onRingtonePickerCanceled() {
        this.onDialogClosed(false);
    }

    public void onRingtonePickerChanged(Uri uri) {
        this.mLastUri = uri;
        this.onDialogClosed(true);
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValueObj) {
        String defaultValue = (String)defaultValueObj;
        if (restorePersistedValue) {
            defaultValue = this.getPersistedString(defaultValue);
        }
        if (!TextUtils.isEmpty((CharSequence)defaultValue)) {
            this.mLastUri = Uri.parse((String)defaultValue);
            this.onDialogClosed(true);
        }
    }

    public void setRingtoneType(int type) {
        this.mRingtoneType = type;
    }

    public void setShowDefault(boolean showDefault) {
        this.mShowDefault = showDefault;
    }

    public void setShowSilent(boolean showSilent) {
        this.mShowSilent = showSilent;
    }
}

