/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.preference.DialogPreference;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.widget.SeekBar;

public class SeekBarDialogPreference
extends DialogPreference {
    private final SeekBar mSeekBar;
    private int mValue = Integer.MIN_VALUE;
    private int mMaxValue = Integer.MIN_VALUE;

    public SeekBarDialogPreference(Context context) {
        this(context, null);
    }

    public SeekBarDialogPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.seekBarDialogPreferenceStyle);
    }

    public SeekBarDialogPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBarDialogPreference, defStyle, R.style.Holo_PreferenceDialog_SeekBarDialogPreference);
        int maxValue = a.getInt(0, 100);
        a.recycle();
        this.mSeekBar = this.onCreateSeekBar();
        this.setMaxValue(maxValue);
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public SeekBar getSeekBar() {
        return this.mSeekBar;
    }

    public int getValue() {
        return this.mValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        SeekBar seekBar = this.mSeekBar;
        synchronized (seekBar) {
            ViewParent oldParent = this.mSeekBar.getParent();
            if (oldParent != view) {
                if (oldParent != null) {
                    ((ViewGroup)oldParent).removeView((View)this.mSeekBar);
                }
                ((ViewGroup)view).addView((View)this.mSeekBar);
            }
        }
    }

    protected SeekBar onCreateSeekBar() {
        return (SeekBar)LayoutInflater.inflate(this.getContext(), R.layout.preference_dialog_seekbar_widget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDialogClosed(boolean positiveResult) {
        int value;
        super.onDialogClosed(positiveResult);
        SeekBar seekBar = this.mSeekBar;
        synchronized (seekBar) {
            value = this.mSeekBar.getProgress();
        }
        if (positiveResult && this.callChangeListener(value)) {
            this.setValue(value);
        }
    }

    protected Integer onGetDefaultValue(TypedArray a, int index) {
        return a.getInt(index, 0);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setValue(ss.mValue);
        this.setMaxValue(ss.mMaxValue);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.mValue = this.mValue;
        myState.mMaxValue = this.mMaxValue;
        return myState;
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        int def = defaultValue instanceof Integer ? (Integer)defaultValue : (defaultValue == null ? 0 : Integer.parseInt(defaultValue.toString()));
        this.setValue(restoreValue ? this.getPersistedInt(def) : def);
    }

    public void setMaxValue(int maxValue) {
        if (this.mMaxValue == maxValue) {
            return;
        }
        boolean wasBlocking = this.shouldDisableDependents();
        this.mMaxValue = maxValue;
        this.mSeekBar.setMax(maxValue);
        if (this.shouldDisableDependents() != wasBlocking) {
            this.notifyDependencyChange(!wasBlocking);
        }
    }

    public void setValue(int value) {
        if (this.mValue == value) {
            return;
        }
        boolean wasBlocking = this.shouldDisableDependents();
        this.mValue = value;
        this.mSeekBar.setProgress(value);
        this.persistInt(value);
        if (this.shouldDisableDependents() != wasBlocking) {
            this.notifyDependencyChange(!wasBlocking);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        protected int mValue;
        protected int mMaxValue;

        public SavedState(Parcel source) {
            super(source);
            this.mValue = source.readInt();
            this.mMaxValue = source.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mValue);
            dest.writeInt(this.mMaxValue);
        }
    }
}

