/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import java.util.Calendar;
import org.holoeverywhere.app.TimePickerDialog;
import org.holoeverywhere.preference.DialogPreference;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.widget.TimePicker;

public class TimePreference
extends DialogPreference {
    private boolean m24HourView;
    private final TimePickerDialog.OnTimeSetListener mCallback = new TimePickerDialog.OnTimeSetListener(){

        public void onTimeSet(TimePicker timePicker, int hour, int minute) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(0L);
            calendar.set(11, TimePreference.this.mHour = hour);
            calendar.set(12, TimePreference.this.mMinute = minute);
            TimePreference.this.onTimeSet(timePicker, calendar.getTimeInMillis(), hour, minute);
            TimePreference.this.updateDialogState();
        }
    };
    private long mDefaultTime;
    private boolean mDefaultTimeSetted = false;
    private int mHour;
    private int mMinute;
    private OnTimeSetListener mOnTimeSetListener;

    public TimePreference(Context context) {
        this(context, null);
    }

    public TimePreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.timePreferenceStyle);
    }

    public TimePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimePreference, defStyle, R.style.Holo_PreferenceTime);
        switch (a.getInt(0, 0)) {
            default: {
                this.m24HourView = DateFormat.is24HourFormat((Context)context);
                break;
            }
            case 1: {
                this.m24HourView = true;
                break;
            }
            case -1: {
                this.m24HourView = false;
            }
        }
        a.recycle();
    }

    public long getDefaultTime() {
        if (!this.mDefaultTimeSetted) {
            return System.currentTimeMillis();
        }
        return this.mDefaultTime;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public OnTimeSetListener getOnTimeSetListener() {
        return this.mOnTimeSetListener;
    }

    protected boolean is24HourView() {
        return this.m24HourView;
    }

    protected Dialog onCreateDialog(Context context) {
        return new TimePickerDialog(context, this.mCallback, this.mHour, this.mMinute, this.m24HourView);
    }

    protected String onGetDefaultValue(TypedArray a, int index) {
        String value = a.getString(index);
        if (value == null || value.length() == 0) {
            value = String.valueOf(this.getDefaultTime());
        }
        return value;
    }

    protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue) {
        long time;
        if (restorePersistedValue) {
            defaultValue = this.getPersistedLong(this.getDefaultTime());
        }
        try {
            time = defaultValue instanceof Long ? (Long)defaultValue : Long.parseLong(String.valueOf(defaultValue));
        }
        catch (Exception e) {
            time = this.getDefaultTime();
        }
        this.setTime(time);
    }

    public void onTimeSet(TimePicker timePicker, long time, int hour, int minute) {
        if (this.mOnTimeSetListener == null || this.mOnTimeSetListener.onTimeSet(this, time, hour, minute)) {
            this.persistLong(time);
        }
    }

    public void resetDefaultTime() {
        this.mDefaultTimeSetted = false;
    }

    public void setDefaultTime(long defaultTime) {
        this.mDefaultTime = defaultTime;
        this.mDefaultTimeSetted = true;
    }

    public void setHour(int hour) {
        this.mHour = hour;
        this.updateDialogState();
    }

    public void setIs24HourView(boolean is24HourView) {
        this.m24HourView = is24HourView;
    }

    public void setMinute(int minute) {
        this.mMinute = minute;
        this.updateDialogState();
    }

    public void setOnTimeSetListener(OnTimeSetListener onTimeSetListener) {
        this.mOnTimeSetListener = onTimeSetListener;
    }

    private void setTime(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        this.setHour(calendar.get(11));
        this.setMinute(calendar.get(12));
    }

    protected void updateDialogState() {
        TimePickerDialog dialog = (TimePickerDialog)this.getDialog();
        if (dialog != null) {
            dialog.updateTime(this.mHour, this.mMinute);
        }
    }

    public static interface OnTimeSetListener {
        public boolean onTimeSet(TimePreference var1, long var2, int var4, int var5);
    }
}

