/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.TextView;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.R;

public abstract class TwoStatePreference
extends Preference {
    boolean mChecked;
    private boolean mDisableDependentsState;
    private boolean mSendClickAccessibilityEvent;
    private CharSequence mSummaryOff;
    private CharSequence mSummaryOn;

    public TwoStatePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TwoStatePreference, defStyle, R.style.Holo_PreferenceTwoState);
        this.mSummaryOn = a.getText(2);
        this.mSummaryOff = a.getText(1);
        this.mDisableDependentsState = a.getBoolean(0, false);
        a.recycle();
    }

    public boolean getDisableDependentsState() {
        return this.mDisableDependentsState;
    }

    public CharSequence getSummaryOff() {
        return this.mSummaryOff;
    }

    public CharSequence getSummaryOn() {
        return this.mSummaryOn;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    protected void onClick() {
        super.onClick();
        boolean newValue = !this.isChecked();
        this.mSendClickAccessibilityEvent = true;
        if (!this.callChangeListener(newValue)) {
            return;
        }
        this.setChecked(newValue);
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getBoolean(index, false);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.setChecked(myState.checked);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.checked = this.isChecked();
        return myState;
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        this.setChecked(restoreValue ? this.getPersistedBoolean(this.mChecked) : ((Boolean)defaultValue).booleanValue());
    }

    @SuppressLint(value={"NewApi"})
    void sendAccessibilityEvent(View view) {
        try {
            AccessibilityManager accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
            if (this.mSendClickAccessibilityEvent && accessibilityManager.isEnabled()) {
                AccessibilityEvent event = AccessibilityEvent.obtain();
                event.setEventType(1);
                if (Build.VERSION.SDK_INT >= 14) {
                    view.onInitializeAccessibilityEvent(event);
                }
                view.dispatchPopulateAccessibilityEvent(event);
                accessibilityManager.sendAccessibilityEvent(event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mSendClickAccessibilityEvent = false;
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.persistBoolean(checked);
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public void setDisableDependentsState(boolean disableDependentsState) {
        this.mDisableDependentsState = disableDependentsState;
    }

    public void setSummaryOff(CharSequence summary) {
        this.mSummaryOff = summary;
        if (!this.isChecked()) {
            this.notifyChanged();
        }
    }

    public void setSummaryOff(int summaryResId) {
        this.setSummaryOff(this.getContext().getString(summaryResId));
    }

    public void setSummaryOn(CharSequence summary) {
        this.mSummaryOn = summary;
        if (this.isChecked()) {
            this.notifyChanged();
        }
    }

    public void setSummaryOn(int summaryResId) {
        this.setSummaryOn(this.getContext().getString(summaryResId));
    }

    public boolean shouldDisableDependents() {
        return this.mDisableDependentsState ? this.mChecked : !this.mChecked || super.shouldDisableDependents();
    }

    void syncSummaryView(View view) {
        TextView summaryView = (TextView)view.findViewById(R.id.summary);
        if (summaryView != null) {
            int newVisibility;
            CharSequence summary;
            boolean useDefaultSummary = true;
            if (this.mChecked && this.mSummaryOn != null) {
                summaryView.setText(this.mSummaryOn);
                useDefaultSummary = false;
            } else if (!this.mChecked && this.mSummaryOff != null) {
                summaryView.setText(this.mSummaryOff);
                useDefaultSummary = false;
            }
            if (useDefaultSummary && (summary = this.getSummary()) != null) {
                summaryView.setText(summary);
                useDefaultSummary = false;
            }
            int n = newVisibility = useDefaultSummary ? 8 : 0;
            if (newVisibility != summaryView.getVisibility()) {
                summaryView.setVisibility(newVisibility);
            }
        }
    }

    static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean checked;

        public SavedState(Parcel source) {
            super(source);
            this.checked = source.readInt() == 1;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.checked ? 1 : 0);
        }
    }
}

