/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.preference;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import org.holoeverywhere.preference.Preference;
import org.holoeverywhere.preference.PreferenceManager;
import org.holoeverywhere.preference.R;
import org.holoeverywhere.preference.SeekBarDialogPreference;
import org.holoeverywhere.widget.SeekBar;

public class VolumePreference
extends SeekBarDialogPreference
implements PreferenceManager.OnActivityStopListener,
View.OnKeyListener {
    private SeekBarVolumizer mSeekBarVolumizer;
    private int mStreamType;

    public VolumePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VolumePreference, 0, 0);
        this.mStreamType = a.getInt(0, 0);
        a.recycle();
    }

    private void cleanup() {
        this.getPreferenceManager().unregisterOnActivityStopListener(this);
        if (this.mSeekBarVolumizer != null) {
            Dialog dialog = this.getDialog();
            if (dialog != null && dialog.isShowing()) {
                View view = dialog.getWindow().getDecorView().findViewById(R.id.seekbar);
                if (view != null) {
                    view.setOnKeyListener(null);
                }
                this.mSeekBarVolumizer.revertVolume();
            }
            this.mSeekBarVolumizer.stop();
            this.mSeekBarVolumizer = null;
        }
    }

    public void onActivityStop() {
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.stopSample();
        }
    }

    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        this.mSeekBarVolumizer = new SeekBarVolumizer(this.getContext(), this.getSeekBar(), this.mStreamType);
        this.getPreferenceManager().registerOnActivityStopListener(this);
        view.setOnKeyListener((View.OnKeyListener)this);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
    }

    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (!positiveResult && this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.revertVolume();
        }
        this.cleanup();
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (this.mSeekBarVolumizer == null) {
            return true;
        }
        boolean isdown = event.getAction() == 0;
        switch (keyCode) {
            case 25: {
                if (isdown) {
                    this.mSeekBarVolumizer.changeVolumeBy(-1);
                }
                return true;
            }
            case 24: {
                if (isdown) {
                    this.mSeekBarVolumizer.changeVolumeBy(1);
                }
                return true;
            }
            case 164: {
                if (isdown) {
                    this.mSeekBarVolumizer.muteVolume();
                }
                return true;
            }
        }
        return false;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.onRestoreInstanceState(myState.getVolumeStore());
        }
    }

    protected void onSampleStarting(SeekBarVolumizer volumizer) {
        if (this.mSeekBarVolumizer != null && volumizer != this.mSeekBarVolumizer) {
            this.mSeekBarVolumizer.stopSample();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.onSaveInstanceState(myState.getVolumeStore());
        }
        return myState;
    }

    public void setStreamType(int streamType) {
        this.mStreamType = streamType;
    }

    public static class VolumeStore {
        public int originalVolume = -1;
        public int volume = -1;
    }

    public class SeekBarVolumizer
    implements SeekBar.OnSeekBarChangeListener,
    Runnable {
        private AudioManager mAudioManager;
        private Context mContext;
        private Handler mHandler = new Handler();
        private int mLastProgress = -1;
        private int mOriginalStreamVolume;
        private Ringtone mRingtone;
        private SeekBar mSeekBar;
        private int mStreamType;
        private int mVolumeBeforeMute = -1;
        private ContentObserver mVolumeObserver = new ContentObserver(this.mHandler){

            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                if (SeekBarVolumizer.this.mSeekBar != null && SeekBarVolumizer.this.mAudioManager != null) {
                    int volume = SeekBarVolumizer.this.mAudioManager.getStreamVolume(SeekBarVolumizer.this.mStreamType);
                    SeekBarVolumizer.this.mSeekBar.setProgress(volume);
                }
            }
        };

        public SeekBarVolumizer(Context context, SeekBar seekBar, int streamType) {
            this(context, seekBar, streamType, null);
        }

        public SeekBarVolumizer(Context context, SeekBar seekBar, int streamType, Uri defaultUri) {
            this.mContext = context;
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
            this.mStreamType = streamType;
            this.mSeekBar = seekBar;
            this.initSeekBar(seekBar, defaultUri);
        }

        public void changeVolumeBy(int amount) {
            this.mSeekBar.incrementProgressBy(amount);
            if (!this.isSamplePlaying()) {
                this.startSample();
            }
            this.postSetVolume(this.mSeekBar.getProgress());
            this.mVolumeBeforeMute = -1;
        }

        public SeekBar getSeekBar() {
            return this.mSeekBar;
        }

        @SuppressLint(value={"NewApi"})
        private void initSeekBar(SeekBar seekBar, Uri defaultUri) {
            VolumePreference.this.setMaxValue(this.mAudioManager.getStreamMaxVolume(this.mStreamType));
            this.mOriginalStreamVolume = this.mAudioManager.getStreamVolume(this.mStreamType);
            VolumePreference.this.setValue(this.mOriginalStreamVolume);
            seekBar.setOnSeekBarChangeListener(this);
            if (defaultUri == null) {
                defaultUri = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : (Build.VERSION.SDK_INT >= 5 ? Settings.System.DEFAULT_ALARM_ALERT_URI : Settings.System.DEFAULT_RINGTONE_URI));
            }
            this.mRingtone = RingtoneManager.getRingtone((Context)this.mContext, (Uri)defaultUri);
            if (this.mRingtone != null) {
                this.mRingtone.setStreamType(this.mStreamType);
            }
        }

        public boolean isSamplePlaying() {
            return this.mRingtone != null && this.mRingtone.isPlaying();
        }

        public void muteVolume() {
            if (this.mVolumeBeforeMute != -1) {
                this.mSeekBar.setProgress(this.mVolumeBeforeMute);
                this.startSample();
                this.postSetVolume(this.mVolumeBeforeMute);
                this.mVolumeBeforeMute = -1;
            } else {
                this.mVolumeBeforeMute = this.mSeekBar.getProgress();
                this.mSeekBar.setProgress(0);
                this.stopSample();
                this.postSetVolume(0);
            }
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
            if (!fromTouch) {
                return;
            }
            this.postSetVolume(progress);
        }

        public void onRestoreInstanceState(VolumeStore volumeStore) {
            if (volumeStore.volume != -1) {
                this.mOriginalStreamVolume = volumeStore.originalVolume;
                this.mLastProgress = volumeStore.volume;
                this.postSetVolume(this.mLastProgress);
            }
        }

        public void onSaveInstanceState(VolumeStore volumeStore) {
            if (this.mLastProgress >= 0) {
                volumeStore.volume = this.mLastProgress;
                volumeStore.originalVolume = this.mOriginalStreamVolume;
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            if (!this.isSamplePlaying()) {
                this.startSample();
            }
        }

        void postSetVolume(int progress) {
            this.mLastProgress = progress;
            this.mHandler.removeCallbacks((Runnable)this);
            this.mHandler.post((Runnable)this);
        }

        public void revertVolume() {
            this.mAudioManager.setStreamVolume(this.mStreamType, this.mOriginalStreamVolume, 0);
        }

        public void run() {
            this.mAudioManager.setStreamVolume(this.mStreamType, this.mLastProgress, 0);
        }

        public void startSample() {
            VolumePreference.this.onSampleStarting(this);
            if (this.mRingtone != null) {
                this.mRingtone.play();
            }
        }

        public void stop() {
            this.stopSample();
            this.mContext.getContentResolver().unregisterContentObserver(this.mVolumeObserver);
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }

        public void stopSample() {
            if (this.mRingtone != null) {
                this.mRingtone.stop();
            }
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        VolumeStore mVolumeStore = new VolumeStore();

        public SavedState(Parcel source) {
            super(source);
            this.mVolumeStore.volume = source.readInt();
            this.mVolumeStore.originalVolume = source.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        VolumeStore getVolumeStore() {
            return this.mVolumeStore;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mVolumeStore.volume);
            dest.writeInt(this.mVolumeStore.originalVolume);
        }
    }
}

