/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.util;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return Arrays.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newSize = to - from;
        if (newSize < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newSize] : (Object[])Array.newInstance(newType.getComponentType(), newSize);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newSize));
        return copy;
    }
}

