/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.util;

import android.util.Log;
import org.holoeverywhere.util.Pool;
import org.holoeverywhere.util.Poolable;
import org.holoeverywhere.util.PoolableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinitePool<T extends Poolable<T>>
implements Pool<T> {
    private static final String TAG = "FinitePool";
    private final boolean mInfinite;
    private final int mLimit;
    private final PoolableManager<T> mManager;
    private int mPoolCount;
    private T mRoot;

    public FinitePool(PoolableManager<T> manager) {
        this.mManager = manager;
        this.mLimit = 0;
        this.mInfinite = true;
    }

    public FinitePool(PoolableManager<T> manager, int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("The pool limit must be > 0");
        }
        this.mManager = manager;
        this.mLimit = limit;
        this.mInfinite = false;
    }

    @Override
    public T acquire() {
        T element;
        if (this.mRoot != null) {
            element = this.mRoot;
            this.mRoot = (Poolable)element.getNextPoolable();
            --this.mPoolCount;
        } else {
            element = this.mManager.newInstance();
        }
        if (element != null) {
            element.setNextPoolable(null);
            element.setPooled(false);
            this.mManager.onAcquired(element);
        }
        return element;
    }

    @Override
    public void release(T element) {
        if (!element.isPooled()) {
            if (this.mInfinite || this.mPoolCount < this.mLimit) {
                ++this.mPoolCount;
                element.setNextPoolable(this.mRoot);
                element.setPooled(true);
                this.mRoot = element;
            }
            this.mManager.onReleased(element);
        } else {
            Log.w((String)TAG, (String)("Element is already in pool: " + element));
        }
    }
}

