/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.util;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaklyMap<K, V>
extends AbstractMap<K, V> {
    private final WeakHashMap<K, WeaklyReference<V>> mMap = new WeakHashMap();

    @Override
    public void clear() {
        this.mMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMap.containsValue(new WeaklyReference<Object>(value));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<K, WeaklyReference<V>>> entrySet = this.mMap.entrySet();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator iterator = entrySet.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new WeaklyEntry((Map.Entry)iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return entrySet.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        WeaklyReference<V> ref = this.mMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.mMap.keySet();
    }

    @Override
    public V put(K key, V value) {
        WeaklyReference<V> ref = this.mMap.put(key, new WeaklyReference<V>(value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.mMap.put(entry.getKey(), new WeaklyReference<V>(entry.getValue()));
        }
    }

    @Override
    public V remove(Object key) {
        WeaklyReference<V> ref = this.mMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public Collection<V> values() {
        final Collection<WeaklyReference<V>> values = this.mMap.values();
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator iterator = values.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        WeaklyReference ref = (WeaklyReference)iterator.next();
                        return ref == null ? null : (Object)ref.get();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return values.size();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeaklyReference<T>
    extends WeakReference<T> {
        public WeaklyReference(T r) {
            super(r);
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeaklyReference)) {
                return false;
            }
            Object o1 = ((WeaklyReference)o).get();
            Object o2 = this.get();
            return o1 != null && o2 != null && o1 == o2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeaklyEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, WeaklyReference<V>> mEntry;

        public WeaklyEntry(Map.Entry<K, WeaklyReference<V>> entry) {
            this.mEntry = entry;
        }

        @Override
        public K getKey() {
            return this.mEntry.getKey();
        }

        @Override
        public V getValue() {
            WeaklyReference<V> ref = this.mEntry.getValue();
            return ref == null ? null : (V)ref.get();
        }

        @Override
        public V setValue(V object) {
            WeaklyReference<V> ref = this.mEntry.setValue(new WeaklyReference<V>(object));
            return ref == null ? null : (V)ref.get();
        }
    }
}

