/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import org.holoeverywhere.R;
import org.holoeverywhere.internal._View;
import org.holoeverywhere.widget.ProgressBar;

public abstract class AbsSeekBar
extends ProgressBar {
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha;
    private boolean mIsDragging;
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private int mScaledTouchSlop;
    private Drawable mThumb;
    private int mThumbOffset;
    private float mTouchDownX;
    float mTouchProgressOffset;

    public AbsSeekBar(Context context) {
        super(context);
    }

    public AbsSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AbsSeekBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SeekBar, defStyle, 0);
        Drawable thumb = a.getDrawable(1);
        this.setThumb(thumb);
        int thumbOffset = a.getDimensionPixelOffset(2, this.getThumbOffset());
        this.setThumbOffset(thumbOffset);
        this.mDisabledAlpha = a.getFloat(0, 0.5f);
        a.recycle();
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable != null) {
            progressDrawable.setAlpha(this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha));
        }
        if (this.mThumb != null && this.mThumb.isStateful()) {
            int[] state = this.getDrawableState();
            this.mThumb.setState(state);
        }
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    public Drawable getThumb() {
        return this.mThumb;
    }

    public int getThumbOffset() {
        return this.mThumbOffset;
    }

    public boolean isInScrollingContainer() {
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumb != null) {
            this.mThumb.jumpToCurrentState();
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mThumb != null) {
            canvas.save();
            canvas.translate((float)(this.getPaddingLeft() - this.mThumbOffset), (float)this.getPaddingTop());
            this.mThumb.draw(canvas);
            canvas.restore();
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)AbsSeekBar.class.getName());
    }

    @SuppressLint(value={"NewApi"})
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)AbsSeekBar.class.getName());
        if (this.isEnabled()) {
            int progress = this.getProgress();
            if (progress > 0) {
                info.addAction(8192);
            }
            if (progress < this.getMax()) {
                info.addAction(4096);
            }
        }
    }

    void onKeyChange() {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            int progress = this.getProgress();
            switch (keyCode) {
                case 21: {
                    if (progress <= 0) break;
                    this.setProgress(progress - this.mKeyProgressIncrement, true);
                    this.onKeyChange();
                    return true;
                }
                case 22: {
                    if (progress >= this.getMax()) break;
                    this.setProgress(progress + this.mKeyProgressIncrement, true);
                    this.onKeyChange();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getCurrentDrawable();
        int thumbHeight = this.mThumb == null ? 0 : this.mThumb.getIntrinsicHeight();
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
            dh = Math.max(thumbHeight, dh);
        }
        this.setMeasuredDimension(_View.supportResolveSizeAndState(dw += this.getPaddingLeft() + this.getPaddingRight(), widthMeasureSpec, 0), _View.supportResolveSizeAndState(dh += this.getPaddingTop() + this.getPaddingBottom(), heightMeasureSpec, 0));
    }

    public void onProgressRefresh(float scale, boolean fromUser) {
        super.onProgressRefresh(scale, fromUser);
        Drawable thumb = this.mThumb;
        if (thumb != null) {
            this.setThumbPos(this.getWidth(), thumb, scale, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateThumbPos(w, h);
    }

    void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsUserSeekable || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.isInScrollingContainer()) {
                    this.mTouchDownX = event.getX();
                    break;
                }
                this.setPressed(true);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    break;
                }
                float x = event.getX();
                if (!(Math.abs(x - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                this.setPressed(true);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(event);
                this.attemptClaimDrag();
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                }
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                }
                this.invalidate();
            }
        }
        return true;
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        int progress = this.getProgress();
        int increment = Math.max(1, Math.round((float)this.getMax() / 5.0f));
        switch (action) {
            case 8192: {
                if (progress <= 0) {
                    return false;
                }
                this.setProgress(progress - increment, true);
                this.onKeyChange();
                return true;
            }
            case 4096: {
                if (progress >= this.getMax()) {
                    return false;
                }
                this.setProgress(progress + increment, true);
                this.onKeyChange();
                return true;
            }
        }
        return false;
    }

    public void setKeyProgressIncrement(int increment) {
        this.mKeyProgressIncrement = increment < 0 ? -increment : increment;
    }

    public synchronized void setMax(int max) {
        super.setMax(max);
        if (this.mKeyProgressIncrement == 0 || this.getMax() / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(Math.max(1, Math.round((float)this.getMax() / 20.0f)));
        }
    }

    public void setThumb(Drawable thumb) {
        boolean needUpdate;
        if (this.mThumb != null && thumb != this.mThumb) {
            this.mThumb.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (thumb != null) {
            thumb.setCallback((Drawable.Callback)this);
            this.mThumbOffset = thumb.getIntrinsicWidth() / 2;
            if (needUpdate && (thumb.getIntrinsicWidth() != this.mThumb.getIntrinsicWidth() || thumb.getIntrinsicHeight() != this.mThumb.getIntrinsicHeight())) {
                this.requestLayout();
            }
        }
        this.mThumb = thumb;
        this.invalidate();
        if (needUpdate) {
            this.updateThumbPos(this.getWidth(), this.getHeight());
            if (thumb != null && thumb.isStateful()) {
                int[] state = this.getDrawableState();
                thumb.setState(state);
            }
        }
    }

    public void setThumbOffset(int thumbOffset) {
        this.mThumbOffset = thumbOffset;
        this.invalidate();
    }

    private void setThumbPos(int w, Drawable thumb, float scale, int gap) {
        int bottomBound;
        int topBound;
        int available = w - this.getPaddingLeft() - this.getPaddingRight();
        int thumbWidth = thumb.getIntrinsicWidth();
        int thumbHeight = thumb.getIntrinsicHeight();
        available -= thumbWidth;
        int thumbPos = (int)(scale * (float)(available += this.mThumbOffset * 2));
        if (gap == Integer.MIN_VALUE) {
            Rect oldBounds = thumb.getBounds();
            topBound = oldBounds.top;
            bottomBound = oldBounds.bottom;
        } else {
            topBound = gap;
            bottomBound = gap + thumbHeight;
        }
        thumb.setBounds(thumbPos, topBound, thumbPos + thumbWidth, bottomBound);
    }

    private void trackTouchEvent(MotionEvent event) {
        float scale;
        int width = this.getWidth();
        int available = width - this.getPaddingLeft() - this.getPaddingRight();
        int x = (int)event.getX();
        float progress = 0.0f;
        if (x < this.getPaddingLeft()) {
            scale = 0.0f;
        } else if (x > width - this.getPaddingRight()) {
            scale = 1.0f;
        } else {
            scale = (float)(x - this.getPaddingLeft()) / (float)available;
            progress = this.mTouchProgressOffset;
        }
        int max = this.getMax();
        this.setProgress((int)(progress += scale * (float)max), true);
    }

    private void updateThumbPos(int w, int h) {
        float scale;
        Drawable d = this.getCurrentDrawable();
        Drawable thumb = this.mThumb;
        int thumbHeight = thumb == null ? 0 : thumb.getIntrinsicHeight();
        int trackHeight = Math.min(this.mMaxHeight, h - this.getPaddingTop() - this.getPaddingBottom());
        int max = this.getMax();
        float f = scale = max > 0 ? (float)this.getProgress() / (float)max : 0.0f;
        if (thumbHeight > trackHeight) {
            if (thumb != null) {
                this.setThumbPos(w, thumb, scale, 0);
            }
            int gapForCenteringTrack = (thumbHeight - trackHeight) / 2;
            if (d != null) {
                d.setBounds(0, gapForCenteringTrack, w - this.getPaddingRight() - this.getPaddingLeft(), h - this.getPaddingBottom() - gapForCenteringTrack - this.getPaddingTop());
            }
        } else {
            if (d != null) {
                d.setBounds(0, 0, w - this.getPaddingRight() - this.getPaddingLeft(), h - this.getPaddingBottom() - this.getPaddingTop());
            }
            int gap = (trackHeight - thumbHeight) / 2;
            if (thumb != null) {
                this.setThumbPos(w, thumb, scale, gap);
            }
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mThumb || super.verifyDrawable(who);
    }
}

