/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.TextView;
import org.holoeverywhere.FontLoader;
import org.holoeverywhere.R;
import org.holoeverywhere.widget.TextView;

public class CheckedTextView
extends android.widget.CheckedTextView
implements FontLoader.FontStyleProvider {
    private boolean allCaps = false;
    private int mFontStyle;
    private CharSequence originalText;
    private TextView.BufferType originalType;

    public CheckedTextView(Context context) {
        this(context, null);
    }

    public CheckedTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CheckedTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TextView, defStyle, 0);
        this.allCaps = a.hasValue(1) ? a.getBoolean(1, false) : a.getBoolean(2, false);
        CharSequence text = null;
        if (a.hasValue(0)) {
            text = a.getText(0);
        }
        a.recycle();
        if (text != null) {
            this.setText(text);
        }
        this.mFontStyle = TextView.parseFontStyle(context, attrs, defStyle);
    }

    @SuppressLint(value={"NewApi"})
    public void dispatchDisplayHint(int hint) {
        this.onDisplayHint(hint);
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public boolean isAllCaps() {
        return this.allCaps;
    }

    @SuppressLint(value={"NewApi"})
    protected void onDisplayHint(int hint) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onDisplayHint(hint);
        }
    }

    public void setAllCaps(boolean allCaps) {
        this.allCaps = allCaps;
        this.updateTextState();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.originalText = text;
        this.originalType = type;
        this.updateTextState();
    }

    private void updateTextState() {
        if (this.originalText == null) {
            super.setText(null, this.originalType);
            return;
        }
        super.setText(this.allCaps ? this.originalText.toString().toUpperCase() : this.originalText, this.originalType);
    }
}

