/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.inputmethod.InputMethodManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.internal.NumberPickerEditText;
import org.holoeverywhere.util.Arrays;
import org.holoeverywhere.widget.CalendarView;
import org.holoeverywhere.widget.FrameLayout;
import org.holoeverywhere.widget.LinearLayout;
import org.holoeverywhere.widget.NumberPicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePicker
extends FrameLayout {
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final String LOG_TAG = DatePicker.class.getSimpleName();
    private final Callback callback = new Callback();
    private final java.text.DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private final NumberPicker daySpinner;
    private final NumberPicker monthSpinner;
    private final NumberPicker yearSpinner;
    private final InputMethodManager inputMethodManager;
    private Locale locale;
    private final CalendarView mCalendarView;
    private int numberOfMonths;
    private OnDateChangedListener onDateChangedListener;
    private String[] shortMonths;
    private final LinearLayout spinners;
    private Calendar tempDate;
    private Calendar minDate;
    private Calendar maxDate;
    private Calendar currentDate;

    private static Calendar getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private static void setContentDescription(View parent, int childId, int textId) {
        if (parent == null) {
            return;
        }
        View child = parent.findViewById(childId);
        if (child != null) {
            child.setContentDescription(parent.getContext().getText(textId));
        }
    }

    public DatePicker(Context context) {
        this(context, null);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.datePickerStyle);
    }

    public DatePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyle, R.style.Holo_DatePicker);
        boolean spinnersShown = a.getBoolean(6, true);
        boolean calendarViewShown = a.getBoolean(0, true);
        boolean forceShownState = a.getBoolean(2, false);
        int startYear = a.getInt(7, 1900);
        int endYear = a.getInt(1, 2100);
        String minDate = a.getString(5);
        String maxDate = a.getString(4);
        int layoutResourceId = a.getResourceId(3, R.layout.date_picker_holo);
        a.recycle();
        this.inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        this.setLocale(Locale.getDefault());
        LayoutInflater.inflate(context, layoutResourceId, (ViewGroup)this, true);
        this.spinners = (LinearLayout)this.findViewById(R.id.pickers);
        this.mCalendarView = (CalendarView)this.findViewById(R.id.calendar_view);
        this.daySpinner = (NumberPicker)this.findViewById(R.id.day);
        this.monthSpinner = (NumberPicker)this.findViewById(R.id.month);
        this.yearSpinner = (NumberPicker)this.findViewById(R.id.year);
        if (((AccessibilityManager)this.getContext().getSystemService("accessibility")).isEnabled()) {
            this.setContentDescriptions();
        }
        this.mCalendarView.setOnDateChangeListener(this.callback);
        this.daySpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.daySpinner.setOnLongPressUpdateInterval(100L);
        this.daySpinner.setOnValueChangedListener(this.callback);
        this.monthSpinner.setMinValue(0);
        this.monthSpinner.setMaxValue(this.numberOfMonths - 1);
        this.monthSpinner.setDisplayedValues(this.shortMonths);
        this.monthSpinner.setOnLongPressUpdateInterval(200L);
        this.monthSpinner.setOnValueChangedListener(this.callback);
        this.yearSpinner.setOnLongPressUpdateInterval(100L);
        this.yearSpinner.setOnValueChangedListener(this.callback);
        if (spinnersShown || calendarViewShown || forceShownState) {
            this.setSpinnersShown(spinnersShown);
            this.setCalendarViewShown(calendarViewShown);
        } else {
            this.setSpinnersShown(true);
            this.setCalendarViewShown(false);
        }
        this.tempDate.clear();
        if (TextUtils.isEmpty((CharSequence)minDate) || !this.parseDate(minDate, this.tempDate)) {
            this.tempDate.set(startYear, 0, 1);
        }
        this.setMinDate(this.tempDate.getTimeInMillis());
        this.tempDate.clear();
        if (TextUtils.isEmpty((CharSequence)maxDate) || !this.parseDate(maxDate, this.tempDate)) {
            this.tempDate.set(endYear, 11, 31);
        }
        this.setMaxDate(this.tempDate.getTimeInMillis());
        this.currentDate.setTimeInMillis(System.currentTimeMillis());
        this.init(this.currentDate.get(1), this.currentDate.get(2), this.currentDate.get(5), null);
        this.reorderSpinners();
    }

    private void checkInputState(NumberPicker ... spinners) {
        for (NumberPicker spinner : spinners) {
            NumberPickerEditText input = spinner.getInputField();
            if (!this.inputMethodManager.isActive((View)input)) continue;
            input.clearFocus();
            this.inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
    }

    @SuppressLint(value={"NewApi"})
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    public CalendarView getCalendarView() {
        return this.mCalendarView;
    }

    public boolean getCalendarViewShown() {
        return this.mCalendarView.isShown();
    }

    public int getDayOfMonth() {
        return this.currentDate.get(5);
    }

    public long getMaxDate() {
        return this.mCalendarView.getMaxDate();
    }

    public long getMinDate() {
        return this.mCalendarView.getMinDate();
    }

    public int getMonth() {
        return this.currentDate.get(2);
    }

    public OnDateChangedListener getOnDateChangedListener() {
        return this.onDateChangedListener;
    }

    public boolean getSpinnersShown() {
        return this.spinners.isShown();
    }

    public int getYear() {
        return this.currentDate.get(1);
    }

    public void init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.setOnDateChangedListener(onDateChangedListener);
        this.setDate(year, monthOfYear, dayOfMonth);
        this.updateSpinners();
        this.updateCalendarView();
    }

    private boolean isNewDate(int year, int month, int dayOfMonth) {
        return this.currentDate.get(1) != year || this.currentDate.get(2) != dayOfMonth || this.currentDate.get(5) != month;
    }

    private void notifyDateChanged() {
        this.sendAccessibilityEvent(4);
        if (this.onDateChangedListener != null) {
            this.onDateChangedListener.onDateChanged(this, this.getYear(), this.getMonth(), this.getDayOfMonth());
        }
    }

    @SuppressLint(value={"NewApi"})
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setLocale(newConfig.locale);
    }

    @SuppressLint(value={"NewApi"})
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.onPopulateAccessibilityEvent(event);
        }
        int flags = 20;
        String selectedDateUtterance = DateUtils.formatDateTime((Context)this.getContext(), (long)this.currentDate.getTimeInMillis(), (int)20);
        event.getText().add(selectedDateUtterance);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setDate(ss.year, ss.month, ss.day);
        this.updateSpinners();
        this.updateCalendarView();
    }

    protected Parcelable onSaveInstanceState() {
        return new SavedState(super.onSaveInstanceState(), this.getYear(), this.getMonth(), this.getDayOfMonth());
    }

    private boolean parseDate(String date, Calendar outDate) {
        try {
            outDate.setTime(this.dateFormat.parse(date));
            return true;
        }
        catch (ParseException e) {
            Log.w((String)LOG_TAG, (String)("Date: " + date + " not in format: " + DATE_FORMAT));
            return false;
        }
    }

    private void pushSpinner(NumberPicker spinner, int spinnerCount, int i) {
        ViewGroup parent;
        if (spinner.getParent() != null && spinner.getParent() instanceof ViewGroup && (parent = (ViewGroup)spinner.getParent()).getChildAt(i) != spinner) {
            parent.removeView((View)spinner);
            parent.addView((View)spinner);
            this.setImeOptions(spinner, spinnerCount, i);
        }
    }

    private void reorderSpinners() {
        char[] order = DateFormat.getDateFormatOrder((Context)this.getContext());
        int spinnerCount = order.length;
        block5: for (int i = 0; i < spinnerCount; ++i) {
            switch (order[i]) {
                case 'd': {
                    this.pushSpinner(this.daySpinner, spinnerCount, i);
                    continue block5;
                }
                case 'M': {
                    this.pushSpinner(this.monthSpinner, spinnerCount, i);
                    continue block5;
                }
                case 'y': {
                    this.pushSpinner(this.yearSpinner, spinnerCount, i);
                }
            }
        }
    }

    public void setCalendarViewShown(boolean shown) {
        this.mCalendarView.setVisibility(shown ? 0 : 8);
    }

    private void setContentDescriptions() {
        DatePicker.setContentDescription((View)this.daySpinner, R.id.increment, R.string.date_picker_increment_day_button);
        DatePicker.setContentDescription((View)this.daySpinner, R.id.decrement, R.string.date_picker_decrement_day_button);
        DatePicker.setContentDescription((View)this.monthSpinner, R.id.increment, R.string.date_picker_increment_month_button);
        DatePicker.setContentDescription((View)this.monthSpinner, R.id.decrement, R.string.date_picker_decrement_month_button);
        DatePicker.setContentDescription((View)this.yearSpinner, R.id.increment, R.string.date_picker_increment_year_button);
        DatePicker.setContentDescription((View)this.yearSpinner, R.id.decrement, R.string.date_picker_decrement_year_button);
    }

    private void setDate(int year, int month, int dayOfMonth) {
        this.currentDate.set(year, month, dayOfMonth);
        if (this.currentDate.before(this.minDate)) {
            this.currentDate.setTimeInMillis(this.minDate.getTimeInMillis());
        } else if (this.currentDate.after(this.maxDate)) {
            this.currentDate.setTimeInMillis(this.maxDate.getTimeInMillis());
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.daySpinner.setEnabled(enabled);
        this.monthSpinner.setEnabled(enabled);
        this.yearSpinner.setEnabled(enabled);
        this.mCalendarView.setEnabled(enabled);
    }

    private void setImeOptions(NumberPicker spinner, int spinnerCount, int spinnerIndex) {
        int imeOptions = spinnerIndex < spinnerCount - 1 ? 5 : 6;
        spinner.getInputField().setImeOptions(imeOptions);
    }

    public void setLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return;
        }
        this.locale = locale;
        this.tempDate = DatePicker.getCalendarForLocale(this.tempDate, locale);
        this.minDate = DatePicker.getCalendarForLocale(this.minDate, locale);
        this.maxDate = DatePicker.getCalendarForLocale(this.maxDate, locale);
        this.currentDate = DatePicker.getCalendarForLocale(this.currentDate, locale);
        this.numberOfMonths = this.tempDate.getActualMaximum(2) + 1;
        this.shortMonths = new String[this.numberOfMonths];
        for (int i = 0; i < this.numberOfMonths; ++i) {
            this.shortMonths[i] = DateUtils.getMonthString((int)(0 + i), (int)20);
        }
    }

    public void setMaxDate(long maxDateL) {
        this.tempDate.setTimeInMillis(maxDateL);
        if (this.tempDate.get(1) == this.maxDate.get(1) && this.tempDate.get(6) == this.maxDate.get(6)) {
            return;
        }
        this.maxDate.setTimeInMillis(maxDateL);
        this.mCalendarView.setMaxDate(maxDateL);
        if (this.currentDate.after(this.maxDate)) {
            this.currentDate.setTimeInMillis(this.maxDate.getTimeInMillis());
            this.updateCalendarView();
        }
        this.updateSpinners();
    }

    public void setMinDate(long minDateL) {
        this.tempDate.setTimeInMillis(minDateL);
        if (this.tempDate.get(1) == this.minDate.get(1) && this.tempDate.get(6) == this.minDate.get(6)) {
            return;
        }
        this.minDate.setTimeInMillis(minDateL);
        this.mCalendarView.setMinDate(minDateL);
        if (this.currentDate.before(this.minDate)) {
            this.currentDate.setTimeInMillis(this.minDate.getTimeInMillis());
            this.updateCalendarView();
        }
        this.updateSpinners();
    }

    public void setOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.onDateChangedListener = onDateChangedListener;
    }

    public void setSpinnersShown(boolean shown) {
        this.spinners.setVisibility(shown ? 0 : 8);
    }

    private void updateCalendarView() {
        this.mCalendarView.setDate(this.currentDate.getTimeInMillis(), false, false);
    }

    public void updateDate(int year, int month, int dayOfMonth) {
        if (!this.isNewDate(year, month, dayOfMonth)) {
            return;
        }
        this.setDate(year, month, dayOfMonth);
        this.updateSpinners();
        this.updateCalendarView();
        this.notifyDateChanged();
    }

    private void updateInputState() {
        if (this.inputMethodManager != null) {
            this.checkInputState(this.yearSpinner, this.monthSpinner, this.daySpinner);
        }
    }

    private void updateSpinners() {
        this.monthSpinner.setDisplayedValues(null);
        if (this.currentDate.equals(this.minDate)) {
            this.daySpinner.setMinValue(this.currentDate.get(5));
            this.daySpinner.setMaxValue(this.currentDate.getActualMaximum(5));
            this.daySpinner.setWrapSelectorWheel(false);
            this.monthSpinner.setMinValue(this.currentDate.get(2));
            this.monthSpinner.setMaxValue(this.currentDate.getActualMaximum(2));
            this.monthSpinner.setWrapSelectorWheel(false);
        } else if (this.currentDate.equals(this.maxDate)) {
            this.daySpinner.setMinValue(this.currentDate.getActualMinimum(5));
            this.daySpinner.setMaxValue(this.currentDate.get(5));
            this.daySpinner.setWrapSelectorWheel(false);
            this.monthSpinner.setMinValue(this.currentDate.getActualMinimum(2));
            this.monthSpinner.setMaxValue(this.currentDate.get(2));
            this.monthSpinner.setWrapSelectorWheel(false);
        } else {
            this.daySpinner.setMinValue(1);
            this.daySpinner.setMaxValue(this.currentDate.getActualMaximum(5));
            this.daySpinner.setWrapSelectorWheel(true);
            this.monthSpinner.setMinValue(0);
            this.monthSpinner.setMaxValue(11);
            this.monthSpinner.setWrapSelectorWheel(true);
        }
        String[] displayedValues = Arrays.copyOfRange(this.shortMonths, this.monthSpinner.getMinValue(), this.monthSpinner.getMaxValue() + 1);
        this.monthSpinner.setDisplayedValues(displayedValues);
        this.yearSpinner.setMinValue(this.minDate.get(1));
        this.yearSpinner.setMaxValue(this.maxDate.get(1));
        this.yearSpinner.setWrapSelectorWheel(false);
        this.yearSpinner.setValue(this.currentDate.get(1));
        this.monthSpinner.setValue(this.currentDate.get(2));
        this.daySpinner.setValue(this.currentDate.get(5));
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private final int year;
        private final int month;
        private final int day;

        private SavedState(Parcel in) {
            super(in);
            this.year = in.readInt();
            this.month = in.readInt();
            this.day = in.readInt();
        }

        private SavedState(Parcelable superState, int year, int month, int day) {
            super(superState);
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.year);
            dest.writeInt(this.month);
            dest.writeInt(this.day);
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }

    private final class Callback
    implements NumberPicker.OnValueChangeListener,
    CalendarView.OnDateChangeListener {
        private Callback() {
        }

        public void onSelectedDayChange(CalendarView view, int year, int month, int monthDay) {
            DatePicker.this.setDate(year, month, monthDay);
            DatePicker.this.updateSpinners();
            DatePicker.this.notifyDateChanged();
        }

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            DatePicker.this.updateInputState();
            DatePicker.this.tempDate.setTimeInMillis(DatePicker.this.currentDate.getTimeInMillis());
            if (picker == DatePicker.this.daySpinner) {
                int maxDayOfMonth = DatePicker.this.tempDate.getActualMaximum(5);
                if (oldVal == maxDayOfMonth && newVal == 1) {
                    DatePicker.this.tempDate.add(5, 1);
                } else if (oldVal == 1 && newVal == maxDayOfMonth) {
                    DatePicker.this.tempDate.add(5, -1);
                } else {
                    DatePicker.this.tempDate.add(5, newVal - oldVal);
                }
            } else if (picker == DatePicker.this.monthSpinner) {
                if (oldVal == 11 && newVal == 0) {
                    DatePicker.this.tempDate.add(2, 1);
                } else if (oldVal == 0 && newVal == 11) {
                    DatePicker.this.tempDate.add(2, -1);
                } else {
                    DatePicker.this.tempDate.add(2, newVal - oldVal);
                }
            } else if (picker == DatePicker.this.yearSpinner) {
                DatePicker.this.tempDate.set(1, newVal);
            } else {
                return;
            }
            DatePicker.this.setDate(DatePicker.this.tempDate.get(1), DatePicker.this.tempDate.get(2), DatePicker.this.tempDate.get(5));
            DatePicker.this.updateSpinners();
            DatePicker.this.updateCalendarView();
            DatePicker.this.notifyDateChanged();
        }
    }
}

