/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.List;
import org.holoeverywhere.widget.ListAdapterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderViewListAdapter
extends ListAdapterWrapper
implements Filterable {
    private static final List<ViewInfo> EMPTY_INFO_LIST = new ArrayList<ViewInfo>();
    boolean mAreAllFixedViewsSelectable;
    private final List<ViewInfo> mFooterViewInfos;
    private final List<ViewInfo> mHeaderViewInfos;
    private final boolean mIsFilterable;

    public HeaderViewListAdapter(List<ViewInfo> headerViewInfos, List<ViewInfo> footerViewInfos, ListAdapter adapter, ListAdapterWrapper.ListAdapterCallback listener) {
        super(adapter, listener);
        this.mIsFilterable = adapter instanceof Filterable;
        this.mHeaderViewInfos = headerViewInfos == null ? EMPTY_INFO_LIST : headerViewInfos;
        this.mFooterViewInfos = footerViewInfos == null ? EMPTY_INFO_LIST : footerViewInfos;
        this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
    }

    @Override
    public boolean areAllItemsEnabled() {
        return this.mAreAllFixedViewsSelectable && this.getWrappedAdapter().areAllItemsEnabled();
    }

    private boolean areAllListInfosSelectable(List<ViewInfo> infos) {
        if (infos != null) {
            for (ViewInfo info : infos) {
                if (info.isSelectable) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getCount() {
        return this.getFootersCount() + this.getHeadersCount() + this.getWrappedAdapter().getCount();
    }

    public Filter getFilter() {
        if (this.mIsFilterable) {
            return ((Filterable)this.getWrappedAdapter()).getFilter();
        }
        return null;
    }

    public int getFootersCount() {
        return this.mFooterViewInfos.size();
    }

    public int getHeadersCount() {
        return this.mHeaderViewInfos.size();
    }

    @Override
    public Object getItem(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).data;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = this.getWrappedAdapter().getCount();
        if (adjPosition < adapterCount) {
            return super.getItem(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).data;
    }

    @Override
    public long getItemId(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.getWrappedAdapter().getCount())) {
            return super.getItemId(adjPosition);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int getItemViewType(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (this.getWrappedAdapter() != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.getWrappedAdapter().getCount())) {
            return super.getItemViewType(adjPosition);
        }
        return -2;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        convertView = position < numHeaders ? this.mHeaderViewInfos.get((int)position).view : ((adjPosition = position - numHeaders) < (adapterCount = this.getWrappedAdapter().getCount()) ? this.getWrappedAdapter().getView(adjPosition, convertView, parent) : this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).view);
        return this.onPrepareView(convertView, position);
    }

    @Override
    public boolean isEnabled(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).isSelectable;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = this.getWrappedAdapter().getCount();
        if (adjPosition < adapterCount) {
            return super.isEnabled(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).isSelectable;
    }

    public boolean removeFooter(View v) {
        for (int i = 0; i < this.mFooterViewInfos.size(); ++i) {
            ViewInfo info = this.mFooterViewInfos.get(i);
            if (info.view != v) continue;
            this.mFooterViewInfos.remove(i);
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
            return true;
        }
        return false;
    }

    public boolean removeHeader(View v) {
        for (int i = 0; i < this.mHeaderViewInfos.size(); ++i) {
            ViewInfo info = this.mHeaderViewInfos.get(i);
            if (info.view != v) continue;
            this.mHeaderViewInfos.remove(i);
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
            return true;
        }
        return false;
    }

    public static final class ViewInfo {
        public Object data;
        public boolean isSelectable;
        public View view;
    }
}

