/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import org.holoeverywhere.R;

public class LinearLayout
extends android.widget.LinearLayout {
    public static final int HORIZONTAL = 0;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_FILL = 3;
    private static final int INDEX_TOP = 1;
    public static final int LAYOUT_DIRECTION_LTR = 0;
    public static final int LAYOUT_DIRECTION_RTL = 1;
    public static final int SHOW_DIVIDER_ALL = 7;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int VERTICAL = 1;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mBaselineAligned = true;
    @ViewDebug.ExportedProperty(category="layout")
    private int mBaselineAlignedChildIndex = -1;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mBaselineChildTop = 0;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mDividerWidth;
    @ViewDebug.ExportedProperty(category="measurement", flagMapping={@ViewDebug.FlagToString(mask=-1, equals=-1, name="NONE"), @ViewDebug.FlagToString(mask=0, equals=0, name="NONE"), @ViewDebug.FlagToString(mask=48, equals=48, name="TOP"), @ViewDebug.FlagToString(mask=80, equals=80, name="BOTTOM"), @ViewDebug.FlagToString(mask=3, equals=3, name="LEFT"), @ViewDebug.FlagToString(mask=5, equals=5, name="RIGHT"), @ViewDebug.FlagToString(mask=0x800003, equals=0x800003, name="START"), @ViewDebug.FlagToString(mask=0x800005, equals=0x800005, name="END"), @ViewDebug.FlagToString(mask=16, equals=16, name="CENTER_VERTICAL"), @ViewDebug.FlagToString(mask=112, equals=112, name="FILL_VERTICAL"), @ViewDebug.FlagToString(mask=1, equals=1, name="CENTER_HORIZONTAL"), @ViewDebug.FlagToString(mask=7, equals=7, name="FILL_HORIZONTAL"), @ViewDebug.FlagToString(mask=17, equals=17, name="CENTER"), @ViewDebug.FlagToString(mask=119, equals=119, name="FILL"), @ViewDebug.FlagToString(mask=0x800000, equals=0x800000, name="RELATIVE")})
    private int mGravity = 0x800033;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mOrientation;
    private int mShowDividers;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mTotalLength;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mUseLargestChild;
    @ViewDebug.ExportedProperty(category="layout")
    private float mWeightSum;

    public static int getAbsoluteGravity(int gravity, int layoutDirection) {
        int result = gravity;
        if ((result & 0x800000) > 0) {
            if ((result & 0x800003) == 0x800003) {
                result &= 0xFF7FFFFC;
                result = layoutDirection == 1 ? (result |= 5) : (result |= 3);
            } else if ((result & 0x800005) == 0x800005) {
                result &= 0xFF7FFFFA;
                result = layoutDirection == 1 ? (result |= 3) : (result |= 5);
            }
            result &= 0xFF7FFFFF;
        }
        return result;
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    public LinearLayout(Context context) {
        this(context, null);
    }

    public LinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        boolean baselineAligned;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LinearLayout, defStyle, 0);
        int index = a.getInt(1, -1);
        if (index >= 0) {
            this.setOrientation(index);
        }
        if ((index = a.getInt(0, -1)) >= 0) {
            this.setGravity(index);
        }
        if (!(baselineAligned = a.getBoolean(2, true))) {
            this.setBaselineAligned(baselineAligned);
        }
        this.mWeightSum = a.getFloat(4, -1.0f);
        this.mBaselineAlignedChildIndex = a.getInt(3, -1);
        this.mUseLargestChild = a.getBoolean(6, false);
        this.setDividerDrawable(a.getDrawable(5));
        TypedValue value = new TypedValue();
        a.getValue(7, value);
        this.mShowDividers = value.data;
        a.getValue(8, value);
        this.mDividerPadding = TypedValue.complexToDimensionPixelSize((int)value.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        a.recycle();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LinearLayout.LayoutParams;
    }

    void drawDividersHorizontal(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getVirtualChildCount();
        boolean isLayoutRtl = this.isLayoutRtl();
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int position = isLayoutRtl ? child.getRight() + lp.rightMargin : child.getLeft() - lp.leftMargin - this.mDividerWidth;
            this.drawVerticalDivider(canvas, position);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            int position;
            View child = this.getVirtualChildAt(count - 1);
            if (child == null) {
                position = isLayoutRtl ? this.getPaddingLeft() : this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                position = isLayoutRtl ? child.getLeft() - lp.leftMargin - this.mDividerWidth : child.getRight() + lp.rightMargin;
            }
            this.drawVerticalDivider(canvas, position);
        }
    }

    void drawDividersVertical(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getVirtualChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin - this.mDividerHeight;
            this.drawHorizontalDivider(canvas, top);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getVirtualChildAt(count - 1);
            int bottom = 0;
            if (child == null) {
                bottom = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                bottom = child.getBottom() + lp.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    private void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LinearLayout.LayoutParams(-2, -2);
        }
        if (this.mOrientation == 1) {
            return new LinearLayout.LayoutParams(-1, -2);
        }
        return null;
    }

    public LinearLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LinearLayout.LayoutParams(this.getContext(), attrs);
    }

    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LinearLayout.LayoutParams(p);
    }

    public int getBaseline() {
        int majorGravity;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        if (this.getChildCount() <= this.mBaselineAlignedChildIndex) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View child = this.getChildAt(this.mBaselineAlignedChildIndex);
        int childBaseline = child.getBaseline();
        if (childBaseline == -1) {
            if (this.mBaselineAlignedChildIndex == 0) {
                return -1;
            }
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        int childTop = this.mBaselineChildTop;
        if (this.mOrientation == 1 && (majorGravity = this.mGravity & 0x70) != 48) {
            switch (majorGravity) {
                case 80: {
                    childTop = this.getBottom() - this.getTop() - this.getPaddingBottom() - this.mTotalLength;
                    break;
                }
                case 16: {
                    childTop += (this.getBottom() - this.getTop() - this.getPaddingTop() - this.getPaddingBottom() - this.mTotalLength) / 2;
                }
            }
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
        return childTop + lp.topMargin + childBaseline;
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    int getChildrenSkipCount(View child, int index) {
        return 0;
    }

    public Drawable getDividerDrawable() {
        return this.mDivider;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public int getLayoutDirection() {
        return 0;
    }

    int getLocationOffset(View child) {
        return 0;
    }

    int getNextLocationOffset(View child) {
        return 0;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    View getVirtualChildAt(int index) {
        return this.getChildAt(index);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (childIndex == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            for (int i = childIndex - 1; i >= 0; --i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                hasVisibleViewBefore = true;
                break;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    protected boolean isLayoutRtl() {
        return this.getLayoutDirection() == 1;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    void layoutHorizontal() {
        boolean isLayoutRtl = this.isLayoutRtl();
        int paddingTop = this.getPaddingTop();
        int height = this.getBottom() - this.getTop();
        int childBottom = height - this.getPaddingBottom();
        int childSpace = height - paddingTop - this.getPaddingBottom();
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 0x800007;
        int minorGravity = this.mGravity & 0x70;
        boolean baselineAligned = this.mBaselineAligned;
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        int layoutDirection = this.getLayoutDirection();
        switch (LinearLayout.getAbsoluteGravity(majorGravity, layoutDirection)) {
            case 5: {
                int childLeft = this.getPaddingLeft() + this.getRight() - this.getLeft() - this.mTotalLength;
                break;
            }
            case 1: {
                int childLeft = this.getPaddingLeft() + (this.getRight() - this.getLeft() - this.mTotalLength) / 2;
                break;
            }
            default: {
                int childLeft = this.getPaddingLeft();
            }
        }
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childTop;
            int gravity;
            int childIndex = start + dir * i;
            View child = this.getVirtualChildAt(childIndex);
            if (child == null) {
                childLeft += this.measureNullChild(childIndex);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childBaseline = -1;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (baselineAligned && lp.height != -1) {
                childBaseline = child.getBaseline();
            }
            if ((gravity = lp.gravity) < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 0x70) {
                case 48: {
                    childTop = paddingTop + lp.topMargin;
                    if (childBaseline == -1) break;
                    childTop += maxAscent[1] - childBaseline;
                    break;
                }
                case 16: {
                    childTop = paddingTop + (childSpace - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = childBottom - childHeight - lp.bottomMargin;
                    if (childBaseline == -1) break;
                    int descent = child.getMeasuredHeight() - childBaseline;
                    childTop -= maxDescent[2] - descent;
                    break;
                }
                default: {
                    childTop = paddingTop;
                }
            }
            if (this.hasDividerBeforeChildAt(childIndex)) {
                childLeft += this.mDividerWidth;
            }
            this.setChildFrame(child, (childLeft += lp.leftMargin) + this.getLocationOffset(child), childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, childIndex);
        }
    }

    void layoutVertical() {
        int paddingLeft = this.getPaddingLeft();
        int width = this.getRight() - this.getLeft();
        int childRight = width - this.getPaddingRight();
        int childSpace = width - paddingLeft - this.getPaddingRight();
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 0x70;
        int minorGravity = this.mGravity & 0x800007;
        switch (majorGravity) {
            case 80: {
                int childTop = this.getPaddingTop() + this.getBottom() - this.getTop() - this.mTotalLength;
                break;
            }
            case 16: {
                int childTop = this.getPaddingTop() + (this.getBottom() - this.getTop() - this.mTotalLength) / 2;
                break;
            }
            default: {
                int childTop = this.getPaddingTop();
            }
        }
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                childTop += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = LinearLayout.getAbsoluteGravity(gravity, layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft + lp.leftMargin;
                }
            }
            if (this.hasDividerBeforeChildAt(i)) {
                childTop += this.mDividerHeight;
            }
            this.setChildFrame(child, childLeft, (childTop += lp.topMargin) + this.getLocationOffset(child), childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, i);
        }
    }

    void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        int totalLength;
        LinearLayout.LayoutParams lp;
        int i;
        this.mTotalLength = 0;
        int maxHeight = 0;
        int childState = 0;
        int alternativeMaxHeight = 0;
        int weightedMaxHeight = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        boolean matchHeight = false;
        if (this.mMaxAscent == null || this.mMaxDescent == null) {
            this.mMaxAscent = new int[4];
            this.mMaxDescent = new int[4];
        }
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        maxAscent[3] = -1;
        maxAscent[2] = -1;
        maxAscent[1] = -1;
        maxAscent[0] = -1;
        maxDescent[3] = -1;
        maxDescent[2] = -1;
        maxDescent[1] = -1;
        maxDescent[0] = -1;
        boolean baselineAligned = this.mBaselineAligned;
        boolean useLargestChild = this.mUseLargestChild;
        boolean isExactly = widthMode == 0x40000000;
        int largestChildWidth = Integer.MIN_VALUE;
        for (i = 0; i < count; ++i) {
            int childBaseline;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            if (this.hasDividerBeforeChildAt(i)) {
                this.mTotalLength += this.mDividerWidth;
            }
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            if (widthMode == 0x40000000 && lp.width == 0 && lp.weight > 0.0f) {
                if (isExactly) {
                    this.mTotalLength += lp.leftMargin + lp.rightMargin;
                } else {
                    totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + lp.leftMargin + lp.rightMargin);
                }
                if (baselineAligned) {
                    int freeSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    child.measure(freeSpec, freeSpec);
                }
            } else {
                int oldWidth = Integer.MIN_VALUE;
                if (lp.width == 0 && lp.weight > 0.0f) {
                    oldWidth = 0;
                    lp.width = -2;
                }
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, totalWeight == 0.0f ? this.mTotalLength : 0, heightMeasureSpec, 0);
                if (oldWidth != Integer.MIN_VALUE) {
                    lp.width = oldWidth;
                }
                int childWidth = child.getMeasuredWidth();
                if (isExactly) {
                    this.mTotalLength += childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength2 = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength2, totalLength2 + childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
                }
                if (useLargestChild) {
                    largestChildWidth = Math.max(childWidth, largestChildWidth);
                }
            }
            boolean matchHeightLocally = false;
            if (heightMode != 0x40000000 && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + margin;
            if (Build.VERSION.SDK_INT >= 11) {
                childState |= child.getMeasuredState();
            }
            if (baselineAligned && (childBaseline = child.getBaseline()) != -1) {
                int gravity = (lp.gravity < 0 ? this.mGravity : lp.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            maxHeight = Math.max(maxHeight, childHeight);
            boolean bl = allFillParent = allFillParent && lp.height == -1;
            if (lp.weight > 0.0f) {
                weightedMaxHeight = Math.max(weightedMaxHeight, matchHeightLocally ? margin : childHeight);
            } else {
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(count)) {
            this.mTotalLength += this.mDividerWidth;
        }
        if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
            int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
            int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
            maxHeight = Math.max(maxHeight, ascent + descent);
        }
        if (useLargestChild && (widthMode == Integer.MIN_VALUE || widthMode == 0)) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                View child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                if (isExactly) {
                    this.mTotalLength += largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                    continue;
                }
                totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
        int widthSize = this.mTotalLength;
        widthSize = Math.max(widthSize, this.getSuggestedMinimumWidth());
        int widthSizeAndState = LinearLayout.resolveSizeAndState(widthSize, widthMeasureSpec, 0);
        int delta = (widthSize = widthSizeAndState & 0xFFFFFF) - this.mTotalLength;
        if (delta != 0 && totalWeight > 0.0f) {
            float weightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            maxAscent[3] = -1;
            maxAscent[2] = -1;
            maxAscent[1] = -1;
            maxAscent[0] = -1;
            maxDescent[3] = -1;
            maxDescent[2] = -1;
            maxDescent[1] = -1;
            maxDescent[0] = -1;
            maxHeight = -1;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                int childBaseline;
                View child = this.getVirtualChildAt(i2);
                if (child == null || child.getVisibility() == 8) continue;
                LinearLayout.LayoutParams lp2 = (LinearLayout.LayoutParams)child.getLayoutParams();
                float childExtra = lp2.weight;
                if (childExtra > 0.0f) {
                    int share = (int)(childExtra * (float)delta / weightSum);
                    weightSum -= childExtra;
                    delta -= share;
                    int childHeightMeasureSpec = LinearLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp2.topMargin + lp2.bottomMargin), (int)lp2.height);
                    if (lp2.width != 0 || widthMode != 0x40000000) {
                        int childWidth = child.getMeasuredWidth() + share;
                        if (childWidth < 0) {
                            childWidth = 0;
                        }
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), childHeightMeasureSpec);
                    } else {
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)(share > 0 ? share : 0), (int)0x40000000), childHeightMeasureSpec);
                    }
                    if (Build.VERSION.SDK_INT >= 11) {
                        childState |= child.getMeasuredState() & 0xFF000000;
                    }
                }
                if (isExactly) {
                    this.mTotalLength += child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength3 = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength3, totalLength3 + child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child));
                }
                boolean matchHeightLocally = heightMode != 0x40000000 && lp2.height == -1;
                int margin = lp2.topMargin + lp2.bottomMargin;
                int childHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, childHeight);
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
                boolean bl = allFillParent = allFillParent && lp2.height == -1;
                if (!baselineAligned || (childBaseline = child.getBaseline()) == -1) continue;
                int gravity = (lp2.gravity < 0 ? this.mGravity : lp2.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
            if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
                int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
                int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
                maxHeight = Math.max(maxHeight, ascent + descent);
            }
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, weightedMaxHeight);
            if (useLargestChild && widthMode != 0x40000000) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child = this.getVirtualChildAt(i3);
                    if (child == null || child.getVisibility() == 8) continue;
                    LinearLayout.LayoutParams lp3 = (LinearLayout.LayoutParams)child.getLayoutParams();
                    float childExtra = lp3.weight;
                    if (!(childExtra > 0.0f)) continue;
                    child.measure(View.MeasureSpec.makeMeasureSpec((int)largestChildWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
                }
            }
        }
        if (!allFillParent && heightMode != 0x40000000) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(widthSizeAndState | childState & 0xFF000000, LinearLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        if (matchHeight) {
            this.forceUniformHeight(count, widthMeasureSpec);
        }
    }

    int measureNullChild(int childIndex) {
        return 0;
    }

    void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        int totalLength;
        LinearLayout.LayoutParams lp;
        View child;
        int i;
        this.mTotalLength = 0;
        int maxWidth = 0;
        int childState = 0;
        int alternativeMaxWidth = 0;
        int weightedMaxWidth = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        boolean matchWidth = false;
        int baselineChildIndex = this.mBaselineAlignedChildIndex;
        boolean useLargestChild = this.mUseLargestChild;
        int largestChildHeight = Integer.MIN_VALUE;
        for (i = 0; i < count; ++i) {
            child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            if (this.hasDividerBeforeChildAt(i)) {
                this.mTotalLength += this.mDividerHeight;
            }
            lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            if (heightMode == 0x40000000 && lp.height == 0 && lp.weight > 0.0f) {
                totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
            } else {
                int oldHeight = Integer.MIN_VALUE;
                if (lp.height == 0 && lp.weight > 0.0f) {
                    oldHeight = 0;
                    lp.height = -2;
                }
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, 0, heightMeasureSpec, totalWeight == 0.0f ? this.mTotalLength : 0);
                if (oldHeight != Integer.MIN_VALUE) {
                    lp.height = oldHeight;
                }
                int childHeight = child.getMeasuredHeight();
                int totalLength2 = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength2, totalLength2 + childHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
                if (useLargestChild) {
                    largestChildHeight = Math.max(childHeight, largestChildHeight);
                }
            }
            if (baselineChildIndex >= 0 && baselineChildIndex == i + 1) {
                this.mBaselineChildTop = this.mTotalLength;
            }
            if (i < baselineChildIndex && lp.weight > 0.0f) {
                throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
            }
            boolean matchWidthLocally = false;
            if (widthMode != 0x40000000 && lp.width == -1) {
                matchWidth = true;
                matchWidthLocally = true;
            }
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            if (Build.VERSION.SDK_INT >= 11) {
                childState |= child.getMeasuredState();
            }
            boolean bl = allFillParent = allFillParent && lp.width == -1;
            if (lp.weight > 0.0f) {
                weightedMaxWidth = Math.max(weightedMaxWidth, matchWidthLocally ? margin : measuredWidth);
            } else {
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(count)) {
            this.mTotalLength += this.mDividerHeight;
        }
        if (useLargestChild && (heightMode == Integer.MIN_VALUE || heightMode == 0)) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
        int heightSize = this.mTotalLength;
        heightSize = Math.max(heightSize, this.getSuggestedMinimumHeight());
        int heightSizeAndState = LinearLayout.resolveSizeAndState(heightSize, heightMeasureSpec, 0);
        int delta = (heightSize = heightSizeAndState & 0xFFFFFF) - this.mTotalLength;
        if (delta != 0 && totalWeight > 0.0f) {
            float weightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                View child2 = this.getVirtualChildAt(i2);
                if (child2.getVisibility() == 8) continue;
                LinearLayout.LayoutParams lp2 = (LinearLayout.LayoutParams)child2.getLayoutParams();
                float childExtra = lp2.weight;
                if (childExtra > 0.0f) {
                    int share = (int)(childExtra * (float)delta / weightSum);
                    weightSum -= childExtra;
                    delta -= share;
                    int childWidthMeasureSpec = LinearLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp2.leftMargin + lp2.rightMargin), (int)lp2.width);
                    if (lp2.height != 0 || heightMode != 0x40000000) {
                        int childHeight = child2.getMeasuredHeight() + share;
                        if (childHeight < 0) {
                            childHeight = 0;
                        }
                        child2.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000));
                    } else {
                        child2.measure(childWidthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)(share > 0 ? share : 0), (int)0x40000000));
                    }
                    if (Build.VERSION.SDK_INT >= 11) {
                        childState |= child2.getMeasuredState() & 0xFFFFFF00;
                    }
                }
                int margin = lp2.leftMargin + lp2.rightMargin;
                int measuredWidth = child2.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode != 0x40000000 && lp2.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp2.width == -1;
                int totalLength3 = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength3, totalLength3 + child2.getMeasuredHeight() + lp2.topMargin + lp2.bottomMargin + this.getNextLocationOffset(child2));
            }
            this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, weightedMaxWidth);
            if (useLargestChild && heightMode != 0x40000000) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child3 = this.getVirtualChildAt(i3);
                    if (child3 == null || child3.getVisibility() == 8) continue;
                    LinearLayout.LayoutParams lp3 = (LinearLayout.LayoutParams)child3.getLayoutParams();
                    float childExtra = lp3.weight;
                    if (!(childExtra > 0.0f)) continue;
                    child3.measure(View.MeasureSpec.makeMeasureSpec((int)child3.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)largestChildHeight, (int)0x40000000));
                }
            }
        }
        if (!allFillParent && widthMode != 0x40000000) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(LinearLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), heightSizeAndState);
        if (matchWidth) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawDividersVertical(canvas);
        } else {
            this.drawDividersHorizontal(canvas);
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)LinearLayout.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)LinearLayout.class.getName());
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mOrientation == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOrientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setBaselineAligned(boolean baselineAligned) {
        this.mBaselineAligned = baselineAligned;
    }

    public void setBaselineAlignedChildIndex(int i) {
        if (i < 0 || i >= this.getChildCount()) {
            throw new IllegalArgumentException("base aligned child index out of range (0, " + this.getChildCount() + ")");
        }
        this.mBaselineAlignedChildIndex = i;
    }

    private void setChildFrame(View child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    public void setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mDividerHeight = divider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.setWillNotDraw(divider == null);
        this.requestLayout();
    }

    public void setDividerPadding(int padding) {
        this.mDividerPadding = padding;
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 0x800007;
        if ((this.mGravity & 0x800007) != gravity) {
            this.mGravity = this.mGravity & 0xFF7FFFF8 | gravity;
            this.requestLayout();
        }
    }

    public void setMeasureWithLargestChildEnabled(boolean enabled) {
        this.mUseLargestChild = enabled;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.requestLayout();
        }
    }

    public void setShowDividers(int showDividers) {
        if (showDividers != this.mShowDividers) {
            this.requestLayout();
        }
        this.mShowDividers = showDividers;
    }

    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    public void setWeightSum(float weightSum) {
        this.mWeightSum = Math.max(0.0f, weightSum);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }
}

