/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import java.util.ArrayList;
import java.util.Locale;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.internal.NumberPickerEditText;
import org.holoeverywhere.internal._View;
import org.holoeverywhere.widget.LinearLayout;
import org.holoeverywhere.widget.Scroller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberPicker
extends LinearLayout {
    private static final int DEFAULT_LAYOUT_RESOURCE_ID = R.layout.number_picker_with_selector_wheel;
    private static final long DEFAULT_LONG_PRESS_UPDATE_INTERVAL = 300L;
    private static final char[] DIGIT_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final int FOCUSABLES_ACCESSIBILITY = 2;
    private static final int SELECTOR_ADJUSTMENT_DURATION_MILLIS = 800;
    private static final int SELECTOR_MAX_FLING_VELOCITY_ADJUSTMENT = 8;
    private static final int SELECTOR_WHEEL_ITEM_COUNT = 3;
    private static final int SELECTOR_WHELL_MIDDLE_ITEM_INDEX = 1;
    private static final int SIZE_UNSPECIFIED = -1;
    private static final int SNAP_SCROLL_DURATION = 300;
    private static final float TOP_AND_BOTTOM_FADING_EDGE_STRENGTH = 0.9f;
    public static final Formatter TWO_DIGIT_FORMATTER = new Formatter(){
        final Object[] mArgs = new Object[1];
        final StringBuilder mBuilder = new StringBuilder();
        final java.util.Formatter mFmt = new java.util.Formatter(this.mBuilder, Locale.US);

        public String format(int value) {
            this.mArgs[0] = value;
            this.mBuilder.delete(0, this.mBuilder.length());
            this.mFmt.format("%02d", this.mArgs);
            return this.mFmt.toString();
        }
    };
    private static final int UNSCALED_DEFAULT_SELECTION_DIVIDER_HEIGHT = 2;
    private static final int UNSCALED_DEFAULT_SELECTION_DIVIDERS_DISTANCE = 48;
    private final Scroller mAdjustScroller;
    private BeginSoftInputOnLongPressCommand mBeginSoftInputOnLongPressCommand;
    private int mBottomSelectionDividerBottom;
    private ChangeCurrentByOneFromLongPressCommand mChangeCurrentByOneFromLongPressCommand;
    private final boolean mComputeMaxWidth;
    private int mCurrentScrollOffset;
    private final ImageButton mDecrementButton;
    private boolean mDecrementVirtualButtonPressed;
    private String[] mDisplayedValues;
    private final Scroller mFlingScroller;
    private Formatter mFormatter;
    private final boolean mHasSelectorWheel;
    private final ImageButton mIncrementButton;
    private boolean mIncrementVirtualButtonPressed;
    private boolean mIngonreMoveEvents;
    private int mInitialScrollOffset = Integer.MIN_VALUE;
    private final NumberPickerEditText mInputText;
    private long mLastDownEventTime;
    private float mLastDownEventY;
    private float mLastDownOrMoveEventY;
    private long mLongPressUpdateInterval = 300L;
    private final int mMaxHeight;
    private int mMaximumFlingVelocity;
    private int mMaxValue;
    private int mMaxWidth;
    private final int mMinHeight;
    private int mMinimumFlingVelocity;
    private int mMinValue;
    private final int mMinWidth;
    private OnScrollListener mOnScrollListener;
    private OnValueChangeListener mOnValueChangeListener;
    private final PressedStateHelper mPressedStateHelper;
    private int mPreviousScrollerY;
    private int mScrollState = 0;
    private final Drawable mSelectionDivider;
    private final int mSelectionDividerHeight;
    private final int mSelectionDividersDistance;
    private int mSelectorElementHeight;
    private final SparseArray<String> mSelectorIndexToStringCache = new SparseArray();
    private final int[] mSelectorIndices = new int[3];
    private int mSelectorTextGapHeight;
    private final Paint mSelectorWheelPaint;
    private SetSelectionCommand mSetSelectionCommand;
    private boolean mShowSoftInputOnTap;
    private final int mSolidColor;
    private final int mTextSize;
    private int mTopSelectionDividerTop;
    private int mTouchSlop;
    private int mValue;
    private VelocityTracker mVelocityTracker;
    private final Drawable mVirtualButtonPressedDrawable;
    private boolean mWrapSelectorWheel;

    public NumberPicker(Context context) {
        this(context, null);
    }

    public NumberPicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.numberPickerStyle);
    }

    @SuppressLint(value={"NewApi"})
    public NumberPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.NumberPicker, defStyle, R.style.Holo_NumberPicker);
        int layoutResId = attributesArray.getResourceId(2, DEFAULT_LAYOUT_RESOURCE_ID);
        this.mHasSelectorWheel = layoutResId == DEFAULT_LAYOUT_RESOURCE_ID;
        this.mSolidColor = attributesArray.getColor(11, 0);
        this.mSelectionDivider = attributesArray.getDrawable(8);
        int defSelectionDividerHeight = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mSelectionDividerHeight = attributesArray.getDimensionPixelSize(9, defSelectionDividerHeight);
        int defSelectionDividerDistance = (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mSelectionDividersDistance = attributesArray.getDimensionPixelSize(10, defSelectionDividerDistance);
        this.mMinHeight = attributesArray.getDimensionPixelSize(6, -1);
        this.mMaxHeight = attributesArray.getDimensionPixelSize(4, -1);
        if (this.mMinHeight != -1 && this.mMaxHeight != -1 && this.mMinHeight > this.mMaxHeight) {
            throw new IllegalArgumentException("minHeight > maxHeight");
        }
        this.mMinWidth = attributesArray.getDimensionPixelSize(5, -1);
        this.mMaxWidth = attributesArray.getDimensionPixelSize(3, -1);
        if (this.mMinWidth != -1 && this.mMaxWidth != -1 && this.mMinWidth > this.mMaxWidth) {
            throw new IllegalArgumentException("minWidth > maxWidth");
        }
        this.mComputeMaxWidth = this.mMaxWidth == -1;
        this.mVirtualButtonPressedDrawable = attributesArray.getDrawable(12);
        attributesArray.recycle();
        this.mPressedStateHelper = new PressedStateHelper();
        this.setWillNotDraw(!this.mHasSelectorWheel);
        LayoutInflater.inflate(context, layoutResId, (ViewGroup)this, true);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                NumberPicker.this.hideSoftInput();
                NumberPicker.this.mInputText.clearFocus();
                if (v.getId() == R.id.increment) {
                    NumberPicker.this.changeValueByOne(true);
                } else {
                    NumberPicker.this.changeValueByOne(false);
                }
            }
        };
        View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                NumberPicker.this.hideSoftInput();
                NumberPicker.this.mInputText.clearFocus();
                if (v.getId() == R.id.increment) {
                    NumberPicker.this.postChangeCurrentByOneFromLongPress(true, 0L);
                } else {
                    NumberPicker.this.postChangeCurrentByOneFromLongPress(false, 0L);
                }
                return true;
            }
        };
        if (!this.mHasSelectorWheel) {
            this.mIncrementButton = (ImageButton)this.findViewById(R.id.increment);
            if (this.mIncrementButton != null) {
                this.mIncrementButton.setOnClickListener(onClickListener);
                this.mIncrementButton.setOnLongClickListener(onLongClickListener);
            }
        } else {
            this.mIncrementButton = null;
        }
        if (!this.mHasSelectorWheel) {
            this.mDecrementButton = (ImageButton)this.findViewById(R.id.decrement);
            if (this.mDecrementButton != null) {
                this.mDecrementButton.setOnClickListener(onClickListener);
                this.mDecrementButton.setOnLongClickListener(onLongClickListener);
            }
        } else {
            this.mDecrementButton = null;
        }
        this.mInputText = (NumberPickerEditText)this.findViewById(R.id.numberpicker_input);
        this.mInputText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    NumberPicker.this.mInputText.selectAll();
                } else {
                    NumberPicker.this.mInputText.setSelection(0, 0);
                    NumberPicker.this.validateInputTextView(NumberPicker.this.mInputText);
                }
            }
        });
        this.mInputText.setFilters(new InputFilter[]{new InputTextFilter()});
        this.mInputText.setRawInputType(2);
        this.mInputText.setImeOptions(6);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity() / 8;
        this.mTextSize = (int)this.mInputText.getTextSize();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize((float)this.mTextSize);
        paint.setTypeface(this.mInputText.getTypeface());
        ColorStateList colors = this.mInputText.getTextColors();
        int color2 = colors.getColorForState(View.ENABLED_STATE_SET, -1);
        paint.setColor(color2);
        this.mSelectorWheelPaint = paint;
        this.mFlingScroller = new Scroller(this.getContext(), null, true);
        this.mAdjustScroller = new Scroller(this.getContext(), (Interpolator)new DecelerateInterpolator(2.5f));
        this.updateInputTextView();
        if (Build.VERSION.SDK_INT >= 16 && this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if ((focusableMode & 2) == 2) {
            views.add((View)this);
            return;
        }
        super.addFocusables(views, direction, focusableMode);
    }

    private void changeValueByOne(boolean increment) {
        if (this.mHasSelectorWheel) {
            this.mInputText.setVisibility(4);
            if (!this.moveToFinalScrollerPosition(this.mFlingScroller)) {
                this.moveToFinalScrollerPosition(this.mAdjustScroller);
            }
            this.mPreviousScrollerY = 0;
            if (increment) {
                this.mFlingScroller.startScroll(0, 0, 0, -this.mSelectorElementHeight, 300);
            } else {
                this.mFlingScroller.startScroll(0, 0, 0, this.mSelectorElementHeight, 300);
            }
            this.invalidate();
        } else if (increment) {
            this.setValueInternal(this.mValue + 1, true);
        } else {
            this.setValueInternal(this.mValue - 1, true);
        }
    }

    public void computeScroll() {
        Scroller scroller = this.mFlingScroller;
        if (scroller.isFinished() && (scroller = this.mAdjustScroller).isFinished()) {
            return;
        }
        scroller.computeScrollOffset();
        int currentScrollerY = scroller.getCurrY();
        if (this.mPreviousScrollerY == 0) {
            this.mPreviousScrollerY = scroller.getStartY();
        }
        this.scrollBy(0, currentScrollerY - this.mPreviousScrollerY);
        this.mPreviousScrollerY = currentScrollerY;
        if (scroller.isFinished()) {
            this.onScrollerFinished(scroller);
        } else {
            this.invalidate();
        }
    }

    private void decrementSelectorIndices(int[] selectorIndices) {
        for (int i = selectorIndices.length - 1; i > 0; --i) {
            selectorIndices[i] = selectorIndices[i - 1];
        }
        int nextScrollSelectorIndex = selectorIndices[1] - 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex < this.mMinValue) {
            nextScrollSelectorIndex = this.mMaxValue;
        }
        selectorIndices[0] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    @SuppressLint(value={"NewApi"})
    protected boolean dispatchHoverEvent(MotionEvent event) {
        if (!this.mHasSelectorWheel) {
            return super.dispatchHoverEvent(event);
        }
        if (((AccessibilityManager)this.getContext().getSystemService("accessibility")).isEnabled()) {
            switch (event.getAction() & 0xFF) {
                case 9: {
                    this.sendAccessibilityEvent(128);
                    if (Build.VERSION.SDK_INT < 16) break;
                    this.performAccessibilityAction(64, null);
                    break;
                }
                case 7: {
                    this.sendAccessibilityEvent(256);
                    this.sendAccessibilityEvent(128);
                    if (Build.VERSION.SDK_INT < 16) break;
                    this.performAccessibilityAction(64, null);
                    break;
                }
                case 10: {
                    this.sendAccessibilityEvent(256);
                }
            }
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 23: 
            case 66: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean dispatchTrackballEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 1: 
            case 3: {
                this.removeAllCallbacks();
            }
        }
        return super.dispatchTrackballEvent(event);
    }

    private void ensureCachedScrollSelectorValue(int selectorIndex) {
        SparseArray<String> cache = this.mSelectorIndexToStringCache;
        String scrollSelectorValue = (String)cache.get(selectorIndex);
        if (scrollSelectorValue != null) {
            return;
        }
        if (selectorIndex < this.mMinValue || selectorIndex > this.mMaxValue) {
            scrollSelectorValue = "";
        } else if (this.mDisplayedValues != null) {
            int displayedValueIndex = selectorIndex - this.mMinValue;
            scrollSelectorValue = this.mDisplayedValues[displayedValueIndex];
        } else {
            scrollSelectorValue = this.formatNumber(selectorIndex);
        }
        cache.put(selectorIndex, (Object)scrollSelectorValue);
    }

    private boolean ensureScrollWheelAdjusted() {
        int deltaY = this.mInitialScrollOffset - this.mCurrentScrollOffset;
        if (deltaY != 0) {
            this.mPreviousScrollerY = 0;
            if (Math.abs(deltaY) > this.mSelectorElementHeight / 2) {
                deltaY += deltaY > 0 ? -this.mSelectorElementHeight : this.mSelectorElementHeight;
            }
            this.mAdjustScroller.startScroll(0, 0, 0, deltaY, 800);
            this.invalidate();
            return true;
        }
        return false;
    }

    private void fling(int velocityY) {
        this.mPreviousScrollerY = 0;
        if (velocityY > 0) {
            this.mFlingScroller.fling(0, 0, 0, velocityY, 0, 0, 0, Integer.MAX_VALUE);
        } else {
            this.mFlingScroller.fling(0, Integer.MAX_VALUE, 0, velocityY, 0, 0, 0, Integer.MAX_VALUE);
        }
        this.invalidate();
    }

    private String formatNumber(int value) {
        return this.mFormatter != null ? this.mFormatter.format(value) : String.valueOf(value);
    }

    protected float getBottomFadingEdgeStrength() {
        return 0.9f;
    }

    public String[] getDisplayedValues() {
        return this.mDisplayedValues;
    }

    public NumberPickerEditText getInputField() {
        return this.mInputText;
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    private int getSelectedPos(String value) {
        if (this.mDisplayedValues != null) {
            for (int i = 0; i < this.mDisplayedValues.length; ++i) {
                value = value.toLowerCase();
                if (!this.mDisplayedValues[i].toLowerCase().startsWith(value)) continue;
                return this.mMinValue + i;
            }
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return this.mMinValue;
        }
    }

    public int getSolidColor() {
        return this.mSolidColor;
    }

    protected float getTopFadingEdgeStrength() {
        return 0.9f;
    }

    public int getValue() {
        return this.mValue;
    }

    private int getWrappedSelectorIndex(int selectorIndex) {
        if (selectorIndex > this.mMaxValue) {
            return this.mMinValue + (selectorIndex - this.mMaxValue) % (this.mMaxValue - this.mMinValue) - 1;
        }
        if (selectorIndex < this.mMinValue) {
            return this.mMaxValue - (this.mMinValue - selectorIndex) % (this.mMaxValue - this.mMinValue) + 1;
        }
        return selectorIndex;
    }

    public boolean getWrapSelectorWheel() {
        return this.mWrapSelectorWheel;
    }

    private void hideSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null && inputMethodManager.isActive((View)this.mInputText)) {
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            if (this.mHasSelectorWheel) {
                this.mInputText.setVisibility(4);
            }
        }
    }

    private void incrementSelectorIndices(int[] selectorIndices) {
        for (int i = 0; i < selectorIndices.length - 1; ++i) {
            selectorIndices[i] = selectorIndices[i + 1];
        }
        int nextScrollSelectorIndex = selectorIndices[selectorIndices.length - 2] + 1;
        if (this.mWrapSelectorWheel && nextScrollSelectorIndex > this.mMaxValue) {
            nextScrollSelectorIndex = this.mMinValue;
        }
        selectorIndices[selectorIndices.length - 1] = nextScrollSelectorIndex;
        this.ensureCachedScrollSelectorValue(nextScrollSelectorIndex);
    }

    private void initializeFadingEdges() {
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength((this.getBottom() - this.getTop() - this.mTextSize) / 2);
    }

    private void initializeSelectorWheel() {
        this.initializeSelectorWheelIndices();
        int[] selectorIndices = this.mSelectorIndices;
        int totalTextHeight = selectorIndices.length * this.mTextSize;
        float totalTextGapHeight = this.getBottom() - this.getTop() - totalTextHeight;
        float textGapCount = selectorIndices.length;
        this.mSelectorTextGapHeight = (int)(totalTextGapHeight / textGapCount + 0.5f);
        this.mSelectorElementHeight = this.mTextSize + this.mSelectorTextGapHeight;
        int editTextTextPosition = this.mInputText.getBaseline() + this.mInputText.getTop();
        this.mCurrentScrollOffset = this.mInitialScrollOffset = editTextTextPosition - this.mSelectorElementHeight * 1;
        this.updateInputTextView();
    }

    private void initializeSelectorWheelIndices() {
        this.mSelectorIndexToStringCache.clear();
        int[] selectorIndices = this.mSelectorIndices;
        int current = this.getValue();
        for (int i = 0; i < this.mSelectorIndices.length; ++i) {
            int selectorIndex = current + i - 1;
            if (this.mWrapSelectorWheel) {
                selectorIndex = this.getWrappedSelectorIndex(selectorIndex);
            }
            selectorIndices[i] = selectorIndex;
            this.ensureCachedScrollSelectorValue(selectorIndices[i]);
        }
    }

    private int makeMeasureSpec(int measureSpec, int maxSize) {
        if (maxSize == -1) {
            return measureSpec;
        }
        int size = View.MeasureSpec.getSize((int)measureSpec);
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        switch (mode) {
            case 0x40000000: {
                return measureSpec;
            }
            case -2147483648: {
                return View.MeasureSpec.makeMeasureSpec((int)Math.min(size, maxSize), (int)0x40000000);
            }
            case 0: {
                return View.MeasureSpec.makeMeasureSpec((int)maxSize, (int)0x40000000);
            }
        }
        throw new IllegalArgumentException("Unknown measure mode: " + mode);
    }

    private boolean moveToFinalScrollerPosition(Scroller scroller) {
        scroller.forceFinished(true);
        int amountToScroll = scroller.getFinalY() - scroller.getCurrY();
        int futureScrollOffset = (this.mCurrentScrollOffset + amountToScroll) % this.mSelectorElementHeight;
        int overshootAdjustment = this.mInitialScrollOffset - futureScrollOffset;
        if (overshootAdjustment != 0) {
            if (Math.abs(overshootAdjustment) > this.mSelectorElementHeight / 2) {
                overshootAdjustment = overshootAdjustment > 0 ? (overshootAdjustment -= this.mSelectorElementHeight) : (overshootAdjustment += this.mSelectorElementHeight);
            }
            this.scrollBy(0, amountToScroll += overshootAdjustment);
            return true;
        }
        return false;
    }

    private void notifyChange(int previous, int current) {
        if (this.mOnValueChangeListener != null) {
            this.mOnValueChangeListener.onValueChange(this, previous, this.mValue);
        }
    }

    protected void onDetachedFromWindow() {
        this.removeAllCallbacks();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (!this.mHasSelectorWheel) {
            super.onDraw(canvas);
            return;
        }
        float x = (this.getRight() - this.getLeft()) / 2;
        float y = this.mCurrentScrollOffset;
        if (this.mVirtualButtonPressedDrawable != null && this.mScrollState == 0) {
            if (this.mDecrementVirtualButtonPressed) {
                this.mVirtualButtonPressedDrawable.setState(_View.PRESSED_STATE_SET);
                this.mVirtualButtonPressedDrawable.setBounds(0, 0, this.getRight(), this.mTopSelectionDividerTop);
                this.mVirtualButtonPressedDrawable.draw(canvas);
            }
            if (this.mIncrementVirtualButtonPressed) {
                this.mVirtualButtonPressedDrawable.setState(_View.PRESSED_STATE_SET);
                this.mVirtualButtonPressedDrawable.setBounds(0, this.mBottomSelectionDividerBottom, this.getRight(), this.getBottom());
                this.mVirtualButtonPressedDrawable.draw(canvas);
            }
        }
        int[] selectorIndices = this.mSelectorIndices;
        for (int i = 0; i < selectorIndices.length; ++i) {
            int selectorIndex = selectorIndices[i];
            String scrollSelectorValue = (String)this.mSelectorIndexToStringCache.get(selectorIndex);
            if (i != 1 || this.mInputText.getVisibility() != 0) {
                canvas.drawText(scrollSelectorValue, x, y, this.mSelectorWheelPaint);
            }
            y += (float)this.mSelectorElementHeight;
        }
        if (this.mSelectionDivider != null) {
            int topOfTopDivider = this.mTopSelectionDividerTop;
            int bottomOfTopDivider = topOfTopDivider + this.mSelectionDividerHeight;
            this.mSelectionDivider.setBounds(0, topOfTopDivider, this.getRight(), bottomOfTopDivider);
            this.mSelectionDivider.draw(canvas);
            int bottomOfBottomDivider = this.mBottomSelectionDividerBottom;
            int topOfBottomDivider = bottomOfBottomDivider - this.mSelectionDividerHeight;
            this.mSelectionDivider.setBounds(0, topOfBottomDivider, this.getRight(), bottomOfBottomDivider);
            this.mSelectionDivider.draw(canvas);
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)NumberPicker.class.getName());
        event.setScrollable(true);
        event.setScrollY((this.mMinValue + this.mValue) * this.mSelectorElementHeight);
        event.setMaxScrollY((this.mMaxValue - this.mMinValue) * this.mSelectorElementHeight);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.mHasSelectorWheel || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.removeAllCallbacks();
                this.mInputText.setVisibility(4);
                this.mLastDownOrMoveEventY = this.mLastDownEventY = event.getY();
                this.mLastDownEventTime = event.getEventTime();
                this.mIngonreMoveEvents = false;
                this.mShowSoftInputOnTap = false;
                if (this.mLastDownEventY < (float)this.mTopSelectionDividerTop) {
                    if (this.mScrollState == 0) {
                        this.mPressedStateHelper.buttonPressDelayed(2);
                    }
                } else if (this.mLastDownEventY > (float)this.mBottomSelectionDividerBottom && this.mScrollState == 0) {
                    this.mPressedStateHelper.buttonPressDelayed(1);
                }
                this.getParent().requestDisallowInterceptTouchEvent(true);
                if (!this.mFlingScroller.isFinished()) {
                    this.mFlingScroller.forceFinished(true);
                    this.mAdjustScroller.forceFinished(true);
                    this.onScrollStateChange(0);
                } else if (!this.mAdjustScroller.isFinished()) {
                    this.mFlingScroller.forceFinished(true);
                    this.mAdjustScroller.forceFinished(true);
                } else if (this.mLastDownEventY < (float)this.mTopSelectionDividerTop) {
                    this.hideSoftInput();
                    this.postChangeCurrentByOneFromLongPress(false, ViewConfiguration.getLongPressTimeout());
                } else if (this.mLastDownEventY > (float)this.mBottomSelectionDividerBottom) {
                    this.hideSoftInput();
                    this.postChangeCurrentByOneFromLongPress(true, ViewConfiguration.getLongPressTimeout());
                } else {
                    this.mShowSoftInputOnTap = true;
                    this.postBeginSoftInputOnLongPressCommand();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!this.mHasSelectorWheel) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        int msrdWdth = this.getMeasuredWidth();
        int msrdHght = this.getMeasuredHeight();
        int inptTxtMsrdWdth = this.mInputText.getMeasuredWidth();
        int inptTxtMsrdHght = this.mInputText.getMeasuredHeight();
        int inptTxtLeft = (msrdWdth - inptTxtMsrdWdth) / 2;
        int inptTxtTop = (msrdHght - inptTxtMsrdHght) / 2;
        int inptTxtRight = inptTxtLeft + inptTxtMsrdWdth;
        int inptTxtBottom = inptTxtTop + inptTxtMsrdHght;
        this.mInputText.layout(inptTxtLeft, inptTxtTop, inptTxtRight, inptTxtBottom);
        if (changed) {
            this.initializeSelectorWheel();
            this.initializeFadingEdges();
            this.mTopSelectionDividerTop = (this.getHeight() - this.mSelectionDividersDistance) / 2 - this.mSelectionDividerHeight;
            this.mBottomSelectionDividerBottom = this.mTopSelectionDividerTop + 2 * this.mSelectionDividerHeight + this.mSelectionDividersDistance;
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.mHasSelectorWheel) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int newWidthMeasureSpec = this.makeMeasureSpec(widthMeasureSpec, this.mMaxWidth);
        int newHeightMeasureSpec = this.makeMeasureSpec(heightMeasureSpec, this.mMaxHeight);
        super.onMeasure(newWidthMeasureSpec, newHeightMeasureSpec);
        int widthSize = this.resolveSizeAndStateRespectingMinSize(this.mMinWidth, this.getMeasuredWidth(), widthMeasureSpec);
        int heightSize = this.resolveSizeAndStateRespectingMinSize(this.mMinHeight, this.getMeasuredHeight(), heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private void onScrollerFinished(Scroller scroller) {
        if (scroller == this.mFlingScroller) {
            if (!this.ensureScrollWheelAdjusted()) {
                this.updateInputTextView();
            }
            this.onScrollStateChange(0);
        } else if (this.mScrollState != 1) {
            this.updateInputTextView();
        }
    }

    private void onScrollStateChange(int scrollState) {
        if (this.mScrollState == scrollState) {
            return;
        }
        this.mScrollState = scrollState;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChange(this, scrollState);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.mHasSelectorWheel) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        switch (event.getAction() & 0xFF) {
            case 2: {
                if (this.mIngonreMoveEvents) break;
                float currentMoveY = event.getY();
                if (this.mScrollState != 1) {
                    int deltaDownY = (int)Math.abs(currentMoveY - this.mLastDownEventY);
                    if (deltaDownY > this.mTouchSlop) {
                        this.removeAllCallbacks();
                        this.onScrollStateChange(1);
                    }
                } else {
                    int deltaMoveY = (int)(currentMoveY - this.mLastDownOrMoveEventY);
                    this.scrollBy(0, deltaMoveY);
                    this.invalidate();
                }
                this.mLastDownOrMoveEventY = currentMoveY;
                break;
            }
            case 1: {
                this.removeBeginSoftInputCommand();
                this.removeChangeCurrentByOneFromLongPress();
                this.mPressedStateHelper.cancel();
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumFlingVelocity);
                int initialVelocity = (int)velocityTracker.getYVelocity();
                if (Math.abs(initialVelocity) > this.mMinimumFlingVelocity) {
                    this.fling(initialVelocity);
                    this.onScrollStateChange(2);
                } else {
                    int eventY = (int)event.getY();
                    int deltaMoveY = (int)Math.abs((float)eventY - this.mLastDownEventY);
                    long deltaTime = event.getEventTime() - this.mLastDownEventTime;
                    if (deltaMoveY <= this.mTouchSlop && deltaTime < (long)ViewConfiguration.getTapTimeout()) {
                        if (this.mShowSoftInputOnTap) {
                            this.mShowSoftInputOnTap = false;
                            this.showSoftInput();
                        } else {
                            int selectorIndexOffset = eventY / this.mSelectorElementHeight - 1;
                            if (selectorIndexOffset > 0) {
                                this.changeValueByOne(true);
                                this.mPressedStateHelper.buttonTapped(1);
                            } else if (selectorIndexOffset < 0) {
                                this.changeValueByOne(false);
                                this.mPressedStateHelper.buttonTapped(2);
                            }
                        }
                    } else {
                        this.ensureScrollWheelAdjusted();
                    }
                    this.onScrollStateChange(0);
                }
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    private void postBeginSoftInputOnLongPressCommand() {
        if (this.mBeginSoftInputOnLongPressCommand == null) {
            this.mBeginSoftInputOnLongPressCommand = new BeginSoftInputOnLongPressCommand();
        } else {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
        this.postDelayed(this.mBeginSoftInputOnLongPressCommand, ViewConfiguration.getLongPressTimeout());
    }

    private void postChangeCurrentByOneFromLongPress(boolean increment, long delayMillis) {
        if (this.mChangeCurrentByOneFromLongPressCommand == null) {
            this.mChangeCurrentByOneFromLongPressCommand = new ChangeCurrentByOneFromLongPressCommand();
        } else {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        this.mChangeCurrentByOneFromLongPressCommand.setStep(increment);
        this.postDelayed(this.mChangeCurrentByOneFromLongPressCommand, delayMillis);
    }

    private void postSetSelectionCommand(int selectionStart, int selectionEnd) {
        if (this.mSetSelectionCommand == null) {
            this.mSetSelectionCommand = new SetSelectionCommand();
        } else {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
        this.mSetSelectionCommand.mSelectionStart = selectionStart;
        this.mSetSelectionCommand.mSelectionEnd = selectionEnd;
        this.post(this.mSetSelectionCommand);
    }

    private void removeAllCallbacks() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
        if (this.mSetSelectionCommand != null) {
            this.removeCallbacks(this.mSetSelectionCommand);
        }
        if (this.mBeginSoftInputOnLongPressCommand != null) {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
        this.mPressedStateHelper.cancel();
    }

    private void removeBeginSoftInputCommand() {
        if (this.mBeginSoftInputOnLongPressCommand != null) {
            this.removeCallbacks(this.mBeginSoftInputOnLongPressCommand);
        }
    }

    private void removeChangeCurrentByOneFromLongPress() {
        if (this.mChangeCurrentByOneFromLongPressCommand != null) {
            this.removeCallbacks(this.mChangeCurrentByOneFromLongPressCommand);
        }
    }

    private int resolveSizeAndStateRespectingMinSize(int minSize, int measuredSize, int measureSpec) {
        if (minSize != -1) {
            int desiredWidth = Math.max(minSize, measuredSize);
            return _View.supportResolveSizeAndState(desiredWidth, measureSpec, 0);
        }
        return measuredSize;
    }

    public void scrollBy(int x, int y) {
        int[] selectorIndices = this.mSelectorIndices;
        if (!this.mWrapSelectorWheel && y > 0 && selectorIndices[1] <= this.mMinValue) {
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
            return;
        }
        if (!this.mWrapSelectorWheel && y < 0 && selectorIndices[1] >= this.mMaxValue) {
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
            return;
        }
        this.mCurrentScrollOffset += y;
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset > this.mSelectorTextGapHeight) {
            this.mCurrentScrollOffset -= this.mSelectorElementHeight;
            this.decrementSelectorIndices(selectorIndices);
            this.setValueInternal(selectorIndices[1], true);
            if (this.mWrapSelectorWheel || selectorIndices[1] > this.mMinValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
        while (this.mCurrentScrollOffset - this.mInitialScrollOffset < -this.mSelectorTextGapHeight) {
            this.mCurrentScrollOffset += this.mSelectorElementHeight;
            this.incrementSelectorIndices(selectorIndices);
            this.setValueInternal(selectorIndices[1], true);
            if (this.mWrapSelectorWheel || selectorIndices[1] < this.mMaxValue) continue;
            this.mCurrentScrollOffset = this.mInitialScrollOffset;
        }
    }

    public void setDisplayedValues(String[] displayedValues) {
        if (this.mDisplayedValues == displayedValues) {
            return;
        }
        this.mDisplayedValues = displayedValues;
        if (this.mDisplayedValues != null) {
            this.mInputText.setRawInputType(524289);
        } else {
            this.mInputText.setRawInputType(2);
        }
        this.updateInputTextView();
        this.initializeSelectorWheelIndices();
        this.tryComputeMaxWidth();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!this.mHasSelectorWheel) {
            this.mIncrementButton.setEnabled(enabled);
        }
        if (!this.mHasSelectorWheel) {
            this.mDecrementButton.setEnabled(enabled);
        }
        this.mInputText.setEnabled(enabled);
    }

    public void setFormatter(Formatter formatter) {
        if (formatter == this.mFormatter) {
            return;
        }
        this.mFormatter = formatter;
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
    }

    public void setMaxValue(int maxValue) {
        if (this.mMaxValue == maxValue) {
            return;
        }
        if (maxValue < 0) {
            throw new IllegalArgumentException("maxValue must be >= 0");
        }
        this.mMaxValue = maxValue;
        if (this.mMaxValue < this.mValue) {
            this.mValue = this.mMaxValue;
        }
        boolean wrapSelectorWheel = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(wrapSelectorWheel);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    public void setMinValue(int minValue) {
        if (this.mMinValue == minValue) {
            return;
        }
        if (minValue < 0) {
            throw new IllegalArgumentException("minValue must be >= 0");
        }
        this.mMinValue = minValue;
        if (this.mMinValue > this.mValue) {
            this.mValue = this.mMinValue;
        }
        boolean wrapSelectorWheel = this.mMaxValue - this.mMinValue > this.mSelectorIndices.length;
        this.setWrapSelectorWheel(wrapSelectorWheel);
        this.initializeSelectorWheelIndices();
        this.updateInputTextView();
        this.tryComputeMaxWidth();
        this.invalidate();
    }

    public void setOnLongPressUpdateInterval(long intervalMillis) {
        this.mLongPressUpdateInterval = intervalMillis;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }

    public void setOnValueChangedListener(OnValueChangeListener onValueChangedListener) {
        this.mOnValueChangeListener = onValueChangedListener;
    }

    public void setValue(int value) {
        this.setValueInternal(value, false);
    }

    private void setValueInternal(int current, boolean notifyChange) {
        if (this.mValue == current) {
            return;
        }
        if (this.mWrapSelectorWheel) {
            current = this.getWrappedSelectorIndex(current);
        } else {
            current = Math.max(current, this.mMinValue);
            current = Math.min(current, this.mMaxValue);
        }
        int previous = this.mValue;
        this.mValue = current;
        this.updateInputTextView();
        if (notifyChange) {
            this.notifyChange(previous, current);
        }
        this.initializeSelectorWheelIndices();
        this.invalidate();
    }

    public void setWrapSelectorWheel(boolean wrapSelectorWheel) {
        boolean wrappingAllowed;
        boolean bl = wrappingAllowed = this.mMaxValue - this.mMinValue >= this.mSelectorIndices.length;
        if ((!wrapSelectorWheel || wrappingAllowed) && wrapSelectorWheel != this.mWrapSelectorWheel) {
            this.mWrapSelectorWheel = wrapSelectorWheel;
        }
    }

    private void showSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            if (this.mHasSelectorWheel) {
                this.mInputText.setVisibility(0);
            }
            this.mInputText.requestFocus();
            inputMethodManager.showSoftInput((View)this.mInputText, 0);
        }
    }

    private void tryComputeMaxWidth() {
        if (!this.mComputeMaxWidth) {
            return;
        }
        int maxTextWidth = 0;
        if (this.mDisplayedValues == null) {
            float maxDigitWidth = 0.0f;
            for (int i = 0; i <= 9; ++i) {
                float digitWidth = this.mSelectorWheelPaint.measureText(String.valueOf(i));
                if (!(digitWidth > maxDigitWidth)) continue;
                maxDigitWidth = digitWidth;
            }
            int numberOfDigits = 0;
            for (int current = this.mMaxValue; current > 0; current /= 10) {
                ++numberOfDigits;
            }
            maxTextWidth = (int)((float)numberOfDigits * maxDigitWidth);
        } else {
            int valueCount = this.mDisplayedValues.length;
            for (int i = 0; i < valueCount; ++i) {
                float textWidth = this.mSelectorWheelPaint.measureText(this.mDisplayedValues[i]);
                if (!(textWidth > (float)maxTextWidth)) continue;
                maxTextWidth = (int)textWidth;
            }
        }
        if (this.mMaxWidth != (maxTextWidth += this.mInputText.getPaddingLeft() + this.mInputText.getPaddingRight())) {
            this.mMaxWidth = maxTextWidth > this.mMinWidth ? maxTextWidth : this.mMinWidth;
            this.invalidate();
        }
    }

    private boolean updateInputTextView() {
        String text;
        String string2 = text = this.mDisplayedValues == null ? this.formatNumber(this.mValue) : this.mDisplayedValues[this.mValue - this.mMinValue];
        if (!TextUtils.isEmpty((CharSequence)text) && !text.equals(this.mInputText.getText().toString())) {
            this.mInputText.setText(text);
            return true;
        }
        return false;
    }

    private void validateInputTextView(NumberPickerEditText v) {
        String str = String.valueOf(v.getText());
        if (TextUtils.isEmpty((CharSequence)str)) {
            this.updateInputTextView();
        } else {
            int current = this.getSelectedPos(str.toString());
            this.setValueInternal(current, true);
        }
    }

    class SetSelectionCommand
    implements Runnable {
        private int mSelectionEnd;
        private int mSelectionStart;

        SetSelectionCommand() {
        }

        public void run() {
            NumberPicker.this.mInputText.setSelection(this.mSelectionStart, this.mSelectionEnd);
        }
    }

    class PressedStateHelper
    implements Runnable {
        public static final int BUTTON_DECREMENT = 2;
        public static final int BUTTON_INCREMENT = 1;
        private static final int MODE_PRESS = 1;
        private static final int MODE_TAPPED = 2;
        private int mManagedButton;
        private int mMode;

        PressedStateHelper() {
        }

        public void buttonPressDelayed(int button) {
            this.cancel();
            this.mMode = 1;
            this.mManagedButton = button;
            NumberPicker.this.postDelayed(this, ViewConfiguration.getTapTimeout());
        }

        public void buttonTapped(int button) {
            this.cancel();
            this.mMode = 2;
            this.mManagedButton = button;
            NumberPicker.this.post(this);
        }

        public void cancel() {
            this.mMode = 0;
            this.mManagedButton = 0;
            NumberPicker.this.removeCallbacks(this);
            if (NumberPicker.this.mIncrementVirtualButtonPressed) {
                NumberPicker.this.mIncrementVirtualButtonPressed = false;
                NumberPicker.this.invalidate(0, NumberPicker.this.mBottomSelectionDividerBottom, NumberPicker.this.getRight(), NumberPicker.this.getBottom());
            }
            NumberPicker.this.mDecrementVirtualButtonPressed = false;
            if (NumberPicker.this.mDecrementVirtualButtonPressed) {
                NumberPicker.this.invalidate(0, 0, NumberPicker.this.getRight(), NumberPicker.this.mTopSelectionDividerTop);
            }
        }

        public void run() {
            block0 : switch (this.mMode) {
                case 1: {
                    switch (this.mManagedButton) {
                        case 1: {
                            NumberPicker.this.mIncrementVirtualButtonPressed = true;
                            NumberPicker.this.invalidate(0, NumberPicker.this.mBottomSelectionDividerBottom, NumberPicker.this.getRight(), NumberPicker.this.getBottom());
                            break;
                        }
                        case 2: {
                            NumberPicker.this.mDecrementVirtualButtonPressed = true;
                            NumberPicker.this.invalidate(0, 0, NumberPicker.this.getRight(), NumberPicker.this.mTopSelectionDividerTop);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.mManagedButton) {
                        case 1: {
                            if (!NumberPicker.this.mIncrementVirtualButtonPressed) {
                                NumberPicker.this.postDelayed(this, ViewConfiguration.getPressedStateDuration());
                            }
                            NumberPicker.this.mIncrementVirtualButtonPressed = (byte)(NumberPicker.this.mIncrementVirtualButtonPressed ^ 1);
                            NumberPicker.this.invalidate(0, NumberPicker.this.mBottomSelectionDividerBottom, NumberPicker.this.getRight(), NumberPicker.this.getBottom());
                            break block0;
                        }
                        case 2: {
                            if (!NumberPicker.this.mDecrementVirtualButtonPressed) {
                                NumberPicker.this.postDelayed(this, ViewConfiguration.getPressedStateDuration());
                            }
                            NumberPicker.this.mDecrementVirtualButtonPressed = (byte)(NumberPicker.this.mDecrementVirtualButtonPressed ^ 1);
                            NumberPicker.this.invalidate(0, 0, NumberPicker.this.getRight(), NumberPicker.this.mTopSelectionDividerTop);
                        }
                    }
                }
            }
        }
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPicker var1, int var2, int var3);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_FLING = 2;
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;

        public void onScrollStateChange(NumberPicker var1, int var2);
    }

    class InputTextFilter
    extends NumberKeyListener {
        InputTextFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (NumberPicker.this.mDisplayedValues == null) {
                String result;
                CharSequence filtered = super.filter(source, start, end, dest, dstart, dend);
                if (filtered == null) {
                    filtered = source.subSequence(start, end);
                }
                if ("".equals(result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length()))) {
                    return result;
                }
                int val = NumberPicker.this.getSelectedPos(result);
                if (val > NumberPicker.this.mMaxValue) {
                    return "";
                }
                return filtered;
            }
            String filtered = String.valueOf(source.subSequence(start, end));
            if (TextUtils.isEmpty((CharSequence)filtered)) {
                return "";
            }
            String result = String.valueOf(dest.subSequence(0, dstart)) + filtered + dest.subSequence(dend, dest.length());
            String str = String.valueOf(result).toLowerCase();
            for (String val : NumberPicker.this.mDisplayedValues) {
                String valLowerCase = val.toLowerCase();
                if (!valLowerCase.startsWith(str)) continue;
                NumberPicker.this.postSetSelectionCommand(result.length(), val.length());
                return val.subSequence(dstart, val.length());
            }
            return "";
        }

        protected char[] getAcceptedChars() {
            return DIGIT_CHARACTERS;
        }

        public int getInputType() {
            return 1;
        }
    }

    public static interface Formatter {
        public String format(int var1);
    }

    class ChangeCurrentByOneFromLongPressCommand
    implements Runnable {
        private boolean mIncrement;

        ChangeCurrentByOneFromLongPressCommand() {
        }

        public void run() {
            NumberPicker.this.changeValueByOne(this.mIncrement);
            NumberPicker.this.postDelayed(this, NumberPicker.this.mLongPressUpdateInterval);
        }

        private void setStep(boolean increment) {
            this.mIncrement = increment;
        }
    }

    class BeginSoftInputOnLongPressCommand
    implements Runnable {
        BeginSoftInputOnLongPressCommand() {
        }

        public void run() {
            NumberPicker.this.showSoftInput();
            NumberPicker.this.mIngonreMoveEvents = true;
        }
    }
}

