/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import java.util.ArrayList;
import org.holoeverywhere.R;
import org.holoeverywhere.drawable.DrawableCompat;
import org.holoeverywhere.internal._View;
import org.holoeverywhere.util.Pool;
import org.holoeverywhere.util.Poolable;
import org.holoeverywhere.util.PoolableManager;
import org.holoeverywhere.util.Pools;
import org.holoeverywhere.util.ReflectHelper;

public class ProgressBar
extends android.widget.ProgressBar {
    private static final int MAX_LEVEL = 10000;
    private static final int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    private AccessibilityEventSender mAccessibilityEventSender;
    private AlphaAnimation mAnimation;
    private boolean mAttached;
    private int mBehavior;
    private Drawable mCurrentDrawable;
    private int mDuration;
    private boolean mHasAnimation;
    private boolean mIndeterminate;
    private Drawable mIndeterminateDrawable;
    private boolean mInDrawing;
    private Interpolator mInterpolator;
    private int mMax;
    protected int mMinWidth;
    protected int mMaxWidth;
    protected int mMinHeight;
    protected int mMaxHeight;
    private boolean mNoInvalidate;
    private boolean mOnlyIndeterminate;
    private int mProgress;
    private Drawable mProgressDrawable;
    private final ArrayList<RefreshData> mRefreshData = new ArrayList();
    private boolean mRefreshIsPosted;
    private RefreshProgressRunnable mRefreshProgressRunnable;
    private Bitmap mSampleTile;
    private int mSecondaryProgress;
    private boolean mShouldStartAnimationDrawable;
    private Transformation mTransformation;
    private long mUiThreadId = Thread.currentThread().getId();

    public ProgressBar(Context context) {
        this(context, null);
    }

    public ProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010077);
    }

    public ProgressBar(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, R.style.Holo_ProgressBar);
    }

    public ProgressBar(Context context, AttributeSet attrs, int defStyle, int styleRes) {
        super(context, attrs, defStyle);
        this.initProgressBar();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressBar, defStyle, styleRes);
        this.mNoInvalidate = true;
        Drawable drawable2 = a.getDrawable(8);
        if (drawable2 != null) {
            drawable2 = this.tileify(drawable2, false);
            this.setProgressDrawable(drawable2);
        }
        this.mDuration = a.getInt(9, this.mDuration);
        this.mMinWidth = a.getDimensionPixelSize(11, this.mMinWidth);
        this.mMaxWidth = a.getDimensionPixelSize(0, this.mMaxWidth);
        this.mMinHeight = a.getDimensionPixelSize(12, this.mMinHeight);
        this.mMaxHeight = a.getDimensionPixelSize(1, this.mMaxHeight);
        this.mBehavior = a.getInt(10, this.mBehavior);
        int resID = a.getResourceId(13, 17432587);
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        this.setMax(a.getInt(2, this.mMax));
        this.setProgress(a.getInt(3, this.mProgress));
        this.setSecondaryProgress(a.getInt(4, this.mSecondaryProgress));
        drawable2 = DrawableCompat.getDrawable(a, 7);
        if (drawable2 != null) {
            drawable2 = this.tileifyIndeterminate(drawable2);
            this.setIndeterminateDrawable(drawable2);
        }
        this.mOnlyIndeterminate = a.getBoolean(6, this.mOnlyIndeterminate);
        this.mNoInvalidate = false;
        this.setIndeterminate(this.mOnlyIndeterminate || a.getBoolean(5, this.mIndeterminate));
        a.recycle();
    }

    private synchronized void doRefreshProgress(int id2, int progress, boolean fromUser, boolean callBackToApp) {
        float scale = this.mMax > 0 ? (float)progress / (float)this.mMax : 0.0f;
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            Drawable progressDrawable = null;
            if (d instanceof LayerDrawable) {
                progressDrawable = ((LayerDrawable)d).findDrawableByLayerId(id2);
            }
            int level = (int)(scale * 10000.0f);
            (progressDrawable != null ? progressDrawable : d).setLevel(level);
        } else {
            this.invalidate();
        }
        if (callBackToApp && id2 == R.id.progress) {
            this.onProgressRefresh(scale, fromUser);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    protected Drawable getCurrentDrawable() {
        return this.mCurrentDrawable;
    }

    private Shape getDrawableShape() {
        float[] roundedCorners = new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
        return new RoundRectShape(roundedCorners, null, null);
    }

    public Drawable getIndeterminateDrawable() {
        return this.mIndeterminateDrawable;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized int getMax() {
        return this.mMax;
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized int getProgress() {
        return this.mIndeterminate ? 0 : this.mProgress;
    }

    public Drawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    public int getResolvedLayoutDirection() {
        return 0;
    }

    public int getResolvedLayoutDirection(Drawable who) {
        return who == this.mProgressDrawable || who == this.mIndeterminateDrawable ? this.getResolvedLayoutDirection() : 0;
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized int getSecondaryProgress() {
        return this.mIndeterminate ? 0 : this.mSecondaryProgress;
    }

    public final synchronized void incrementProgress(int diff) {
        this.setProgress(this.mProgress + diff);
    }

    public final synchronized void incrementSecondaryProgress(int diff) {
        this.setSecondaryProgress(this.mSecondaryProgress + diff);
    }

    private void initProgressBar() {
        this.mMax = 100;
        this.mProgress = 0;
        this.mSecondaryProgress = 0;
        this.mIndeterminate = false;
        this.mOnlyIndeterminate = false;
        this.mDuration = 4000;
        this.mBehavior = 1;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    public void invalidateDrawable(Drawable dr) {
        if (!this.mInDrawing) {
            if (this.verifyDrawable(dr)) {
                Rect dirty = dr.getBounds();
                int scrollX = this.getScrollX() + this.getPaddingLeft();
                int scrollY = this.getScrollY() + this.getPaddingTop();
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            } else {
                super.invalidateDrawable(dr);
            }
        }
    }

    @ViewDebug.ExportedProperty(category="progress")
    public synchronized boolean isIndeterminate() {
        return this.mIndeterminate;
    }

    @SuppressLint(value={"NewApi"})
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.jumpToCurrentState();
        }
        if (this.mIndeterminateDrawable != null) {
            this.mIndeterminateDrawable.jumpToCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndeterminate) {
            this.startAnimation();
        }
        if (this.mRefreshData != null) {
            ProgressBar progressBar = this;
            synchronized (progressBar) {
                int count = this.mRefreshData.size();
                for (int i = 0; i < count; ++i) {
                    RefreshData rd = this.mRefreshData.get(i);
                    this.doRefreshProgress(rd.id, rd.progress, rd.fromUser, true);
                    rd.recycle();
                }
                this.mRefreshData.clear();
            }
        }
        this.mAttached = true;
    }

    protected void onDetachedFromWindow() {
        if (this.mIndeterminate) {
            this.stopAnimation();
        }
        if (this.mRefreshProgressRunnable != null) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
        }
        if (this.mRefreshProgressRunnable != null && this.mRefreshIsPosted) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
        }
        if (this.mAccessibilityEventSender != null) {
            this.removeCallbacks(this.mAccessibilityEventSender);
        }
        super.onDetachedFromWindow();
        this.mAttached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            long time = this.getDrawingTime();
            if (this.mHasAnimation) {
                this.mAnimation.getTransformation(time, this.mTransformation);
                float scale = this.mTransformation.getAlpha();
                try {
                    this.mInDrawing = true;
                    d.setLevel((int)(scale * 10000.0f));
                }
                finally {
                    this.mInDrawing = false;
                }
                this.postInvalidate();
            }
            d.draw(canvas);
            canvas.restore();
            if (this.mShouldStartAnimationDrawable && d instanceof Animatable) {
                ((Animatable)d).start();
                this.mShouldStartAnimationDrawable = false;
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)ProgressBar.class.getName());
        event.setItemCount(this.mMax);
        event.setCurrentItemIndex(this.mProgress);
    }

    @SuppressLint(value={"NewApi"})
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)ProgressBar.class.getName());
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.mCurrentDrawable;
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
        }
        this.updateDrawableState();
        this.setMeasuredDimension(_View.supportResolveSizeAndState(dw += this.getPaddingLeft() + this.getPaddingRight(), widthMeasureSpec, 0), _View.supportResolveSizeAndState(dh += this.getPaddingTop() + this.getPaddingBottom(), heightMeasureSpec, 0));
    }

    protected void onProgressRefresh(float scale, boolean fromUser) {
        try {
            if (((AccessibilityManager)AccessibilityManager.class.getMethod("getInstance", Context.class).invoke(null, this.getContext())).isEnabled()) {
                this.scheduleAccessibilityEventSender();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setProgress(ss.progress);
        this.setSecondaryProgress(ss.secondaryProgress);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.progress = this.mProgress;
        ss.secondaryProgress = this.mSecondaryProgress;
        return ss;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateDrawableBounds(w, h);
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mIndeterminate) {
            if (visibility == 8 || visibility == 4) {
                this.stopAnimation();
            } else {
                this.startAnimation();
            }
        }
    }

    public void postInvalidate() {
        if (!this.mNoInvalidate) {
            super.postInvalidate();
        }
    }

    private synchronized void refreshProgress(int id2, int progress, boolean fromUser) {
        if (this.mUiThreadId == Thread.currentThread().getId()) {
            this.doRefreshProgress(id2, progress, fromUser, true);
        } else if (this.mRefreshData != null) {
            if (this.mRefreshProgressRunnable == null) {
                this.mRefreshProgressRunnable = new RefreshProgressRunnable();
            }
            RefreshData rd = RefreshData.obtain(id2, progress, fromUser);
            this.mRefreshData.add(rd);
            if (this.mAttached && !this.mRefreshIsPosted) {
                this.post(this.mRefreshProgressRunnable);
                this.mRefreshIsPosted = true;
            }
        }
    }

    private void scheduleAccessibilityEventSender() {
        if (this.mAccessibilityEventSender == null) {
            this.mAccessibilityEventSender = new AccessibilityEventSender();
        } else {
            this.removeCallbacks(this.mAccessibilityEventSender);
        }
        this.postDelayed(this.mAccessibilityEventSender, 200L);
    }

    public synchronized void setIndeterminate(boolean indeterminate) {
        if (!(this.mOnlyIndeterminate && this.mIndeterminate || indeterminate == this.mIndeterminate)) {
            this.mIndeterminate = indeterminate;
            if (indeterminate) {
                this.mCurrentDrawable = this.mIndeterminateDrawable;
                this.startAnimation();
            } else {
                this.mCurrentDrawable = this.mProgressDrawable;
                this.stopAnimation();
            }
        }
    }

    public void setIndeterminateDrawable(Drawable d) {
        if (d != null) {
            d.setCallback((Drawable.Callback)this);
        }
        this.mIndeterminateDrawable = d;
        if (this.mIndeterminate) {
            this.mCurrentDrawable = d;
            this.postInvalidate();
        }
    }

    public void setInterpolator(Context context, int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resID));
    }

    public void setInterpolator(Interpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            max = 0;
        }
        if (max != this.mMax) {
            this.mMax = max;
            this.postInvalidate();
            if (this.mProgress > max) {
                this.mProgress = max;
            }
            this.refreshProgress(R.id.progress, this.mProgress, false);
        }
    }

    public synchronized void setProgress(int progress) {
        this.setProgress(progress, false);
    }

    synchronized void setProgress(int progress, boolean fromUser) {
        if (this.mIndeterminate) {
            return;
        }
        if (progress < 0) {
            progress = 0;
        }
        if (progress > this.mMax) {
            progress = this.mMax;
        }
        if (progress != this.mProgress) {
            this.mProgress = progress;
            this.refreshProgress(R.id.progress, this.mProgress, fromUser);
        }
    }

    public void setProgressDrawable(Drawable d) {
        boolean needUpdate;
        if (this.mProgressDrawable != null && d != this.mProgressDrawable) {
            this.mProgressDrawable.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (d != null) {
            d.setCallback((Drawable.Callback)this);
            int drawableHeight = d.getMinimumHeight();
            if (this.mMaxHeight < drawableHeight) {
                this.mMaxHeight = drawableHeight;
                this.requestLayout();
            }
        }
        this.mProgressDrawable = d;
        if (!this.mIndeterminate) {
            this.mCurrentDrawable = d;
            this.postInvalidate();
        }
        if (needUpdate) {
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
            this.updateDrawableState();
            this.doRefreshProgress(R.id.progress, this.mProgress, false, false);
            this.doRefreshProgress(R.id.secondaryProgress, this.mSecondaryProgress, false, false);
        }
    }

    public synchronized void setSecondaryProgress(int secondaryProgress) {
        if (this.mIndeterminate) {
            return;
        }
        if (secondaryProgress < 0) {
            secondaryProgress = 0;
        }
        if (secondaryProgress > this.mMax) {
            secondaryProgress = this.mMax;
        }
        if (secondaryProgress != this.mSecondaryProgress) {
            this.mSecondaryProgress = secondaryProgress;
            this.refreshProgress(R.id.secondaryProgress, this.mSecondaryProgress, false);
        }
    }

    public void setVisibility(int v) {
        if (this.getVisibility() != v) {
            super.setVisibility(v);
            if (this.mIndeterminate) {
                if (v == 8 || v == 4) {
                    this.stopAnimation();
                } else {
                    this.startAnimation();
                }
            }
        }
    }

    void startAnimation() {
        if (this.getVisibility() != 0) {
            return;
        }
        if (this.mIndeterminateDrawable instanceof Animatable) {
            this.mShouldStartAnimationDrawable = true;
            this.mHasAnimation = false;
        } else {
            this.mHasAnimation = true;
            if (this.mInterpolator == null) {
                this.mInterpolator = new LinearInterpolator();
            }
            if (this.mTransformation == null) {
                this.mTransformation = new Transformation();
            } else {
                this.mTransformation.clear();
            }
            if (this.mAnimation == null) {
                this.mAnimation = new AlphaAnimation(0.0f, 1.0f);
            } else {
                this.mAnimation.reset();
            }
            this.mAnimation.setRepeatMode(this.mBehavior);
            this.mAnimation.setRepeatCount(-1);
            this.mAnimation.setDuration((long)this.mDuration);
            this.mAnimation.setInterpolator(this.mInterpolator);
            this.mAnimation.setStartTime(-1L);
        }
        this.postInvalidate();
    }

    void stopAnimation() {
        this.mHasAnimation = false;
        if (this.mIndeterminateDrawable instanceof Animatable) {
            ((Animatable)this.mIndeterminateDrawable).stop();
            this.mShouldStartAnimationDrawable = false;
        }
        this.postInvalidate();
    }

    private Drawable tileify(Drawable drawable2, boolean clip) {
        if (drawable2 instanceof LayerDrawable) {
            LayerDrawable background = (LayerDrawable)drawable2;
            int N = background.getNumberOfLayers();
            Drawable[] outDrawables = new Drawable[N];
            for (int i = 0; i < N; ++i) {
                int id2 = background.getId(i);
                outDrawables[i] = this.tileify(background.getDrawable(i), id2 == R.id.progress || id2 == R.id.secondaryProgress);
            }
            LayerDrawable newBg = new LayerDrawable(outDrawables);
            for (int i = 0; i < N; ++i) {
                newBg.setId(i, background.getId(i));
            }
            return newBg;
        }
        if (drawable2 instanceof StateListDrawable) {
            StateListDrawable in = (StateListDrawable)drawable2;
            StateListDrawable out = new StateListDrawable();
            int numStates = ReflectHelper.invoke((Object)in, "getStateCount", Integer.TYPE, new Object[0]);
            for (int i = 0; i < numStates; ++i) {
                out.addState(ReflectHelper.invoke((Object)in, "getStateSet", int[].class, i), this.tileify(ReflectHelper.invoke((Object)in, "getStateDrawable", Drawable.class, i), clip));
            }
            return out;
        }
        if (drawable2 instanceof BitmapDrawable) {
            Bitmap tileBitmap = ((BitmapDrawable)drawable2).getBitmap();
            if (this.mSampleTile == null) {
                this.mSampleTile = tileBitmap;
            }
            ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
            BitmapShader bitmapShader = new BitmapShader(tileBitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            shapeDrawable.getPaint().setShader((Shader)bitmapShader);
            return clip ? new ClipDrawable((Drawable)shapeDrawable, 3, 1) : shapeDrawable;
        }
        return drawable2;
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable background = (AnimationDrawable)drawable2;
            int N = background.getNumberOfFrames();
            AnimationDrawable newBg = new AnimationDrawable();
            newBg.setOneShot(background.isOneShot());
            for (int i = 0; i < N; ++i) {
                Drawable frame = this.tileify(background.getFrame(i), true);
                frame.setLevel(10000);
                newBg.addFrame(frame, background.getDuration(i));
            }
            newBg.setLevel(10000);
            drawable2 = newBg;
        }
        return drawable2;
    }

    private void updateDrawableBounds(int w, int h) {
        int right = w - this.getPaddingRight() - this.getPaddingLeft();
        int bottom = h - this.getPaddingBottom() - this.getPaddingTop();
        int top = 0;
        int left = 0;
        if (this.mIndeterminateDrawable != null) {
            float boundAspect;
            int intrinsicHeight;
            int intrinsicWidth;
            float intrinsicAspect;
            if (this.mOnlyIndeterminate && !(this.mIndeterminateDrawable instanceof AnimationDrawable) && (intrinsicAspect = (float)(intrinsicWidth = this.mIndeterminateDrawable.getIntrinsicWidth()) / (float)(intrinsicHeight = this.mIndeterminateDrawable.getIntrinsicHeight())) != (boundAspect = (float)w / (float)h)) {
                if (boundAspect > intrinsicAspect) {
                    int width = (int)((float)h * intrinsicAspect);
                    left = (w - width) / 2;
                    right = left + width;
                } else {
                    int height = (int)((float)w * (1.0f / intrinsicAspect));
                    top = (h - height) / 2;
                    bottom = top + height;
                }
            }
            this.mIndeterminateDrawable.setBounds(left, top, right, bottom);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setBounds(0, 0, right, bottom);
        }
    }

    private void updateDrawableState() {
        int[] state = this.getDrawableState();
        if (this.mProgressDrawable != null && this.mProgressDrawable.isStateful()) {
            this.mProgressDrawable.setState(state);
        }
        if (this.mIndeterminateDrawable != null && this.mIndeterminateDrawable.isStateful()) {
            this.mIndeterminateDrawable.setState(state);
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mProgressDrawable || who == this.mIndeterminateDrawable || super.verifyDrawable(who);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int progress;
        int secondaryProgress;

        protected SavedState(Parcel in) {
            super(in);
            this.progress = in.readInt();
            this.secondaryProgress = in.readInt();
        }

        protected SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
            out.writeInt(this.secondaryProgress);
        }
    }

    private class RefreshProgressRunnable
    implements Runnable {
        private RefreshProgressRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ProgressBar progressBar = ProgressBar.this;
            synchronized (progressBar) {
                int count = ProgressBar.this.mRefreshData.size();
                for (int i = 0; i < count; ++i) {
                    RefreshData rd = (RefreshData)ProgressBar.this.mRefreshData.get(i);
                    ProgressBar.this.doRefreshProgress(rd.id, rd.progress, rd.fromUser, true);
                    rd.recycle();
                }
                ProgressBar.this.mRefreshData.clear();
                ProgressBar.this.mRefreshIsPosted = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefreshData
    implements Poolable<RefreshData> {
        private static final int POOL_MAX = 24;
        private static final Pool<RefreshData> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<RefreshData>(){

            @Override
            public RefreshData newInstance() {
                return new RefreshData();
            }

            @Override
            public void onAcquired(RefreshData element) {
            }

            @Override
            public void onReleased(RefreshData element) {
            }
        }, 24));
        public boolean fromUser;
        public int id;
        private boolean mIsPooled;
        private RefreshData mNext;
        public int progress;

        private RefreshData() {
        }

        public static RefreshData obtain(int id2, int progress, boolean fromUser) {
            RefreshData rd = sPool.acquire();
            rd.id = id2;
            rd.progress = progress;
            rd.fromUser = fromUser;
            return rd;
        }

        @Override
        public RefreshData getNextPoolable() {
            return this.mNext;
        }

        @Override
        public boolean isPooled() {
            return this.mIsPooled;
        }

        public void recycle() {
            sPool.release(this);
        }

        @Override
        public void setNextPoolable(RefreshData element) {
            this.mNext = element;
        }

        @Override
        public void setPooled(boolean isPooled) {
            this.mIsPooled = isPooled;
        }
    }

    private class AccessibilityEventSender
    implements Runnable {
        private AccessibilityEventSender() {
        }

        public void run() {
            ProgressBar.this.sendAccessibilityEvent(4);
        }
    }
}

