/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;
import org.holoeverywhere.FontLoader;
import org.holoeverywhere.R;

public class TextView
extends android.widget.TextView
implements FontLoader.FontStyleProvider {
    private static final int[] Font = new int[]{16842902, 16842903, 16843692};
    private static final int Font_fontFamily = 2;
    private static final int Font_textStyle = 1;
    private static final int Font_typeface = 0;
    public static final int TEXT_STYLE_BLACK = 8;
    public static final int TEXT_STYLE_BOLD = 1;
    public static final int TEXT_STYLE_CONDENDSED = 16;
    public static final int TEXT_STYLE_ITALIC = 2;
    public static final int TEXT_STYLE_LIGHT = 4;
    public static final int TEXT_STYLE_MEDIUM = 32;
    public static final int TEXT_STYLE_NORMAL = 0;
    public static final int TEXT_STYLE_THIN = 64;
    private boolean allCaps = false;
    private int mFontStyle;
    private CharSequence originalText;
    private TextView.BufferType originalType;

    private static int parse(String string2) {
        int c = string2.lastIndexOf(45);
        if (c > 0) {
            string2 = string2.substring(c + 1);
        }
        int i = 0;
        if (string2.contains("bold")) {
            i |= 1;
        }
        if (string2.contains("italic")) {
            i |= 2;
        }
        if (string2.contains("light")) {
            i |= 4;
        }
        if (string2.contains("black")) {
            i |= 8;
        }
        if (string2.contains("condensed")) {
            i |= 0x10;
        }
        if (string2.contains("medium")) {
            i |= 0x20;
        }
        if (string2.contains("thin")) {
            i |= 0x40;
        }
        return i;
    }

    @SuppressLint(value={"InlinedApi"})
    public static int parseFontStyle(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, Font, defStyleAttr, 0);
        TypedValue value = new TypedValue();
        a.getValue(2, value);
        if (value.string != null) {
            a.recycle();
            return TextView.parse(value.string.toString());
        }
        int i = 0;
        a.getValue(0, value);
        if (value.string != null) {
            i |= TextView.parse(value.string.toString());
        }
        a.recycle();
        return i |= a.getInt(1, 0);
    }

    public TextView(Context context) {
        this(context, null);
    }

    public TextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public TextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TextView, defStyle, 0);
        this.allCaps = a.hasValue(1) ? a.getBoolean(1, false) : a.getBoolean(2, false);
        CharSequence text = null;
        if (a.hasValue(0)) {
            text = a.getText(0);
        }
        a.recycle();
        if (text != null) {
            this.setText(text);
        }
        this.mFontStyle = TextView.parseFontStyle(context, attrs, defStyle);
    }

    @SuppressLint(value={"NewApi"})
    public void dispatchDisplayHint(int hint) {
        this.onDisplayHint(hint);
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public boolean isAllCaps() {
        return this.allCaps;
    }

    @SuppressLint(value={"NewApi"})
    protected void onDisplayHint(int hint) {
        if (Build.VERSION.SDK_INT >= 8) {
            super.onDisplayHint(hint);
        }
    }

    public void setAllCaps(boolean allCaps) {
        this.allCaps = allCaps;
        this.updateTextState();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.originalText = text;
        this.originalType = type;
        this.updateTextState();
    }

    private void updateTextState() {
        if (this.originalText == null) {
            super.setText(null, this.originalType);
            return;
        }
        super.setText(this.allCaps ? this.originalText.toString().toUpperCase() : this.originalText, this.originalType);
    }
}

