/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.holoeverywhere.builder.Parseable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Block
implements Parseable<JSONObject, Block> {
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    public Map<String, String> data = new HashMap<String, String>();
    public List<String> include = new ArrayList<String>();
    public String parent;

    @Override
    public Block parse(JSONObject data) {
        this.parent = null;
        this.include.clear();
        this.data.clear();
        if (data.has("include")) {
            JSONArray a = data.optJSONArray("include");
            for (int i = 0; i < a.length(); ++i) {
                this.include.add(String.valueOf(a.opt(i)));
            }
        }
        if (data.has("parent")) {
            this.parent = data.optString("parent");
        }
        Iterator keys = data.sortedKeys();
        while (keys.hasNext()) {
            String value;
            String key = (String)keys.next();
            if ("include".equals(key) || "parent".equals(key) || (value = String.valueOf(data.opt(key))) == null) continue;
            this.data.put(key, value);
        }
        return this;
    }

    public void process(XMLStreamWriter writer, Map<String, Block> blocks) throws XMLStreamException {
        if (this.parent != null) {
            writer.writeAttribute("parent", this.parent);
        }
        for (String i : this.include) {
            if (blocks.containsKey(i)) {
                writer.writeComment("Include block: " + i);
                blocks.get(i).process(writer, blocks);
                writer.writeComment("End of block " + i);
                continue;
            }
            writer.writeComment(" Block not found: " + i + " ");
        }
        TreeMap<String, String> data = new TreeMap<String, String>(COMPARATOR);
        data.putAll(this.data);
        for (Map.Entry entry : data.entrySet()) {
            writer.writeStartElement("item");
            writer.writeAttribute("name", (String)entry.getKey());
            writer.writeCharacters((String)entry.getValue());
            writer.writeEndElement();
        }
    }
}

