/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.holoeverywhere.builder.Document;
import org.holoeverywhere.builder.Parser;
import org.holoeverywhere.builder.Processer;

public class Builder
extends AbstractMojo {
    private String[] input;
    private File outputDir;
    private File includeDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.input.length == 0) {
            this.getLog().info((CharSequence)"Not need to generate resources");
            return;
        }
        Parser.setSourcePath(this.includeDir);
        try {
            this.getLog().info((CharSequence)"");
            for (String file : this.input) {
                this.process(file);
                this.getLog().info((CharSequence)"");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException", (Exception)e);
        }
    }

    public void process(String sourceName) throws MojoExecutionException, MojoFailureException, IOException {
        File source = new File(this.includeDir, sourceName);
        if (!Builder.validFile(source)) {
            throw new MojoFailureException("Source " + source.getAbsolutePath() + " doesn't exists");
        }
        Document document = Parser.parse(source);
        if (document.output == null) {
            this.getLog().warn((CharSequence)(source.getCanonicalPath() + " don't has output file, ignore"));
            return;
        }
        File output = new File(this.outputDir, document.output);
        this.getLog().info((CharSequence)("Compile " + source.getName() + " => " + output.getCanonicalPath()));
        try {
            Processer.process(document, new FileOutputStream(output));
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Error while processing " + source.getCanonicalPath()), (Throwable)e);
        }
    }

    private static boolean validFile(File file) {
        return file.exists() && file.isFile();
    }
}

