/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.holoeverywhere.builder.Block;
import org.holoeverywhere.builder.IncludeRow;
import org.holoeverywhere.builder.Parseable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Document
implements Parseable<JSONObject, Document> {
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    public Map<String, Block> blocks = new HashMap<String, Block>();
    public Map<String, Block> data = new HashMap<String, Block>();
    public List<IncludeRow> include = new ArrayList<IncludeRow>();
    public String output;

    @Override
    public Document parse(JSONObject json) {
        String key;
        this.include.clear();
        this.blocks.clear();
        this.data.clear();
        this.output = null;
        if (json.has("include")) {
            JSONArray include = json.optJSONArray("include");
            for (int i = 0; i < include.length(); ++i) {
                this.include.add(new IncludeRow().parse(include.optJSONObject(i)));
            }
        }
        if (json.has("blocks")) {
            JSONObject blocks = json.optJSONObject("blocks");
            Iterator keys = blocks.sortedKeys();
            while (keys.hasNext()) {
                key = (String)keys.next();
                this.blocks.put(key, new Block().parse(blocks.optJSONObject(key)));
            }
        }
        if (json.has("data")) {
            JSONObject data = json.optJSONObject("data");
            Iterator keys = data.sortedKeys();
            while (keys.hasNext()) {
                key = (String)keys.next();
                this.data.put(key, new Block().parse(data.optJSONObject(key)));
            }
        }
        if (json.has("output")) {
            this.output = json.optString("output");
        }
        return this;
    }

    public synchronized void process(XMLStreamWriter writer) throws XMLStreamException {
        HashMap<String, Block> blocks = new HashMap<String, Block>(this.blocks);
        HashMap<String, Block> dataS = new HashMap<String, Block>(this.data);
        for (IncludeRow i : this.include) {
            i.process(blocks, dataS);
        }
        TreeMap<String, Block> data = new TreeMap<String, Block>(COMPARATOR);
        data.putAll(dataS);
        for (Map.Entry entry : data.entrySet()) {
            writer.writeStartElement("style");
            writer.writeAttribute("name", (String)entry.getKey());
            ((Block)entry.getValue()).process(writer, blocks);
            writer.writeEndElement();
        }
    }
}

